/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.exception.ApiInvalidTypeException;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.NewHttpApi;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.ApiDefinition;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;

@UseCase
public class CreateHttpApiUseCase {
    private static final List<ApiType> SUPPORTED_API_TYPES = List.of(ApiType.PROXY, ApiType.MESSAGE, ApiType.MCP_PROXY, ApiType.LLM_PROXY);
    private final ValidateApiDomainService validateApiDomainService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final CreateApiDomainService createApiDomainService;

    public CreateHttpApiUseCase(ValidateApiDomainService validateApiDomainService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, CreateApiDomainService createApiDomainService) {
        this.validateApiDomainService = validateApiDomainService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.createApiDomainService = createApiDomainService;
    }

    public Output execute(Input input) {
        ApiDefinition apiDefinition;
        AuditInfo auditInfo = input.auditInfo;
        PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(auditInfo.organizationId(), auditInfo.environmentId(), auditInfo.actor().userId());
        io.gravitee.apim.core.api.model.Api newApi = ApiModelFactory.fromNewHttpApi(input.newHttpApi, auditInfo.environmentId());
        if (newApi.getType() == ApiType.LLM_PROXY && (apiDefinition = newApi.getApiDefinitionValue()) instanceof Api) {
            Api v4Api = (Api)apiDefinition;
            v4Api.setFlows(CreateHttpApiUseCase.defaultFlowsLlmProxy());
        }
        ApiWithFlows created = this.createApiDomainService.create(newApi, primaryOwner, auditInfo, api -> this.validateApiDomainService.validateAndSanitizeForCreation((io.gravitee.apim.core.api.model.Api)api, primaryOwner, auditInfo.environmentId(), auditInfo.organizationId()), ApiIndexerDomainService.oneShotIndexation(auditInfo));
        return new Output(created);
    }

    private static @NonNull List<Flow> defaultFlowsLlmProxy() {
        return List.of(new Flow().withSelectors(List.of(HttpSelector.builder().pathOperator(Operator.EQUALS).path("/chat/completions").methods(Set.of(HttpMethod.POST)).build())), new Flow().withSelectors(List.of(HttpSelector.builder().pathOperator(Operator.EQUALS).path("/models").methods(Set.of(HttpMethod.GET)).build())), new Flow().withSelectors(List.of(HttpSelector.builder().pathOperator(Operator.EQUALS).path("/embeddings").methods(Set.of(HttpMethod.POST)).build())));
    }

    public record Input(NewHttpApi newHttpApi, AuditInfo auditInfo) {
        public Input {
            if (newHttpApi == null || !SUPPORTED_API_TYPES.contains(newHttpApi.getType())) {
                throw new ApiInvalidTypeException(SUPPORTED_API_TYPES);
            }
        }
    }

    public record Output(ApiWithFlows api) {
    }
}

