/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service.import_definition;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.ApiIdsCalculatorDomainService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateNativeApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.domain_service.import_definition.ImportDefinitionMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.import_definition.ImportDefinitionPageDomainService;
import io.gravitee.apim.core.api.domain_service.import_definition.ImportDefinitionPlanDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.api.model.import_definition.ApiExport;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinitionSubEntityProcessor;
import io.gravitee.apim.core.api.service_provider.ApiImagesServiceProvider;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.definition.model.ApiDefinition;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import java.util.function.UnaryOperator;

@DomainService
public class ImportDefinitionUpdateDomainService {
    private final UpdateApiDomainService updateApiDomainService;
    private final ApiImagesServiceProvider apiImagesServiceProvider;
    private final ApiIdsCalculatorDomainService apiIdsCalculatorDomainService;
    private final UpdateNativeApiDomainService updateNativeApiDomainService;
    private final ValidateApiDomainService validateApiDomainService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ImportDefinitionMetadataDomainService importDefinitionMetadataDomainService;
    private final ImportDefinitionPlanDomainService importDefinitionPlanDomainService;
    private final ImportDefinitionPageDomainService importDefinitionPageDomainService;

    ImportDefinitionUpdateDomainService(UpdateApiDomainService updateApiDomainService, ApiImagesServiceProvider apiImagesServiceProvider, ApiIdsCalculatorDomainService apiIdsCalculatorDomainService, UpdateNativeApiDomainService updateNativeApiDomainService, ValidateApiDomainService validateApiDomainService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ImportDefinitionMetadataDomainService importDefinitionMetadataDomainService, ImportDefinitionPlanDomainService importDefinitionPlanDomainService, ImportDefinitionPageDomainService importDefinitionPageDomainService) {
        this.updateApiDomainService = updateApiDomainService;
        this.apiImagesServiceProvider = apiImagesServiceProvider;
        this.apiIdsCalculatorDomainService = apiIdsCalculatorDomainService;
        this.updateNativeApiDomainService = updateNativeApiDomainService;
        this.validateApiDomainService = validateApiDomainService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.importDefinitionMetadataDomainService = importDefinitionMetadataDomainService;
        this.importDefinitionPlanDomainService = importDefinitionPlanDomainService;
        this.importDefinitionPageDomainService = importDefinitionPageDomainService;
    }

    public Api update(ImportDefinition importDefinition, Api existingPromotedApi, AuditInfo auditInfo) {
        String apiId = existingPromotedApi.getId();
        ImportDefinition apiWithIds = this.apiIdsCalculatorDomainService.recalculateApiDefinitionIds(auditInfo.environmentId(), importDefinition);
        ApiExport apiExport = apiWithIds.getApiExport();
        Api updatedApi = switch (existingPromotedApi.getType()) {
            case ApiType.PROXY, ApiType.MESSAGE -> this.updateApiDomainService.updateV4(ApiModelFactory.fromApiExport(apiExport, auditInfo.environmentId()), auditInfo);
            case ApiType.NATIVE -> this.updateNativeApi(apiId, apiWithIds.getApiExport(), auditInfo);
            default -> throw new IllegalStateException("Unsupported API type: " + String.valueOf(existingPromotedApi.getType()));
        };
        this.apiImagesServiceProvider.updateApiPicture(apiId, apiExport.getPicture(), auditInfo);
        this.apiImagesServiceProvider.updateApiBackground(apiId, apiExport.getBackground(), auditInfo);
        new ImportDefinitionSubEntityProcessor(updatedApi.getId()).addSubEntity("Metadata", () -> this.importDefinitionMetadataDomainService.upsertMetadata(apiId, importDefinition.getMetadata(), auditInfo)).addSubEntity("Pages", () -> this.importDefinitionPageDomainService.upsertPages(apiId, apiWithIds.getPages(), auditInfo)).addSubEntity("Plans", () -> this.importDefinitionPlanDomainService.upsertPlanWithFlows(existingPromotedApi, importDefinition.getPlans(), auditInfo)).process();
        return updatedApi;
    }

    private Api updateNativeApi(String apiId, ApiExport apiExport, AuditInfo auditInfo) {
        PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(auditInfo.organizationId(), apiId);
        UnaryOperator<Api> updateOperator = this.toNativeApiUpdateOperator(apiExport);
        return this.updateNativeApiDomainService.update(apiId, updateOperator, (existingApi, apiToUpdate) -> this.validateApiDomainService.validateAndSanitizeForUpdate((Api)existingApi, (Api)apiToUpdate, primaryOwner, auditInfo.environmentId(), auditInfo.organizationId()), auditInfo, primaryOwner, ApiIndexerDomainService.oneShotIndexation(auditInfo));
    }

    private UnaryOperator<Api> toNativeApiUpdateOperator(ApiExport apiExport) {
        return currentApi -> {
            NativeApi nativeApi;
            Object b = ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)currentApi.toBuilder().name(apiExport.getName())).description(apiExport.getDescription())).version(apiExport.getApiVersion())).visibility(apiExport.getVisibility() != null ? Api.Visibility.valueOf(apiExport.getVisibility().toString()) : Api.Visibility.PRIVATE)).labels(apiExport.getLabels())).disableMembershipNotifications(apiExport.isDisableMembershipNotifications());
            ApiDefinition patt0$temp = currentApi.getApiDefinitionValue();
            if (patt0$temp instanceof NativeApi) {
                NativeApi nativeApi2 = (NativeApi)patt0$temp;
                nativeApi = ((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)nativeApi2.toBuilder().name(apiExport.getName())).apiVersion(apiExport.getApiVersion())).tags(apiExport.getTags())).resources(apiExport.getResources())).listeners(apiExport.getListeners() != null ? apiExport.getListeners() : null).endpointGroups(apiExport.getEndpointGroups() != null ? apiExport.getEndpointGroups() : null).flows(apiExport.getFlows() != null ? apiExport.getFlows() : null).properties(apiExport.getProperties())).build();
            } else {
                nativeApi = null;
            }
            return ((Api.ApiBuilder)((Api.ApiBuilder)b).apiDefinitionValue((ApiDefinition)nativeApi)).build();
        };
    }
}

