/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.category.domain_service.CreateCategoryApiDomainService;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.notification.crud_service.NotificationConfigCrudService;
import io.gravitee.apim.core.notification.model.config.NotificationConfig;
import io.gravitee.apim.core.parameters.model.ParameterContext;
import io.gravitee.apim.core.parameters.query_service.ParametersQueryService;
import io.gravitee.apim.core.workflow.crud_service.WorkflowCrudService;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.definition.model.ApiDefinition;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

@DomainService
public class CreateApiDomainService {
    private final ApiCrudService apiCrudService;
    private final AuditDomainService auditService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final FlowCrudService flowCrudService;
    private final NotificationConfigCrudService notificationConfigCrudService;
    private final ParametersQueryService parametersQueryService;
    private final WorkflowCrudService workflowCrudService;
    private final CreateCategoryApiDomainService createCategoryApiDomainService;

    public ApiWithFlows create(io.gravitee.apim.core.api.model.Api api, PrimaryOwnerEntity primaryOwner, AuditInfo auditInfo, UnaryOperator<io.gravitee.apim.core.api.model.Api> sanitizer) {
        return this.create(api, primaryOwner, auditInfo, sanitizer, ApiIndexerDomainService.oneShotIndexation(auditInfo));
    }

    public ApiWithFlows create(io.gravitee.apim.core.api.model.Api api, PrimaryOwnerEntity primaryOwner, AuditInfo auditInfo, UnaryOperator<io.gravitee.apim.core.api.model.Api> sanitizer, ApiIndexerDomainService.Context indexContext) {
        io.gravitee.apim.core.api.model.Api sanitized = (io.gravitee.apim.core.api.model.Api)sanitizer.apply(api);
        io.gravitee.apim.core.api.model.Api created = this.apiCrudService.create(sanitized);
        this.createAuditLog(created, auditInfo);
        this.apiPrimaryOwnerDomainService.createApiPrimaryOwnerMembership(created.getId(), primaryOwner, auditInfo);
        this.createDefaultMailNotification(created);
        this.createDefaultMetadata(created, auditInfo);
        List<? extends AbstractFlow> createdFlows = this.saveApiFlows(api);
        this.createCategoryApiDomainService.addApiToCategories(api.getId(), api.getCategories());
        if (this.isApiReviewEnabled(created, auditInfo.organizationId(), auditInfo.environmentId())) {
            this.workflowCrudService.create(Workflow.newApiReviewWorkflow(api.getId(), auditInfo.actor().userId()));
        }
        this.apiIndexerDomainService.index(indexContext, created, primaryOwner);
        return new ApiWithFlows(created, createdFlows);
    }

    private void createAuditLog(io.gravitee.apim.core.api.model.Api created, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(created.getId()).event(ApiAuditEvent.API_CREATED).actor(auditInfo.actor()).newValue(created).createdAt(created.getCreatedAt()).properties(Collections.emptyMap()).build());
    }

    private void createDefaultMailNotification(io.gravitee.apim.core.api.model.Api api) {
        switch (api.getDefinitionVersion()) {
            case V4: {
                this.notificationConfigCrudService.create(NotificationConfig.defaultMailNotificationConfigFor(api.getId()));
                break;
            }
        }
    }

    private void createDefaultMetadata(io.gravitee.apim.core.api.model.Api api, AuditInfo auditInfo) {
        switch (api.getDefinitionVersion()) {
            case V4: {
                this.apiMetadataDomainService.createDefaultApiMetadata(api.getId(), auditInfo);
                break;
            }
        }
    }

    private @Nullable List<? extends AbstractFlow> saveApiFlows(io.gravitee.apim.core.api.model.Api api) {
        ApiDefinition apiDefinition = api.getApiDefinitionValue();
        Objects.requireNonNull(apiDefinition);
        ApiDefinition apiDefinition2 = apiDefinition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeApi.class, Api.class}, (Object)apiDefinition2, n)) {
            case 0 -> {
                NativeApi nativeApi = (NativeApi)apiDefinition2;
                yield this.flowCrudService.saveNativeApiFlows(api.getId(), nativeApi.getFlows());
            }
            case 1 -> {
                Api v4Api = (Api)apiDefinition2;
                yield this.flowCrudService.saveApiFlows(v4Api.getId(), v4Api.getFlows());
            }
            default -> null;
        };
    }

    private boolean isApiReviewEnabled(io.gravitee.apim.core.api.model.Api api, String organizationId, String environmentId) {
        return switch (api.getDefinitionVersion()) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4, DefinitionVersion.V1, DefinitionVersion.V2 -> this.parametersQueryService.findAsBoolean(Key.API_REVIEW_ENABLED, new ParameterContext(environmentId, organizationId, ParameterReferenceType.ENVIRONMENT));
            case DefinitionVersion.FEDERATED, DefinitionVersion.FEDERATED_AGENT -> false;
        };
    }

    @Generated
    public CreateApiDomainService(ApiCrudService apiCrudService, AuditDomainService auditService, ApiIndexerDomainService apiIndexerDomainService, ApiMetadataDomainService apiMetadataDomainService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, FlowCrudService flowCrudService, NotificationConfigCrudService notificationConfigCrudService, ParametersQueryService parametersQueryService, WorkflowCrudService workflowCrudService, CreateCategoryApiDomainService createCategoryApiDomainService) {
        this.apiCrudService = apiCrudService;
        this.auditService = auditService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.flowCrudService = flowCrudService;
        this.notificationConfigCrudService = notificationConfigCrudService;
        this.parametersQueryService = parametersQueryService;
        this.workflowCrudService = workflowCrudService;
        this.createCategoryApiDomainService = createCategoryApiDomainService;
    }
}

