/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics_engine.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics_engine.domain_service.AnalyticsQueryValidator;
import io.gravitee.apim.core.analytics_engine.domain_service.BucketNamesPostProcessor;
import io.gravitee.apim.core.analytics_engine.domain_service.FilterPreProcessor;
import io.gravitee.apim.core.analytics_engine.model.Filter;
import io.gravitee.apim.core.analytics_engine.model.MetricsContext;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesRequest;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesResponse;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsEngineQueryService;
import io.gravitee.apim.core.analytics_engine.service_provider.AnalyticsQueryContextProvider;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@UseCase
public class ComputeTimeSeriesUseCase {
    private final AnalyticsQueryContextProvider queryContextProvider;
    private final AnalyticsQueryValidator validator;
    private final FilterPreProcessor filterPreprocessor;
    private final BucketNamesPostProcessor bucketNamesPostprocessor;

    public ComputeTimeSeriesUseCase(AnalyticsQueryContextProvider queryContextProvider, AnalyticsQueryValidator validator, FilterPreProcessor filterPreprocessor, BucketNamesPostProcessor bucketNamesPostprocessor) {
        this.queryContextProvider = queryContextProvider;
        this.validator = validator;
        this.filterPreprocessor = filterPreprocessor;
        this.bucketNamesPostprocessor = bucketNamesPostprocessor;
    }

    public Output execute(Input input) {
        this.validator.validateTimeSeriesRequest(input.request);
        ExecutionContext executionContext = new ExecutionContext(input.auditInfo.organizationId(), input.auditInfo.environmentId());
        MetricsContext metricsContextWithPermissions = this.filterPreprocessor.buildFilters(new MetricsContext(input.auditInfo));
        Map<AnalyticsEngineQueryService, TimeSeriesRequest> queryContext = this.queryContextProvider.resolve(input.request);
        List<TimeSeriesResponse> responses = this.executeQueries(executionContext, metricsContextWithPermissions, queryContext);
        TimeSeriesResponse response = TimeSeriesResponse.merge(responses);
        TimeSeriesResponse mappedResponse = this.bucketNamesPostprocessor.mapBucketNames(metricsContextWithPermissions, input.request.facets(), response);
        return new Output(mappedResponse);
    }

    private List<TimeSeriesResponse> executeQueries(ExecutionContext executionContext, MetricsContext metricsContext, Map<AnalyticsEngineQueryService, TimeSeriesRequest> queryContext) {
        ArrayList<TimeSeriesResponse> responses = new ArrayList<TimeSeriesResponse>();
        queryContext.forEach((queryService, request) -> {
            ArrayList<Filter> filters = new ArrayList<Filter>(request.filters());
            filters.addAll(metricsContext.filters());
            responses.add(queryService.searchTimeSeries(executionContext, request.withFilters(filters)));
        });
        return responses;
    }

    public record Input(AuditInfo auditInfo, TimeSeriesRequest request) {
    }

    public record Output(TimeSeriesResponse response) {
    }
}

