/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.converter.api;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.policy.api.swagger.Policy;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.v4.policy.PolicyPluginEntity;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.impl.swagger.converter.api.OAIToAPIConverter;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.v4.PolicyPluginService;
import io.gravitee.rest.api.service.validator.JsonHelper;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIToAPIV2Converter
extends OAIToAPIConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAIToAPIV2Converter.class);
    private final PolicyPluginService policyPluginService;

    public OAIToAPIV2Converter(ImportSwaggerDescriptorEntity swaggerDescriptor, PolicyOperationVisitorManager policyOperationVisitorManager, GroupService groupService, TagService tagService, PolicyPluginService policyPluginService) {
        super(swaggerDescriptor, policyOperationVisitorManager, groupService, tagService);
        this.policyPluginService = policyPluginService;
    }

    @Override
    protected SwaggerApiEntity fill(SwaggerApiEntity apiEntity, OpenAPI oai) {
        apiEntity.setGraviteeDefinitionVersion(DefinitionVersion.V2.getLabel());
        ArrayList allFlows = new ArrayList();
        HashSet<String> pathMappings = new HashSet<String>();
        if (this.swaggerDescriptor.isWithPolicyPaths() || this.swaggerDescriptor.isWithPathMapping()) {
            oai.getPaths().forEach((key, pathItem) -> {
                String path = PATH_PARAMS_PATTERN.matcher((CharSequence)key).replaceAll(":$1");
                if (this.swaggerDescriptor.isWithPathMapping()) {
                    pathMappings.add(path);
                }
                if (this.swaggerDescriptor.isWithPolicyPaths()) {
                    Map operations = pathItem.readOperationsMap();
                    operations.forEach((httpMethod, operation) -> {
                        Flow flow = this.createFlow(path, Collections.singleton(HttpMethod.valueOf((String)httpMethod.name())));
                        this.getVisitors().forEach(oaiOperationVisitor -> {
                            Optional policy = (Optional)oaiOperationVisitor.visit(oai, operation);
                            if (policy.isPresent()) {
                                Step step = new Step();
                                String policyId = ((Policy)policy.get()).getName();
                                step.setPolicy(policyId);
                                step.setEnabled(true);
                                try {
                                    PolicyPluginEntity plugin = (PolicyPluginEntity)this.policyPluginService.findById(policyId);
                                    step.setName(plugin != null ? plugin.getName() : policyId);
                                }
                                catch (RuntimeException e) {
                                    log.warn("An error occurred while trying to retrieve the policy plugin '{}' for API '{}'. Falling back to policy id.", new Object[]{policyId, apiEntity.getName(), e});
                                    step.setName(policyId);
                                }
                                step.setDescription(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary());
                                String configuration = JsonHelper.clearNullValues(((Policy)policy.get()).getConfiguration());
                                step.setConfiguration(configuration);
                                String scope = JsonHelper.getScope(configuration);
                                if (scope != null && scope.toLowerCase().equals("response")) {
                                    flow.getPost().add(step);
                                } else {
                                    flow.getPre().add(step);
                                }
                            }
                        });
                        allFlows.add(flow);
                    });
                }
            });
        }
        if (pathMappings.isEmpty()) {
            String defaultDeclaredPath = "/";
            pathMappings.add("/");
        }
        apiEntity.setFlows(allFlows);
        apiEntity.setPathMappings(pathMappings);
        return apiEntity;
    }

    private Flow createFlow(String path, Set<HttpMethod> methods) {
        Flow flow = new Flow();
        flow.setName("");
        flow.setCondition("");
        flow.setEnabled(true);
        PathOperator pathOperator = new PathOperator();
        pathOperator.setPath(path);
        pathOperator.setOperator(Operator.EQUALS);
        flow.setPathOperator(pathOperator);
        flow.setMethods(methods);
        return flow;
    }
}

