/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.transformer;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.search.model.IndexableApi;
import io.gravitee.definition.model.ApiDefinition;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.kafka.KafkaListener;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import io.gravitee.rest.api.service.impl.search.lucene.transformer.ApiDocumentTransformer;
import io.gravitee.rest.api.service.impl.search.lucene.utils.LuceneTransformerUtils;
import java.lang.runtime.SwitchBootstraps;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.springframework.stereotype.Component;

@Component
public class IndexableApiDocumentTransformer
implements DocumentTransformer<IndexableApi> {
    private final Collator collator = Collator.getInstance(Locale.ENGLISH);

    @Override
    public Document transform(IndexableApi indexableApi) {
        io.gravitee.apim.core.api.model.Api api = indexableApi.getApi();
        PrimaryOwnerEntity primaryOwner = indexableApi.getPrimaryOwner();
        Map<String, String> metadata = indexableApi.getDecodedMetadata();
        Collection<String> categories = indexableApi.getCategoryKeys();
        if (!this.accept(indexableApi)) {
            throw new TechnicalDomainException("Unsupported definition version: " + String.valueOf(api.getDefinitionVersion()));
        }
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", api.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("type", "api", Field.Store.YES));
        if (api.getDefinitionVersion() == null && api.getName() == null) {
            return doc;
        }
        if (api.getLifecycleState() != null) {
            doc.add((IndexableField)new StringField("status", api.getLifecycleState().name(), Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField("status_sorted", this.toSortedValue(api.getLifecycleState().name())));
        }
        String portalStatus = api.getApiLifecycleState() == Api.ApiLifecycleState.PUBLISHED ? Api.ApiLifecycleState.PUBLISHED.name() : Api.ApiLifecycleState.UNPUBLISHED.name();
        doc.add((IndexableField)new StringField("portal_status", portalStatus, Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("portal_status_sorted", this.toSortedValue(portalStatus)));
        doc.add((IndexableField)new StringField("visibility", api.getVisibility().name(), Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("visibility_sorted", this.toSortedValue(api.getVisibility().name())));
        if (api.getDefinitionVersion() != null) {
            doc.add((IndexableField)new StringField("definition_version", api.getDefinitionVersion().getLabel(), Field.Store.NO));
            Iterator<String> apiType = LuceneTransformerUtils.generateApiType(api);
            doc.add((IndexableField)new StringField("api_type", (String)((Object)apiType), Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField("api_type_sorted", this.toSortedValue((String)((Object)apiType))));
        }
        if (indexableApi.getReferenceId() != null) {
            doc.add((IndexableField)new StringField("reference_type", indexableApi.getReferenceType(), Field.Store.NO));
            doc.add((IndexableField)new StringField("reference_id", indexableApi.getReferenceId(), Field.Store.NO));
        }
        if (api.getName() != null) {
            doc.add((IndexableField)new StringField("name", api.getName(), Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField("name_sorted", this.toSortedValue(api.getName())));
            doc.add((IndexableField)new StringField("name_lowercase", api.getName().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField("name_split", api.getName(), Field.Store.NO));
        }
        if (api.getDescription() != null) {
            doc.add((IndexableField)new StringField("description", api.getDescription(), Field.Store.NO));
            doc.add((IndexableField)new StringField("description_lowercase", api.getDescription().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField("description_split", api.getDescription(), Field.Store.NO));
        }
        if (primaryOwner != null) {
            doc.add((IndexableField)new StringField("ownerName", primaryOwner.displayName(), Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField("owner_sorted", this.toSortedValue(primaryOwner.displayName())));
            doc.add((IndexableField)new StringField("ownerName_lowercase", primaryOwner.displayName().toLowerCase(), Field.Store.NO));
            if (primaryOwner.email() != null) {
                doc.add((IndexableField)new TextField("ownerMail", primaryOwner.email(), Field.Store.NO));
            }
        }
        if (api.getLabels() != null) {
            for (String label : api.getLabels()) {
                doc.add((IndexableField)new StringField("labels", label, Field.Store.YES));
                doc.add((IndexableField)new StringField("labels_lowercase", label.toLowerCase(), Field.Store.NO));
                doc.add((IndexableField)new TextField("labels_split", label, Field.Store.NO));
            }
        }
        if (categories != null && !categories.isEmpty()) {
            for (String category : categories) {
                doc.add((IndexableField)new StringField("categories", category, Field.Store.NO));
                doc.add((IndexableField)new TextField("categories_split", category, Field.Store.NO));
            }
            String categoriesAsc = categories.stream().sorted().collect(Collectors.joining(","));
            String categoriesDesc = categories.stream().sorted(Comparator.reverseOrder()).collect(Collectors.joining(","));
            doc.add((IndexableField)new SortedDocValuesField("categories_asc_sorted", this.toSortedValue(categoriesAsc)));
            doc.add((IndexableField)new SortedDocValuesField("categories_desc_sorted", this.toSortedValue(categoriesDesc)));
        }
        if (api.getCreatedAt() != null) {
            doc.add((IndexableField)new LongPoint("createdAt", new long[]{api.getCreatedAt().toInstant().toEpochMilli()}));
        }
        if (api.getUpdatedAt() != null) {
            doc.add((IndexableField)new LongPoint("updatedAt", new long[]{api.getUpdatedAt().toInstant().toEpochMilli()}));
        }
        if (metadata != null) {
            metadata.values().forEach(metadataValue -> {
                doc.add((IndexableField)new StringField("metadata", metadataValue, Field.Store.NO));
                doc.add((IndexableField)new TextField("metadata_split", metadataValue, Field.Store.NO));
            });
        }
        if (api.getOriginContext() != null && api.getOriginContext().name() != null) {
            doc.add((IndexableField)new StringField("origin", api.getOriginContext().name(), Field.Store.NO));
        }
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            this.transformV4Api(doc, indexableApi);
        } else if (api.getDefinitionVersion() == DefinitionVersion.V2) {
            this.transformV2Api(doc, indexableApi);
        }
        return doc;
    }

    private boolean accept(IndexableApi indexableApi) {
        io.gravitee.apim.core.api.model.Api api = indexableApi.getApi();
        if (api.getDefinitionVersion() != null) {
            return switch (api.getDefinitionVersion()) {
                default -> throw new MatchException(null, null);
                case DefinitionVersion.V4, DefinitionVersion.FEDERATED, DefinitionVersion.FEDERATED_AGENT, DefinitionVersion.V2 -> true;
                case DefinitionVersion.V1 -> false;
            };
        }
        return true;
    }

    private void transformV4Api(Document doc, IndexableApi api) {
        ApiDefinition apiDefinitionV4;
        ApiDefinition apiDefinition = apiDefinitionV4 = api.getApi().getApiDefinitionValue();
        Objects.requireNonNull(apiDefinition);
        ApiDefinition apiDefinition2 = apiDefinition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Api.class, NativeApi.class}, (Object)apiDefinition2, n)) {
            case 0: {
                Api v4Api = (Api)apiDefinition2;
                this.transformV4ApiHttpListeners(doc, v4Api);
                break;
            }
            case 1: {
                NativeApi v4NativeApi = (NativeApi)apiDefinition2;
                this.transformV4ApiNativeListeners(doc, v4NativeApi);
                break;
            }
        }
        if (apiDefinitionV4.getTags() != null && !apiDefinitionV4.getTags().isEmpty()) {
            for (String tag : apiDefinitionV4.getTags()) {
                doc.add((IndexableField)new StringField("tags", tag, Field.Store.NO));
                doc.add((IndexableField)new TextField("tags_split", tag, Field.Store.NO));
            }
            String tagsAsc = apiDefinitionV4.getTags().stream().sorted().collect(Collectors.joining(","));
            String tagsDesc = apiDefinitionV4.getTags().stream().sorted(Comparator.reverseOrder()).collect(Collectors.joining(","));
            doc.add((IndexableField)new SortedDocValuesField("tags_asc_sorted", this.toSortedValue(tagsAsc)));
            doc.add((IndexableField)new SortedDocValuesField("tags_desc_sorted", this.toSortedValue(tagsDesc)));
        }
    }

    private void transformV4ApiHttpListeners(Document doc, Api apiDefinitionV4) {
        if (apiDefinitionV4 != null && apiDefinitionV4.getListeners() != null) {
            int[] pathIndex = new int[]{0};
            apiDefinitionV4.getListeners().stream().filter(listener -> listener.getType() == ListenerType.HTTP).flatMap(listener -> {
                HttpListener httpListener = (HttpListener)listener;
                return httpListener.getPaths().stream();
            }).forEach(path -> {
                this.appendPath(doc, pathIndex, path.getPath());
                this.appendHost(doc, path.getHost());
            });
        }
    }

    private void transformV4ApiNativeListeners(Document doc, NativeApi apiDefinitionV4) {
        if (apiDefinitionV4 != null && apiDefinitionV4.getListeners() != null) {
            apiDefinitionV4.getListeners().stream().filter(listener -> listener.getType() == ListenerType.KAFKA).forEach(listener -> {
                if (listener instanceof KafkaListener) {
                    KafkaListener kafkaListener = (KafkaListener)listener;
                    this.appendHost(doc, kafkaListener.getHost());
                }
            });
        }
    }

    private void appendPath(Document doc, int[] pathIndex, String path) {
        doc.add((IndexableField)new StringField("paths", path, Field.Store.NO));
        doc.add((IndexableField)new StringField("paths_lowercase", path.toLowerCase(), Field.Store.NO));
        doc.add((IndexableField)new TextField("paths_split", path, Field.Store.NO));
        int n = pathIndex[0];
        pathIndex[0] = n + 1;
        if (n == 0) {
            doc.add((IndexableField)new SortedDocValuesField("paths_sorted", this.toSortedValue(path)));
        }
    }

    private void appendHost(Document doc, String host) {
        if (host != null && !host.isEmpty()) {
            doc.add((IndexableField)new StringField("hosts", host, Field.Store.NO));
            doc.add((IndexableField)new StringField("hosts_lowercase", host.toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField("hosts_split", host, Field.Store.NO));
        }
    }

    private void transformV2Api(Document doc, IndexableApi indexableApi) {
        Object apiV2;
        io.gravitee.apim.core.api.model.Api api = indexableApi.getApi();
        ApiDefinition apiDefinition = api.getApiDefinitionValue();
        if (apiDefinition instanceof io.gravitee.definition.model.Api && (apiV2 = (io.gravitee.definition.model.Api)apiDefinition).getProxy() != null) {
            int[] pathIndex = new int[]{0};
            apiV2.getProxy().getVirtualHosts().forEach(virtualHost -> this.appendPath(doc, pathIndex, virtualHost.getHost(), virtualHost.getPath()));
        }
        if (api.getTags() != null && !api.getTags().isEmpty()) {
            for (String tag : api.getTags()) {
                doc.add((IndexableField)new StringField("tags", tag, Field.Store.NO));
                doc.add((IndexableField)new TextField("tags_split", tag, Field.Store.NO));
            }
            String tagsAsc = api.getTags().stream().sorted().collect(Collectors.joining(","));
            String tagsDesc = api.getTags().stream().sorted(Comparator.reverseOrder()).collect(Collectors.joining(","));
            doc.add((IndexableField)new SortedDocValuesField("tags_asc_sorted", this.toSortedValue(tagsAsc)));
            doc.add((IndexableField)new SortedDocValuesField("tags_desc_sorted", this.toSortedValue(tagsDesc)));
        }
        doc.add((IndexableField)new StringField("has_health_check", Boolean.toString(this.hasHealthCheckEnabledV2(api)), Field.Store.NO));
    }

    private boolean hasHealthCheckEnabledV2(io.gravitee.apim.core.api.model.Api api) {
        boolean hasGlobalHealthCheck;
        io.gravitee.definition.model.Api definition;
        ApiDefinition apiDefinition = api.getApiDefinitionValue();
        if (!(apiDefinition instanceof io.gravitee.definition.model.Api)) {
            return false;
        }
        io.gravitee.definition.model.Api apiDefinition2 = definition = (io.gravitee.definition.model.Api)apiDefinition;
        if (apiDefinition2.getServices() != null && (hasGlobalHealthCheck = apiDefinition2.getServices().getAll().stream().anyMatch(service -> service.isEnabled() && service instanceof HealthCheckService))) {
            return true;
        }
        if (apiDefinition2.getProxy() != null && apiDefinition2.getProxy().getGroups() != null) {
            return apiDefinition2.getProxy().getGroups().stream().anyMatch(group -> group.getEndpoints() != null && group.getEndpoints().stream().anyMatch(endpoint -> endpoint.getHealthCheck() != null && endpoint.getHealthCheck().isEnabled()));
        }
        return false;
    }

    private void appendPath(Document doc, int[] pathIndex, String host, String path) {
        doc.add((IndexableField)new StringField("paths", path, Field.Store.NO));
        doc.add((IndexableField)new StringField("paths_lowercase", path.toLowerCase(), Field.Store.NO));
        doc.add((IndexableField)new TextField("paths_split", path, Field.Store.NO));
        if (host != null && !host.isEmpty()) {
            doc.add((IndexableField)new StringField("hosts", host, Field.Store.NO));
            doc.add((IndexableField)new StringField("hosts_lowercase", host.toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField("hosts_split", host, Field.Store.NO));
        }
        int n = pathIndex[0];
        pathIndex[0] = n + 1;
        if (n == 0) {
            doc.add((IndexableField)new SortedDocValuesField("paths_sorted", this.toSortedValue(path)));
        }
    }

    private BytesRef toSortedValue(String value) {
        if (value == null) {
            return new BytesRef((CharSequence)"");
        }
        String cleaned = ApiDocumentTransformer.SPECIAL_CHARS.matcher(value).replaceAll("");
        this.collator.setStrength(1);
        CollationKey key = this.collator.getCollationKey(cleaned);
        return new BytesRef(key.toByteArray());
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return IndexableApi.class.isAssignableFrom(source);
    }
}

