/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class InvalidUserException
extends AbstractManagementException {
    private final String message;
    private final String source;
    private final String userId;
    private final String organizationId;

    public InvalidUserException(String message, String source, String userId, String organizationId) {
        this.message = message;
        this.source = source;
        this.userId = userId;
        this.organizationId = organizationId;
    }

    public static InvalidUserException cannotBeCreated(String source, String userId, String organizationId) {
        return new InvalidUserException("User cannot be created.", source, userId, organizationId);
    }

    public static InvalidUserException cannotBeUpdated(String source, String userId, String organizationId) {
        return new InvalidUserException("User cannot be updated.", source, userId, organizationId);
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getTechnicalCode() {
        return "user.invalid";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("user", this.userId);
        parameters.put("organizationId", this.organizationId);
        parameters.put("source", this.source);
        return parameters;
    }
}

