/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.portal_page.use_case.CreateDefaultPortalNavigationItemsUseCase;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.environment.EnvironmentCommand;
import io.gravitee.cockpit.api.command.v1.environment.EnvironmentCommandPayload;
import io.gravitee.cockpit.api.command.v1.environment.EnvironmentReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UpdateEnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentCommandHandler
implements CommandHandler<EnvironmentCommand, EnvironmentReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentCommandHandler.class);
    private final EnvironmentService environmentService;
    private final AccessPointCrudService accessPointService;
    private final CreateDefaultPortalNavigationItemsUseCase createDefaultPortalNavigationItemsUseCase;

    public String supportType() {
        return CockpitCommandType.ENVIRONMENT.name();
    }

    public Single<EnvironmentReply> handle(EnvironmentCommand command) {
        EnvironmentCommandPayload environmentPayload = (EnvironmentCommandPayload)command.getPayload();
        try {
            EnvironmentEntity existingEnvironment = this.getEnvironment(environmentPayload);
            UpdateEnvironmentEntity newEnvironment = new UpdateEnvironmentEntity();
            newEnvironment.setCockpitId(environmentPayload.cockpitId());
            newEnvironment.setHrids(environmentPayload.hrids());
            newEnvironment.setName(environmentPayload.name());
            newEnvironment.setDescription(environmentPayload.description());
            EnvironmentEntity environment = this.environmentService.createOrUpdate(existingEnvironment != null ? existingEnvironment.getOrganizationId() : environmentPayload.organizationId(), existingEnvironment != null ? existingEnvironment.getId() : environmentPayload.id(), newEnvironment);
            List<Object> accessPointsToCreate = environmentPayload.accessPoints() != null ? environmentPayload.accessPoints().stream().map(cockpitAccessPoint -> AccessPoint.builder().referenceType(AccessPoint.ReferenceType.ENVIRONMENT).referenceId(environment.getId()).target(AccessPoint.Target.valueOf(cockpitAccessPoint.getTarget().name())).host(cockpitAccessPoint.getHost()).secured(cockpitAccessPoint.isSecured()).overriding(cockpitAccessPoint.isOverriding()).build()).toList() : new ArrayList();
            this.accessPointService.updateAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environment.getId(), accessPointsToCreate);
            this.createDefaultPortalNavigationItemsUseCase.execute(environment.getOrganizationId(), environment.getId());
            log.info("Environment [{}] handled with id [{}].", (Object)environment.getName(), (Object)environment.getId());
            return Single.just((Object)new EnvironmentReply(command.getId()));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when handling environment [%s] with id [%s]".formatted(environmentPayload.name(), environmentPayload.id());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new EnvironmentReply(command.getId(), errorDetails));
        }
    }

    private EnvironmentEntity getEnvironment(EnvironmentCommandPayload environmentPayload) {
        try {
            return this.environmentService.findByCockpitId(environmentPayload.cockpitId());
        }
        catch (EnvironmentNotFoundException ex) {
            return null;
        }
    }

    @Generated
    public EnvironmentCommandHandler(EnvironmentService environmentService, AccessPointCrudService accessPointService, CreateDefaultPortalNavigationItemsUseCase createDefaultPortalNavigationItemsUseCase) {
        this.environmentService = environmentService;
        this.accessPointService = accessPointService;
        this.createDefaultPortalNavigationItemsUseCase = createDefaultPortalNavigationItemsUseCase;
    }
}

