/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.scoring.model.ScoringRuleset;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.environment.DeleteEnvironmentCommand;
import io.gravitee.cockpit.api.command.v1.environment.DeleteEnvironmentCommandPayload;
import io.gravitee.cockpit.api.command.v1.environment.DeleteEnvironmentReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AccessPointRepository;
import io.gravitee.repository.management.api.ApiCategoryOrderRepository;
import io.gravitee.repository.management.api.ApiHeaderRepository;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.AsyncJobRepository;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.api.ClientRegistrationProviderRepository;
import io.gravitee.repository.management.api.ClusterRepository;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.CustomUserFieldsRepository;
import io.gravitee.repository.management.api.DashboardRepository;
import io.gravitee.repository.management.api.DictionaryRepository;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.IdentityProviderActivationRepository;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.repository.management.api.InvitationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.PageRevisionRepository;
import io.gravitee.repository.management.api.ParameterRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.PortalMenuLinkRepository;
import io.gravitee.repository.management.api.PortalNavigationItemRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.api.PortalPageContentRepository;
import io.gravitee.repository.management.api.PortalPageContextRepository;
import io.gravitee.repository.management.api.PortalPageRepository;
import io.gravitee.repository.management.api.PromotionRepository;
import io.gravitee.repository.management.api.QualityRuleRepository;
import io.gravitee.repository.management.api.RatingAnswerRepository;
import io.gravitee.repository.management.api.RatingRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.api.ScoringFunctionRepository;
import io.gravitee.repository.management.api.ScoringReportRepository;
import io.gravitee.repository.management.api.ScoringRulesetRepository;
import io.gravitee.repository.management.api.SharedPolicyGroupHistoryRepository;
import io.gravitee.repository.management.api.SharedPolicyGroupRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.ThemeRepository;
import io.gravitee.repository.management.api.TicketRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.WorkflowRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.AccessPointReferenceType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.CustomUserFieldReferenceType;
import io.gravitee.repository.management.model.DashboardReferenceType;
import io.gravitee.repository.management.model.InvitationReferenceType;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.management.model.ParameterReferenceType;
import io.gravitee.repository.management.model.PortalNavigationItem;
import io.gravitee.repository.management.model.QualityRule;
import io.gravitee.repository.management.model.RatingReferenceType;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.ThemeReferenceType;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.repository.media.api.MediaRepository;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApplicationAlertService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.cockpit.command.handler.CockpitUserHelper;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.v4.ApiStateService;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DeleteEnvironmentCommandHandler
implements CommandHandler<DeleteEnvironmentCommand, DeleteEnvironmentReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteEnvironmentCommandHandler.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final AccessPointCrudService accessPointService;
    private final AccessPointRepository accessPointRepository;
    private final AlertService alertService;
    private final ApiCategoryOrderRepository apiCategoryOrderRepository;
    private final ApiHeaderRepository apiHeaderRepository;
    private final ApiKeyRepository apiKeyRepository;
    private final ApiQualityRuleRepository apiQualityRuleRepository;
    private final ApiRepository apiRepository;
    private final ApiStateService apiStateService;
    private final ApplicationAlertService applicationAlertService;
    private final ApplicationRepository applicationRepository;
    private final AuditRepository auditRepository;
    private final CategoryRepository categoryRepository;
    private final CommandRepository commandRepository;
    private final ClientRegistrationProviderRepository clientRegistrationProviderRepository;
    private final CustomUserFieldsRepository customUserFieldsRepository;
    private final DashboardRepository dashboardRepository;
    private final DictionaryRepository dictionaryRepository;
    private final DictionaryService dictionaryService;
    private final EnvironmentService environmentService;
    private final FlowRepository flowRepository;
    private final GenericNotificationConfigRepository genericNotificationConfigRepository;
    private final GroupRepository groupRepository;
    private final IdentityProviderActivationRepository identityProviderActivationRepository;
    private final IdentityProviderActivationService identityProviderActivationService;
    private final AsyncJobRepository asyncJobRepository;
    private final IntegrationRepository integrationRepository;
    private final InvitationRepository invitationRepository;
    private final MediaRepository mediaRepository;
    private final MembershipRepository membershipRepository;
    private final MetadataRepository metadataRepository;
    private final PageRepository pageRepository;
    private final PageRevisionRepository pageRevisionRepository;
    private final ParameterRepository parameterRepository;
    private final PlanRepository planRepository;
    private final PortalMenuLinkRepository portalMenuLinkRepository;
    private final PortalNotificationConfigRepository portalNotificationConfigRepository;
    private final PortalPageRepository portalPageRepository;
    private final PortalPageContextRepository portalPageContextRepository;
    private final PortalNavigationItemRepository portalNavigationItemRepository;
    private final PortalPageContentRepository portalPageContentRepository;
    private final PromotionRepository promotionRepository;
    private final QualityRuleRepository qualityRuleRepository;
    private final RatingAnswerRepository ratingAnswerRepository;
    private final RatingRepository ratingRepository;
    private final RoleRepository roleRepository;
    private final ScoringReportRepository scoringReportRepository;
    private final ScoringRulesetRepository scoringRulesetRepository;
    private final ScoringFunctionRepository scoringFunctionRepository;
    private final SearchEngineService searchEngineService;
    private final SharedPolicyGroupRepository sharedPolicyGroupRepository;
    private final SharedPolicyGroupHistoryRepository sharedPolicyGroupHistoryRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final ThemeRepository themeRepository;
    private final TicketRepository ticketRepository;
    private final WorkflowRepository workflowRepository;
    private final ClusterRepository clusterRepository;
    private final UserRepository userRepository;

    public DeleteEnvironmentCommandHandler(@Lazy AccessPointRepository accessPointRepository, @Lazy ApiCategoryOrderRepository apiCategoryOrderRepository, @Lazy ApiHeaderRepository apiHeaderRepository, @Lazy ApiKeyRepository apiKeyRepository, @Lazy ApiQualityRuleRepository apiQualityRuleRepository, @Lazy ApiRepository apiRepository, @Lazy ApplicationRepository applicationRepository, @Lazy AsyncJobRepository asyncJobRepository, @Lazy AuditRepository auditRepository, @Lazy CategoryRepository categoryRepository, @Lazy ClientRegistrationProviderRepository clientRegistrationProviderRepository, @Lazy CommandRepository commandRepository, @Lazy CustomUserFieldsRepository customUserFieldsRepository, @Lazy DashboardRepository dashboardRepository, @Lazy DictionaryRepository dictionaryRepository, @Lazy FlowRepository flowRepository, @Lazy GenericNotificationConfigRepository genericNotificationConfigRepository, @Lazy GroupRepository groupRepository, @Lazy IdentityProviderActivationRepository identityProviderActivationRepository, @Lazy IntegrationRepository integrationRepository, @Lazy InvitationRepository invitationRepository, @Lazy MediaRepository mediaRepository, @Lazy MembershipRepository membershipRepository, @Lazy MetadataRepository metadataRepository, @Lazy PageRepository pageRepository, @Lazy PageRevisionRepository pageRevisionRepository, @Lazy ParameterRepository parameterRepository, @Lazy PlanRepository planRepository, @Lazy PortalMenuLinkRepository portalMenuLinkRepository, @Lazy PortalNotificationConfigRepository portalNotificationConfigRepository, @Lazy PortalPageRepository portalPageRepository, @Lazy PortalPageContextRepository portalPageContextRepository, @Lazy PortalNavigationItemRepository portalNavigationItemRepository, @Lazy PortalPageContentRepository portalPageContentRepository, @Lazy PromotionRepository promotionRepository, @Lazy QualityRuleRepository qualityRuleRepository, @Lazy RatingAnswerRepository ratingAnswerRepository, @Lazy RatingRepository ratingRepository, @Lazy RoleRepository roleRepository, @Lazy ScoringReportRepository scoringReportRepository, @Lazy ScoringRulesetRepository scoringRulesetRepository, @Lazy ScoringFunctionRepository scoringFunctionRepository, @Lazy SharedPolicyGroupRepository sharedPolicyGroupRepository, @Lazy SharedPolicyGroupHistoryRepository sharedPolicyGroupHistoryRepository, @Lazy SubscriptionRepository subscriptionRepository, @Lazy ThemeRepository themeRepository, @Lazy TicketRepository ticketRepository, @Lazy WorkflowRepository workflowRepository, @Lazy ClusterRepository clusterRepository, AccessPointCrudService accessPointService, AlertService alertService, ApiStateService apiStateService, ApplicationAlertService applicationAlertService, DictionaryService dictionaryService, EnvironmentService environmentService, IdentityProviderActivationService identityProviderActivationService, SearchEngineService searchEngineService, @Lazy UserRepository userRepository) {
        this.accessPointRepository = accessPointRepository;
        this.accessPointService = accessPointService;
        this.alertService = alertService;
        this.apiCategoryOrderRepository = apiCategoryOrderRepository;
        this.apiHeaderRepository = apiHeaderRepository;
        this.apiKeyRepository = apiKeyRepository;
        this.apiQualityRuleRepository = apiQualityRuleRepository;
        this.apiRepository = apiRepository;
        this.apiStateService = apiStateService;
        this.applicationAlertService = applicationAlertService;
        this.applicationRepository = applicationRepository;
        this.auditRepository = auditRepository;
        this.categoryRepository = categoryRepository;
        this.clientRegistrationProviderRepository = clientRegistrationProviderRepository;
        this.commandRepository = commandRepository;
        this.customUserFieldsRepository = customUserFieldsRepository;
        this.dashboardRepository = dashboardRepository;
        this.dictionaryRepository = dictionaryRepository;
        this.dictionaryService = dictionaryService;
        this.environmentService = environmentService;
        this.flowRepository = flowRepository;
        this.genericNotificationConfigRepository = genericNotificationConfigRepository;
        this.groupRepository = groupRepository;
        this.identityProviderActivationRepository = identityProviderActivationRepository;
        this.identityProviderActivationService = identityProviderActivationService;
        this.asyncJobRepository = asyncJobRepository;
        this.integrationRepository = integrationRepository;
        this.invitationRepository = invitationRepository;
        this.mediaRepository = mediaRepository;
        this.membershipRepository = membershipRepository;
        this.metadataRepository = metadataRepository;
        this.pageRepository = pageRepository;
        this.pageRevisionRepository = pageRevisionRepository;
        this.parameterRepository = parameterRepository;
        this.planRepository = planRepository;
        this.portalMenuLinkRepository = portalMenuLinkRepository;
        this.portalNotificationConfigRepository = portalNotificationConfigRepository;
        this.portalPageRepository = portalPageRepository;
        this.portalPageContextRepository = portalPageContextRepository;
        this.portalNavigationItemRepository = portalNavigationItemRepository;
        this.portalPageContentRepository = portalPageContentRepository;
        this.promotionRepository = promotionRepository;
        this.qualityRuleRepository = qualityRuleRepository;
        this.ratingAnswerRepository = ratingAnswerRepository;
        this.ratingRepository = ratingRepository;
        this.roleRepository = roleRepository;
        this.scoringReportRepository = scoringReportRepository;
        this.scoringFunctionRepository = scoringFunctionRepository;
        this.scoringRulesetRepository = scoringRulesetRepository;
        this.searchEngineService = searchEngineService;
        this.sharedPolicyGroupRepository = sharedPolicyGroupRepository;
        this.sharedPolicyGroupHistoryRepository = sharedPolicyGroupHistoryRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.themeRepository = themeRepository;
        this.ticketRepository = ticketRepository;
        this.workflowRepository = workflowRepository;
        this.clusterRepository = clusterRepository;
        this.userRepository = userRepository;
    }

    public String supportType() {
        return CockpitCommandType.DELETE_ENVIRONMENT.name();
    }

    public Single<DeleteEnvironmentReply> handle(DeleteEnvironmentCommand command) {
        DeleteEnvironmentCommandPayload payload = (DeleteEnvironmentCommandPayload)command.getPayload();
        try {
            this.processDeletionWorkflow(payload.cockpitId(), payload.userId());
            return Single.just((Object)new DeleteEnvironmentReply(command.getId()));
        }
        catch (EnvironmentNotFoundException e) {
            log.warn("Environment with cockpitId [{}] has not been found.", (Object)payload.cockpitId());
            return Single.just((Object)new DeleteEnvironmentReply(command.getId()));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when deleting environment with id [%s].".formatted(payload.id());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new DeleteEnvironmentReply(command.getId(), errorDetails));
        }
    }

    void processDeletionWorkflow(String environmentCockpitId, String userId) throws TechnicalException {
        log.info("Delete environment with id [{}]", (Object)environmentCockpitId);
        EnvironmentEntity environment = this.environmentService.findByCockpitId(environmentCockpitId);
        ExecutionContext executionContext = new ExecutionContext(environment.getOrganizationId(), environment.getId());
        String resolvedUserId = CockpitUserHelper.resolveApimUserId(this.userRepository, executionContext, userId);
        this.disableEnvironment(executionContext, resolvedUserId);
        this.deleteEnvironment(executionContext, environment);
        log.info("Environment [{}] with id [{}] has been deleted.", (Object)environment.getName(), (Object)environment.getId());
    }

    private void disableEnvironment(ExecutionContext executionContext, String userId) {
        this.apiRepository.search(new ApiCriteria.Builder().state(LifecycleState.STARTED).environmentId(executionContext.getEnvironmentId()).build(), new ApiFieldFilter.Builder().excludeDefinition().excludePicture().build()).forEach(api -> this.apiStateService.stopWithoutNotification(executionContext, api.getId(), userId));
        this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, executionContext.getEnvironmentId());
        this.dictionaryService.findAll(executionContext).forEach(dictionaryEntity -> this.dictionaryService.stop(executionContext, dictionaryEntity.getId()));
        this.identityProviderActivationService.removeAllIdpsFromTarget(executionContext, new IdentityProviderActivationService.ActivationTarget(executionContext.getEnvironmentId(), IdentityProviderActivationReferenceType.ENVIRONMENT));
    }

    private void deleteEnvironment(ExecutionContext executionContext, EnvironmentEntity environment) throws TechnicalException {
        this.deleteApis(executionContext);
        this.deleteApplications(executionContext);
        this.deletePages(executionContext, PageReferenceType.ENVIRONMENT, environment.getId());
        this.subscriptionRepository.deleteByEnvironmentId(environment.getId());
        this.apiKeyRepository.deleteByEnvironmentId(environment.getId());
        this.planRepository.deleteByEnvironmentId(executionContext.getEnvironmentId()).forEach(planId -> {
            try {
                this.flowRepository.deleteByReferenceIdAndReferenceType(planId, FlowReferenceType.PLAN);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
        });
        this.alertService.findByReference(AlertReferenceType.ENVIRONMENT, environment.getId()).forEach(alert -> this.alertService.delete(alert.getId(), environment.getId()));
        this.apiHeaderRepository.deleteByEnvironmentId(environment.getId());
        this.accessPointRepository.deleteByReferenceIdAndReferenceType(environment.getId(), AccessPointReferenceType.ENVIRONMENT);
        this.parameterRepository.deleteByReferenceIdAndReferenceType(environment.getId(), ParameterReferenceType.ENVIRONMENT);
        this.portalMenuLinkRepository.deleteByEnvironmentId(environment.getId());
        this.portalPageRepository.deleteByEnvironmentId(environment.getId());
        this.deletePortalNavigationItems(environment);
        this.portalNavigationItemRepository.deleteByEnvironmentId(environment.getId());
        this.customUserFieldsRepository.deleteByReferenceIdAndReferenceType(environment.getId(), CustomUserFieldReferenceType.ENVIRONMENT);
        this.groupRepository.deleteByEnvironmentId(environment.getId()).forEach(groupId -> {
            try {
                this.membershipRepository.deleteByReferenceIdAndReferenceType(groupId, MembershipReferenceType.GROUP);
                this.invitationRepository.deleteByReferenceIdAndReferenceType(groupId, InvitationReferenceType.GROUP);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
        });
        this.membershipRepository.deleteByReferenceIdAndReferenceType(environment.getId(), MembershipReferenceType.ENVIRONMENT);
        this.roleRepository.deleteByReferenceIdAndReferenceType(environment.getId(), RoleReferenceType.ENVIRONMENT);
        this.categoryRepository.deleteByEnvironmentId(environment.getId());
        this.dashboardRepository.deleteByReferenceIdAndReferenceType(environment.getId(), DashboardReferenceType.ENVIRONMENT);
        this.dictionaryRepository.deleteByEnvironmentId(environment.getId());
        this.scoringRulesetRepository.deleteByReferenceId(environment.getId(), ScoringRuleset.ReferenceType.ENVIRONMENT.name());
        this.scoringFunctionRepository.deleteByReferenceId(environment.getId(), ScoringRuleset.ReferenceType.ENVIRONMENT.name());
        this.portalNotificationConfigRepository.deleteByReferenceIdAndReferenceType(environment.getId(), NotificationReferenceType.ENVIRONMENT);
        this.genericNotificationConfigRepository.deleteByReferenceIdAndReferenceType(environment.getId(), NotificationReferenceType.ENVIRONMENT);
        this.sharedPolicyGroupRepository.deleteByEnvironmentId(environment.getId());
        this.sharedPolicyGroupHistoryRepository.deleteByEnvironmentId(environment.getId());
        this.themeRepository.deleteByReferenceIdAndReferenceType(environment.getId(), ThemeReferenceType.ENVIRONMENT);
        this.identityProviderActivationRepository.deleteByReferenceIdAndReferenceType(environment.getId(), io.gravitee.repository.management.model.IdentityProviderActivationReferenceType.ENVIRONMENT);
        this.commandRepository.deleteByEnvironmentId(environment.getId());
        this.integrationRepository.deleteByEnvironmentId(environment.getId());
        this.asyncJobRepository.deleteByEnvironmentId(environment.getId());
        this.mediaRepository.deleteByEnvironment(environment.getId());
        this.metadataRepository.deleteByReferenceIdAndReferenceType(environment.getId(), MetadataReferenceType.ENVIRONMENT);
        this.environmentService.delete(environment.getId());
        this.auditRepository.deleteByReferenceIdAndReferenceType(environment.getId(), Audit.AuditReferenceType.ENVIRONMENT);
        this.clientRegistrationProviderRepository.deleteByEnvironmentId(environment.getId());
        this.qualityRuleRepository.deleteByReferenceIdAndReferenceType(environment.getId(), QualityRule.ReferenceType.ENVIRONMENT);
        this.clusterRepository.deleteByEnvironmentId(environment.getId());
    }

    private void deletePortalNavigationItems(EnvironmentEntity environment) throws TechnicalException {
        this.portalNavigationItemRepository.findAllByOrganizationIdAndEnvironmentId(environment.getOrganizationId(), environment.getId()).stream().filter(item -> item.getType() == PortalNavigationItem.Type.PAGE).forEach(item -> {
            try {
                String pageContentId = this.extractPageContentId(item.getConfiguration());
                if (pageContentId == null) {
                    return;
                }
                this.portalPageContentRepository.delete((Object)pageContentId);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
        });
        this.portalPageContextRepository.deleteByEnvironmentId(environment.getId());
    }

    private String extractPageContentId(String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            return null;
        }
        try {
            JsonNode node = OBJECT_MAPPER.readTree(configuration);
            if (node.has("pageId")) {
                return node.get("pageId").asText();
            }
        }
        catch (Exception e) {
            log.error("Failed to extract pageId from configuration: {}", (Object)configuration, (Object)e);
        }
        return null;
    }

    private void deleteApis(ExecutionContext executionContext) throws TechnicalException {
        this.apiRepository.deleteByEnvironmentId(executionContext.getEnvironmentId()).forEach(apiId -> {
            this.alertService.findByReference(AlertReferenceType.API, (String)apiId).forEach(alert -> this.alertService.delete(alert.getId(), (String)apiId));
            this.searchEngineService.delete(executionContext, (Indexable)ApiEntity.builder().id(apiId).build());
            this.deletePages(executionContext, PageReferenceType.API, (String)apiId);
            try {
                this.apiCategoryOrderRepository.deleteByApiId(apiId);
                this.apiQualityRuleRepository.deleteByApi(apiId);
                this.auditRepository.deleteByReferenceIdAndReferenceType(apiId, Audit.AuditReferenceType.API);
                this.flowRepository.deleteByReferenceIdAndReferenceType(apiId, FlowReferenceType.API);
                this.genericNotificationConfigRepository.deleteByReferenceIdAndReferenceType(apiId, NotificationReferenceType.API);
                this.invitationRepository.deleteByReferenceIdAndReferenceType(apiId, InvitationReferenceType.API);
                this.mediaRepository.deleteAllByApi(apiId);
                this.membershipRepository.deleteByReferenceIdAndReferenceType(apiId, MembershipReferenceType.API);
                this.metadataRepository.deleteByReferenceIdAndReferenceType(apiId, MetadataReferenceType.API);
                this.portalNotificationConfigRepository.deleteByReferenceIdAndReferenceType(apiId, NotificationReferenceType.API);
                this.promotionRepository.deleteByApiId(apiId);
                this.scoringReportRepository.deleteByApi(apiId);
                this.ticketRepository.deleteByApiId(apiId);
                this.workflowRepository.deleteByReferenceIdAndReferenceType(apiId, Workflow.ReferenceType.API.name());
                this.deleteRatings((String)apiId, RatingReferenceType.API);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
        });
    }

    private void deleteRatings(String referenceId, RatingReferenceType referenceType) throws TechnicalException {
        this.ratingRepository.deleteByReferenceIdAndReferenceType(referenceId, referenceType).forEach(ratingId -> {
            try {
                this.ratingAnswerRepository.deleteByRating(ratingId);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
        });
    }

    private void deletePages(ExecutionContext executionContext, PageReferenceType referenceType, String id) {
        try {
            this.pageRepository.deleteByReferenceIdAndReferenceType(id, referenceType).forEach((pageId, mediaHash) -> {
                this.searchEngineService.delete(executionContext, (Indexable)PageEntity.builder().id(pageId).build());
                try {
                    this.pageRevisionRepository.deleteByPageId(pageId);
                }
                catch (TechnicalException e) {
                    throw new TechnicalManagementException(e);
                }
            });
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private void deleteApplications(ExecutionContext executionContext) throws TechnicalException {
        this.applicationRepository.deleteByEnvironmentId(executionContext.getEnvironmentId()).forEach(applicationId -> {
            this.applicationAlertService.deleteAll((String)applicationId);
            try {
                this.genericNotificationConfigRepository.deleteByReferenceIdAndReferenceType(applicationId, NotificationReferenceType.APPLICATION);
                this.invitationRepository.deleteByReferenceIdAndReferenceType(applicationId, InvitationReferenceType.APPLICATION);
                this.membershipRepository.deleteByReferenceIdAndReferenceType(applicationId, MembershipReferenceType.APPLICATION);
                this.metadataRepository.deleteByReferenceIdAndReferenceType(applicationId, MetadataReferenceType.APPLICATION);
                this.portalNotificationConfigRepository.deleteByReferenceIdAndReferenceType(applicationId, NotificationReferenceType.APPLICATION);
                this.workflowRepository.deleteByReferenceIdAndReferenceType(applicationId, Workflow.ReferenceType.APPLICATION.name());
                this.auditRepository.deleteByReferenceIdAndReferenceType(applicationId, Audit.AuditReferenceType.APPLICATION);
                this.ticketRepository.deleteByApplicationId(applicationId);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
        });
    }
}

