/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.analytics_engine;

import io.gravitee.apim.core.analytics_engine.model.FacetsRequest;
import io.gravitee.apim.core.analytics_engine.model.FacetsResponse;
import io.gravitee.apim.core.analytics_engine.model.MeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MeasuresResponse;
import io.gravitee.apim.core.analytics_engine.model.MetricSpec;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesRequest;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesResponse;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsEngineQueryService;
import io.gravitee.apim.infra.adapter.AnalyticsMeasuresAdapter;
import io.gravitee.repository.analytics.engine.api.query.FacetsQuery;
import io.gravitee.repository.analytics.engine.api.query.MeasuresQuery;
import io.gravitee.repository.analytics.engine.api.query.TimeSeriesQuery;
import io.gravitee.repository.analytics.engine.api.result.FacetsResult;
import io.gravitee.repository.analytics.engine.api.result.MeasuresResult;
import io.gravitee.repository.analytics.engine.api.result.TimeSeriesResult;
import io.gravitee.repository.log.v4.api.AnalyticsRepository;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Set;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class HTTPDataPlaneAnalyticsQueryService
implements AnalyticsEngineQueryService {
    private final AnalyticsRepository analyticsRepository;

    public HTTPDataPlaneAnalyticsQueryService(@Lazy AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
    }

    @Override
    public Set<MetricSpec.Name> metrics() {
        return Set.of(MetricSpec.Name.HTTP_REQUESTS, MetricSpec.Name.HTTP_ERRORS, MetricSpec.Name.HTTP_REQUEST_CONTENT_LENGTH, MetricSpec.Name.HTTP_RESPONSE_CONTENT_LENGTH, MetricSpec.Name.HTTP_ENDPOINT_RESPONSE_TIME, MetricSpec.Name.HTTP_GATEWAY_RESPONSE_TIME, MetricSpec.Name.HTTP_GATEWAY_LATENCY, MetricSpec.Name.LLM_PROMPT_TOKEN_SENT, MetricSpec.Name.LLM_PROMPT_TOKEN_RECEIVED, MetricSpec.Name.LLM_PROMPT_TOKEN_SENT_COST, MetricSpec.Name.LLM_PROMPT_TOKEN_RECEIVED_COST);
    }

    @Override
    public MeasuresResponse searchMeasures(ExecutionContext context, MeasuresRequest request) {
        MeasuresQuery query = AnalyticsMeasuresAdapter.INSTANCE.fromRequest(request);
        MeasuresResult result = this.analyticsRepository.searchHTTPMeasures(context.getQueryContext(), query);
        return AnalyticsMeasuresAdapter.INSTANCE.fromResult(result);
    }

    @Override
    public FacetsResponse searchFacets(ExecutionContext context, FacetsRequest request) {
        FacetsQuery query = AnalyticsMeasuresAdapter.INSTANCE.fromRequest(request);
        FacetsResult result = this.analyticsRepository.searchHTTPFacets(context.getQueryContext(), query);
        return AnalyticsMeasuresAdapter.INSTANCE.fromResult(result);
    }

    @Override
    public TimeSeriesResponse searchTimeSeries(ExecutionContext context, TimeSeriesRequest request) {
        TimeSeriesQuery query = AnalyticsMeasuresAdapter.INSTANCE.fromRequest(request);
        TimeSeriesResult result = this.analyticsRepository.searchHTTPTimeSeries(context.getQueryContext(), query);
        return AnalyticsMeasuresAdapter.INSTANCE.fromResult(result);
    }
}

