/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.promotion;

import io.gravitee.apim.core.cockpit.model.CockpitReplyStatus;
import io.gravitee.apim.core.promotion.model.Promotion;
import io.gravitee.apim.core.promotion.model.PromotionRequest;
import io.gravitee.apim.core.promotion.service_provider.CockpitPromotionServiceProvider;
import io.gravitee.apim.infra.adapter.PromotionAdapter;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.service.cockpit.services.CockpitPromotionService;
import io.gravitee.rest.api.service.cockpit.services.CockpitReply;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.promotion.PromotionService;
import org.springframework.stereotype.Service;

@Service
public class CockpitPromotionServiceProviderImpl
implements CockpitPromotionServiceProvider {
    private final CockpitPromotionService cockpitPromotionService;
    private final PromotionService promotionService;

    public CockpitPromotionServiceProviderImpl(CockpitPromotionService cockpitPromotionService, PromotionService promotionService) {
        this.cockpitPromotionService = cockpitPromotionService;
        this.promotionService = promotionService;
    }

    @Override
    public CockpitReplyStatus requestPromotion(String organizationId, String environmentId, Promotion promotion) {
        CockpitReply<PromotionEntity> cockpitReply = this.cockpitPromotionService.requestPromotion(new ExecutionContext(organizationId, environmentId), PromotionAdapter.INSTANCE.toRestApiModel(promotion));
        return cockpitReply.getStatus() == io.gravitee.rest.api.service.cockpit.services.CockpitReplyStatus.SUCCEEDED ? CockpitReplyStatus.SUCCEEDED : CockpitReplyStatus.ERROR;
    }

    @Override
    public Promotion createPromotion(String apiId, PromotionRequest promotionRequest, String userId) {
        PromotionEntity created = this.promotionService.create(GraviteeContext.getExecutionContext(), GraviteeContext.getCurrentEnvironment(), apiId, PromotionAdapter.INSTANCE.toRestApiModel(promotionRequest), userId);
        return PromotionAdapter.INSTANCE.toCoreModel(created);
    }

    @Override
    public Promotion process(String promotionId, boolean isAccepted) {
        PromotionEntity processed = this.promotionService.processPromotion(GraviteeContext.getExecutionContext(), promotionId, isAccepted);
        return PromotionAdapter.INSTANCE.toCoreModel(processed);
    }
}

