/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.cluster;

import io.gravitee.apim.core.cluster.crud_service.ClusterCrudService;
import io.gravitee.apim.core.cluster.model.Cluster;
import io.gravitee.apim.core.exception.DbEntityNotFoundException;
import io.gravitee.apim.infra.adapter.ClusterAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ClusterRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ClusterCrudServiceImpl
implements ClusterCrudService {
    private final ClusterRepository clusterRepository;
    private final ClusterAdapter clusterAdapter;

    public ClusterCrudServiceImpl(@Lazy ClusterRepository clusterRepository, ClusterAdapter clusterAdapter) {
        this.clusterRepository = clusterRepository;
        this.clusterAdapter = clusterAdapter;
    }

    @Override
    public Cluster create(Cluster clusterToCreate) {
        try {
            io.gravitee.repository.management.model.Cluster result = (io.gravitee.repository.management.model.Cluster)this.clusterRepository.create((Object)this.clusterAdapter.toRepository(clusterToCreate));
            return this.clusterAdapter.fromRepository(result);
        }
        catch (TechnicalException e) {
            throw TechnicalManagementException.ofTryingToCreateWithId(Cluster.class, clusterToCreate.getId(), e);
        }
    }

    @Override
    public Cluster findByIdAndEnvironmentId(String id, String environmentId) {
        try {
            return this.clusterRepository.findById((Object)id).filter(ClusterCrudServiceImpl.belongsToEnvironment(environmentId)).map(this.clusterAdapter::fromRepository).orElseThrow(() -> new DbEntityNotFoundException(io.gravitee.repository.management.model.Cluster.class, id));
        }
        catch (TechnicalException e) {
            throw TechnicalManagementException.ofTryingToFindById(Cluster.class, id, e);
        }
    }

    private static Predicate<io.gravitee.repository.management.model.Cluster> belongsToEnvironment(String environmentId) {
        return cluster -> environmentId.equals(cluster.getEnvironmentId());
    }

    @Override
    public Cluster update(Cluster clusterToUpdate) {
        try {
            io.gravitee.repository.management.model.Cluster result = (io.gravitee.repository.management.model.Cluster)this.clusterRepository.update((Object)this.clusterAdapter.toRepository(clusterToUpdate));
            return this.clusterAdapter.fromRepository(result);
        }
        catch (TechnicalException e) {
            throw TechnicalManagementException.ofTryingToUpdateWithId(Cluster.class, clusterToUpdate.getId(), e);
        }
    }

    @Override
    public void delete(String clusterId, String environmentId) {
        try {
            this.findByIdAndEnvironmentId(clusterId, environmentId);
            this.clusterRepository.delete((Object)clusterId);
        }
        catch (TechnicalException e) {
            throw TechnicalManagementException.ofTryingToDeleteWithId(Cluster.class, clusterId, e);
        }
    }

    @Override
    public void updateGroups(String id, String environmentId, Set<String> groups) {
        this.findByIdAndEnvironmentId(id, environmentId);
        this.clusterRepository.updateGroups(id, groups);
    }
}

