/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.portal_page.model.PortalNavigationFolder;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemQueryCriteria;
import io.gravitee.apim.core.portal_page.model.PortalNavigationLink;
import io.gravitee.apim.core.portal_page.model.PortalNavigationPage;
import io.gravitee.apim.core.portal_page.model.PortalVisibility;
import io.gravitee.apim.infra.adapter.PortalNavigationItemAdapter;
import io.gravitee.repository.management.api.search.PortalNavigationItemCriteria;
import io.gravitee.repository.management.model.PortalNavigationItem;

public class PortalNavigationItemAdapterImpl
implements PortalNavigationItemAdapter {
    @Override
    public PortalNavigationLink portalNavigationLinkFromRepository(io.gravitee.repository.management.model.PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        PortalNavigationLink.PortalNavigationLinkBuilder<?, ?> portalNavigationLink = PortalNavigationLink.builder();
        portalNavigationLink.id(this.mapPortalNavigationItemId(portalNavigationItem.getId()));
        portalNavigationLink.organizationId(portalNavigationItem.getOrganizationId());
        portalNavigationLink.environmentId(portalNavigationItem.getEnvironmentId());
        portalNavigationLink.title(portalNavigationItem.getTitle());
        portalNavigationLink.area(this.mapArea(portalNavigationItem.getArea()));
        portalNavigationLink.order(portalNavigationItem.getOrder());
        portalNavigationLink.parentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        portalNavigationLink.published(portalNavigationItem.isPublished());
        portalNavigationLink.visibility(this.visibilityToPortalVisibility(portalNavigationItem.getVisibility()));
        portalNavigationLink.url(this.parseUrl(portalNavigationItem.getConfiguration()));
        return portalNavigationLink.build();
    }

    @Override
    public PortalNavigationPage portalNavigationPageFromRepository(io.gravitee.repository.management.model.PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        PortalNavigationPage.PortalNavigationPageBuilder<?, ?> portalNavigationPage = PortalNavigationPage.builder();
        portalNavigationPage.id(this.mapPortalNavigationItemId(portalNavigationItem.getId()));
        portalNavigationPage.organizationId(portalNavigationItem.getOrganizationId());
        portalNavigationPage.environmentId(portalNavigationItem.getEnvironmentId());
        portalNavigationPage.title(portalNavigationItem.getTitle());
        portalNavigationPage.area(this.mapArea(portalNavigationItem.getArea()));
        portalNavigationPage.order(portalNavigationItem.getOrder());
        portalNavigationPage.parentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        portalNavigationPage.published(portalNavigationItem.isPublished());
        portalNavigationPage.visibility(this.visibilityToPortalVisibility(portalNavigationItem.getVisibility()));
        portalNavigationPage.portalPageContentId(this.parsePortalPageContentId(portalNavigationItem.getConfiguration()));
        return portalNavigationPage.build();
    }

    @Override
    public io.gravitee.repository.management.model.PortalNavigationItem toRepository(PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        PortalNavigationItem.PortalNavigationItemBuilder portalNavigationItem1 = io.gravitee.repository.management.model.PortalNavigationItem.builder();
        portalNavigationItem1.id(this.mapPortalNavigationItemId(portalNavigationItem.getId()));
        portalNavigationItem1.organizationId(portalNavigationItem.getOrganizationId());
        portalNavigationItem1.environmentId(portalNavigationItem.getEnvironmentId());
        portalNavigationItem1.title(portalNavigationItem.getTitle());
        portalNavigationItem1.area(this.mapArea(portalNavigationItem.getArea()));
        portalNavigationItem1.parentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        portalNavigationItem1.order(portalNavigationItem.getOrder());
        if (portalNavigationItem.getPublished() != null) {
            portalNavigationItem1.published(portalNavigationItem.getPublished().booleanValue());
        }
        portalNavigationItem1.visibility(this.portalVisibilityToVisibility(portalNavigationItem.getVisibility()));
        portalNavigationItem1.type(this.mapType(portalNavigationItem));
        portalNavigationItem1.configuration(this.configurationOf(portalNavigationItem));
        return portalNavigationItem1.build();
    }

    @Override
    public PortalNavigationFolder portalNavigationFolderFromRepository(io.gravitee.repository.management.model.PortalNavigationItem portalNavigationItem) {
        if (portalNavigationItem == null) {
            return null;
        }
        PortalNavigationFolder.PortalNavigationFolderBuilder<?, ?> portalNavigationFolder = PortalNavigationFolder.builder();
        portalNavigationFolder.id(this.mapPortalNavigationItemId(portalNavigationItem.getId()));
        portalNavigationFolder.organizationId(portalNavigationItem.getOrganizationId());
        portalNavigationFolder.environmentId(portalNavigationItem.getEnvironmentId());
        portalNavigationFolder.title(portalNavigationItem.getTitle());
        portalNavigationFolder.area(this.mapArea(portalNavigationItem.getArea()));
        portalNavigationFolder.order(portalNavigationItem.getOrder());
        portalNavigationFolder.parentId(this.mapPortalNavigationItemId(portalNavigationItem.getParentId()));
        portalNavigationFolder.published(portalNavigationItem.isPublished());
        portalNavigationFolder.visibility(this.visibilityToPortalVisibility(portalNavigationItem.getVisibility()));
        return portalNavigationFolder.build();
    }

    @Override
    public PortalNavigationItemCriteria map(PortalNavigationItemQueryCriteria criteria) {
        if (criteria == null) {
            return null;
        }
        PortalNavigationItemCriteria.PortalNavigationItemCriteriaBuilder portalNavigationItemCriteria = PortalNavigationItemCriteria.builder();
        if (criteria.getArea() != null) {
            portalNavigationItemCriteria.portalArea(criteria.getArea().name());
        }
        portalNavigationItemCriteria.environmentId(criteria.getEnvironmentId());
        portalNavigationItemCriteria.parentId(this.mapPortalNavigationItemId(criteria.getParentId()));
        portalNavigationItemCriteria.published(criteria.getPublished());
        portalNavigationItemCriteria.root(criteria.getRoot());
        if (criteria.getVisibility() != null) {
            portalNavigationItemCriteria.visibility(criteria.getVisibility().name());
        }
        return portalNavigationItemCriteria.build();
    }

    protected PortalVisibility visibilityToPortalVisibility(PortalNavigationItem.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case PortalNavigationItem.Visibility.PUBLIC -> PortalVisibility.PUBLIC;
            case PortalNavigationItem.Visibility.PRIVATE -> PortalVisibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(visibility));
        };
    }

    protected PortalNavigationItem.Visibility portalVisibilityToVisibility(PortalVisibility portalVisibility) {
        if (portalVisibility == null) {
            return null;
        }
        return switch (portalVisibility) {
            case PortalVisibility.PUBLIC -> PortalNavigationItem.Visibility.PUBLIC;
            case PortalVisibility.PRIVATE -> PortalNavigationItem.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)portalVisibility));
        };
    }
}

