/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.analytics_engine.model.FacetBucketResponse;
import io.gravitee.apim.core.analytics_engine.model.FacetMetricMeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.FacetSpec;
import io.gravitee.apim.core.analytics_engine.model.FacetsRequest;
import io.gravitee.apim.core.analytics_engine.model.FacetsResponse;
import io.gravitee.apim.core.analytics_engine.model.FilterSpec;
import io.gravitee.apim.core.analytics_engine.model.MeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MetricFacetsResponse;
import io.gravitee.apim.core.analytics_engine.model.MetricMeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MetricSpec;
import io.gravitee.apim.core.analytics_engine.model.TimeRange;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesBucketResponse;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesMetricResponse;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesRequest;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesResponse;
import io.gravitee.apim.infra.adapter.AnalyticsMeasuresAdapter;
import io.gravitee.repository.analytics.engine.api.metric.Measure;
import io.gravitee.repository.analytics.engine.api.metric.Metric;
import io.gravitee.repository.analytics.engine.api.query.Facet;
import io.gravitee.repository.analytics.engine.api.query.FacetsQuery;
import io.gravitee.repository.analytics.engine.api.query.Filter;
import io.gravitee.repository.analytics.engine.api.query.MeasuresQuery;
import io.gravitee.repository.analytics.engine.api.query.MetricMeasuresQuery;
import io.gravitee.repository.analytics.engine.api.query.NumberRange;
import io.gravitee.repository.analytics.engine.api.query.TimeSeriesQuery;
import io.gravitee.repository.analytics.engine.api.result.FacetBucketResult;
import io.gravitee.repository.analytics.engine.api.result.FacetsResult;
import io.gravitee.repository.analytics.engine.api.result.MetricFacetsResult;
import io.gravitee.repository.analytics.engine.api.result.MetricTimeSeriesResult;
import io.gravitee.repository.analytics.engine.api.result.TimeSeriesBucketResult;
import io.gravitee.repository.analytics.engine.api.result.TimeSeriesResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class AnalyticsMeasuresAdapterImpl
implements AnalyticsMeasuresAdapter {
    @Override
    public TimeSeriesQuery fromRequest(TimeSeriesRequest request) {
        if (request == null) {
            return null;
        }
        io.gravitee.repository.analytics.engine.api.query.TimeRange timeRange = null;
        List<Filter> filters = null;
        Long interval = null;
        List<MetricMeasuresQuery> metrics = null;
        List<Facet> facets = null;
        Integer limit = null;
        List<NumberRange> ranges = null;
        timeRange = this.timeRangeToTimeRange(request.timeRange());
        filters = this.filterListToFilterList(request.filters());
        interval = request.interval();
        metrics = this.facetMetricMeasuresRequestListToMetricMeasuresQueryList(request.metrics());
        facets = this.nameListToFacetList(request.facets());
        limit = request.limit();
        ranges = this.numberRangeListToNumberRangeList(request.ranges());
        TimeSeriesQuery timeSeriesQuery = new TimeSeriesQuery(timeRange, filters, interval, metrics, facets, limit, ranges);
        return timeSeriesQuery;
    }

    @Override
    public TimeSeriesResponse fromResult(TimeSeriesResult result) {
        if (result == null) {
            return null;
        }
        List<TimeSeriesMetricResponse> metrics = null;
        metrics = this.metricTimeSeriesResultListToTimeSeriesMetricResponseList(result.metrics());
        TimeSeriesResponse timeSeriesResponse = new TimeSeriesResponse(metrics);
        return timeSeriesResponse;
    }

    @Override
    public TimeSeriesMetricResponse fromResult(MetricTimeSeriesResult result) {
        if (result == null) {
            return null;
        }
        MetricSpec.Name name = null;
        List<TimeSeriesBucketResponse> buckets = null;
        name = this.fromResult(result.metric());
        buckets = this.timeSeriesBucketResultListToTimeSeriesBucketResponseList(result.buckets());
        TimeSeriesMetricResponse timeSeriesMetricResponse = new TimeSeriesMetricResponse(name, buckets);
        return timeSeriesMetricResponse;
    }

    @Override
    public FacetsQuery fromRequest(FacetsRequest request) {
        if (request == null) {
            return null;
        }
        io.gravitee.repository.analytics.engine.api.query.TimeRange timeRange = null;
        List<Filter> filters = null;
        List<MetricMeasuresQuery> metrics = null;
        List<Facet> facets = null;
        Integer limit = null;
        List<NumberRange> ranges = null;
        timeRange = this.timeRangeToTimeRange(request.timeRange());
        filters = this.filterListToFilterList(request.filters());
        metrics = this.facetMetricMeasuresRequestListToMetricMeasuresQueryList(request.metrics());
        facets = this.nameListToFacetList(request.facets());
        limit = request.limit();
        ranges = this.numberRangeListToNumberRangeList(request.ranges());
        FacetsQuery facetsQuery = new FacetsQuery(timeRange, filters, metrics, facets, limit, ranges);
        return facetsQuery;
    }

    @Override
    public FacetsResponse fromResult(FacetsResult result) {
        if (result == null) {
            return null;
        }
        List<MetricFacetsResponse> metrics = null;
        metrics = this.metricFacetsResultListToMetricFacetsResponseList(result.metrics());
        FacetsResponse facetsResponse = new FacetsResponse(metrics);
        return facetsResponse;
    }

    @Override
    public MeasuresQuery fromRequest(MeasuresRequest request) {
        if (request == null) {
            return null;
        }
        io.gravitee.repository.analytics.engine.api.query.TimeRange timeRange = null;
        List<Filter> filters = null;
        List<MetricMeasuresQuery> metrics = null;
        timeRange = this.timeRangeToTimeRange(request.timeRange());
        filters = this.filterListToFilterList(request.filters());
        metrics = this.metricMeasuresRequestListToMetricMeasuresQueryList(request.metrics());
        MeasuresQuery measuresQuery = new MeasuresQuery(timeRange, filters, metrics);
        return measuresQuery;
    }

    @Override
    public MetricMeasuresQuery fromRequest(FacetMetricMeasuresRequest request) {
        if (request == null) {
            return null;
        }
        Metric metric = null;
        Set<Measure> measures = null;
        List<MetricMeasuresQuery.Sort> sorts = null;
        metric = this.nameToMetric(request.name());
        measures = this.measureListToMeasureSet(request.measures());
        sorts = this.sortListToSortList(request.sorts());
        MetricMeasuresQuery metricMeasuresQuery = new MetricMeasuresQuery(metric, measures, sorts);
        return metricMeasuresQuery;
    }

    @Override
    public MetricMeasuresQuery fromRequest(MetricMeasuresRequest request) {
        if (request == null) {
            return null;
        }
        Metric metric = null;
        Set<Measure> measures = null;
        metric = this.nameToMetric(request.name());
        measures = this.measureListToMeasureSet(request.measures());
        List sorts = null;
        MetricMeasuresQuery metricMeasuresQuery = new MetricMeasuresQuery(metric, measures, sorts);
        return metricMeasuresQuery;
    }

    protected io.gravitee.repository.analytics.engine.api.query.TimeRange timeRangeToTimeRange(TimeRange timeRange) {
        if (timeRange == null) {
            return null;
        }
        Instant from = null;
        Instant to = null;
        from = timeRange.from();
        to = timeRange.to();
        io.gravitee.repository.analytics.engine.api.query.TimeRange timeRange1 = new io.gravitee.repository.analytics.engine.api.query.TimeRange(from, to);
        return timeRange1;
    }

    protected Filter.Name nameToName(FilterSpec.Name name) {
        if (name == null) {
            return null;
        }
        return switch (name) {
            case FilterSpec.Name.API -> Filter.Name.API;
            case FilterSpec.Name.APPLICATION -> Filter.Name.APPLICATION;
            case FilterSpec.Name.PLAN -> Filter.Name.PLAN;
            case FilterSpec.Name.GATEWAY -> Filter.Name.GATEWAY;
            case FilterSpec.Name.TENANT -> Filter.Name.TENANT;
            case FilterSpec.Name.ZONE -> Filter.Name.ZONE;
            case FilterSpec.Name.HTTP_METHOD -> Filter.Name.HTTP_METHOD;
            case FilterSpec.Name.HTTP_STATUS_CODE_GROUP -> Filter.Name.HTTP_STATUS_CODE_GROUP;
            case FilterSpec.Name.HTTP_STATUS -> Filter.Name.HTTP_STATUS;
            case FilterSpec.Name.HTTP_PATH -> Filter.Name.HTTP_PATH;
            case FilterSpec.Name.HTTP_PATH_MAPPING -> Filter.Name.HTTP_PATH_MAPPING;
            case FilterSpec.Name.HOST -> Filter.Name.HOST;
            case FilterSpec.Name.GEO_IP_COUNTRY -> Filter.Name.GEO_IP_COUNTRY;
            case FilterSpec.Name.GEO_IP_REGION -> Filter.Name.GEO_IP_REGION;
            case FilterSpec.Name.GEO_IP_CITY -> Filter.Name.GEO_IP_CITY;
            case FilterSpec.Name.GEO_IP_CONTINENT -> Filter.Name.GEO_IP_CONTINENT;
            case FilterSpec.Name.CONSUMER_IP -> Filter.Name.CONSUMER_IP;
            case FilterSpec.Name.HTTP_USER_AGENT_OS_NAME -> Filter.Name.HTTP_USER_AGENT_OS_NAME;
            case FilterSpec.Name.HTTP_USER_AGENT_DEVICE -> Filter.Name.HTTP_USER_AGENT_DEVICE;
            case FilterSpec.Name.MESSAGE_CONNECTOR_TYPE -> Filter.Name.MESSAGE_CONNECTOR_TYPE;
            case FilterSpec.Name.MESSAGE_CONNECTOR_ID -> Filter.Name.MESSAGE_CONNECTOR_ID;
            case FilterSpec.Name.MESSAGE_OPERATION_TYPE -> Filter.Name.MESSAGE_OPERATION_TYPE;
            case FilterSpec.Name.KAFKA_TOPIC -> Filter.Name.KAFKA_TOPIC;
            case FilterSpec.Name.API_STATE -> Filter.Name.API_STATE;
            case FilterSpec.Name.API_LIFECYCLE_STATE -> Filter.Name.API_LIFECYCLE_STATE;
            case FilterSpec.Name.API_VISIBILITY -> Filter.Name.API_VISIBILITY;
            case FilterSpec.Name.MESSAGE_SIZE -> Filter.Name.MESSAGE_SIZE;
            case FilterSpec.Name.MESSAGE_COUNT -> Filter.Name.MESSAGE_COUNT;
            case FilterSpec.Name.MESSAGE_ERROR_COUNT -> Filter.Name.MESSAGE_ERROR_COUNT;
            case FilterSpec.Name.HTTP_ENDPOINT_RESPONSE_TIME -> Filter.Name.HTTP_ENDPOINT_RESPONSE_TIME;
            case FilterSpec.Name.HTTP_GATEWAY_LATENCY -> Filter.Name.HTTP_GATEWAY_LATENCY;
            case FilterSpec.Name.HTTP_GATEWAY_RESPONSE_TIME -> Filter.Name.HTTP_GATEWAY_RESPONSE_TIME;
            case FilterSpec.Name.HTTP_REQUEST_CONTENT_LENGTH -> Filter.Name.HTTP_REQUEST_CONTENT_LENGTH;
            case FilterSpec.Name.HTTP_RESPONSE_CONTENT_LENGTH -> Filter.Name.HTTP_RESPONSE_CONTENT_LENGTH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)name));
        };
    }

    protected Filter.Operator operatorToOperator(FilterSpec.Operator operator) {
        if (operator == null) {
            return null;
        }
        return switch (operator) {
            case FilterSpec.Operator.EQ -> Filter.Operator.EQ;
            case FilterSpec.Operator.LTE -> Filter.Operator.LTE;
            case FilterSpec.Operator.GTE -> Filter.Operator.GTE;
            case FilterSpec.Operator.IN -> Filter.Operator.IN;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)operator));
        };
    }

    protected Filter filterToFilter(io.gravitee.apim.core.analytics_engine.model.Filter filter) {
        if (filter == null) {
            return null;
        }
        Filter.Name name = null;
        Filter.Operator operator = null;
        Object value = null;
        name = this.nameToName(filter.name());
        operator = this.operatorToOperator(filter.operator());
        value = filter.value();
        Filter filter1 = new Filter(name, operator, value);
        return filter1;
    }

    protected List<Filter> filterListToFilterList(List<io.gravitee.apim.core.analytics_engine.model.Filter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Filter> list1 = new ArrayList<Filter>(list.size());
        for (io.gravitee.apim.core.analytics_engine.model.Filter filter : list) {
            list1.add(this.filterToFilter(filter));
        }
        return list1;
    }

    protected List<MetricMeasuresQuery> facetMetricMeasuresRequestListToMetricMeasuresQueryList(List<FacetMetricMeasuresRequest> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MetricMeasuresQuery> list1 = new ArrayList<MetricMeasuresQuery>(list.size());
        for (FacetMetricMeasuresRequest facetMetricMeasuresRequest : list) {
            list1.add(this.fromRequest(facetMetricMeasuresRequest));
        }
        return list1;
    }

    protected Facet nameToFacet(FacetSpec.Name name) {
        if (name == null) {
            return null;
        }
        return switch (name) {
            case FacetSpec.Name.API -> Facet.API;
            case FacetSpec.Name.APPLICATION -> Facet.APPLICATION;
            case FacetSpec.Name.PLAN -> Facet.PLAN;
            case FacetSpec.Name.GATEWAY -> Facet.GATEWAY;
            case FacetSpec.Name.TENANT -> Facet.TENANT;
            case FacetSpec.Name.ZONE -> Facet.ZONE;
            case FacetSpec.Name.HTTP_METHOD -> Facet.HTTP_METHOD;
            case FacetSpec.Name.HTTP_STATUS_CODE_GROUP -> Facet.HTTP_STATUS_CODE_GROUP;
            case FacetSpec.Name.HTTP_STATUS -> Facet.HTTP_STATUS;
            case FacetSpec.Name.HTTP_PATH -> Facet.HTTP_PATH;
            case FacetSpec.Name.HTTP_PATH_MAPPING -> Facet.HTTP_PATH_MAPPING;
            case FacetSpec.Name.HOST -> Facet.HOST;
            case FacetSpec.Name.GEO_IP_COUNTRY -> Facet.GEO_IP_COUNTRY;
            case FacetSpec.Name.GEO_IP_REGION -> Facet.GEO_IP_REGION;
            case FacetSpec.Name.GEO_IP_CITY -> Facet.GEO_IP_CITY;
            case FacetSpec.Name.GEO_IP_CONTINENT -> Facet.GEO_IP_CONTINENT;
            case FacetSpec.Name.CONSUMER_IP -> Facet.CONSUMER_IP;
            case FacetSpec.Name.HTTP_USER_AGENT_OS_NAME -> Facet.HTTP_USER_AGENT_OS_NAME;
            case FacetSpec.Name.HTTP_USER_AGENT_DEVICE -> Facet.HTTP_USER_AGENT_DEVICE;
            case FacetSpec.Name.MESSAGE_CONNECTOR_TYPE -> Facet.MESSAGE_CONNECTOR_TYPE;
            case FacetSpec.Name.MESSAGE_CONNECTOR_ID -> Facet.MESSAGE_CONNECTOR_ID;
            case FacetSpec.Name.MESSAGE_OPERATION_TYPE -> Facet.MESSAGE_OPERATION_TYPE;
            case FacetSpec.Name.KAFKA_TOPIC -> Facet.KAFKA_TOPIC;
            case FacetSpec.Name.API_STATE -> Facet.API_STATE;
            case FacetSpec.Name.API_LIFECYCLE_STATE -> Facet.API_LIFECYCLE_STATE;
            case FacetSpec.Name.API_VISIBILITY -> Facet.API_VISIBILITY;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)name));
        };
    }

    protected List<Facet> nameListToFacetList(List<FacetSpec.Name> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Facet> list1 = new ArrayList<Facet>(list.size());
        for (FacetSpec.Name name : list) {
            list1.add(this.nameToFacet(name));
        }
        return list1;
    }

    protected NumberRange numberRangeToNumberRange(io.gravitee.apim.core.analytics_engine.model.NumberRange numberRange) {
        if (numberRange == null) {
            return null;
        }
        Number from = null;
        Number to = null;
        from = numberRange.from();
        to = numberRange.to();
        NumberRange numberRange1 = new NumberRange(from, to);
        return numberRange1;
    }

    protected List<NumberRange> numberRangeListToNumberRangeList(List<io.gravitee.apim.core.analytics_engine.model.NumberRange> list) {
        if (list == null) {
            return null;
        }
        ArrayList<NumberRange> list1 = new ArrayList<NumberRange>(list.size());
        for (io.gravitee.apim.core.analytics_engine.model.NumberRange numberRange : list) {
            list1.add(this.numberRangeToNumberRange(numberRange));
        }
        return list1;
    }

    protected List<TimeSeriesMetricResponse> metricTimeSeriesResultListToTimeSeriesMetricResponseList(List<MetricTimeSeriesResult> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TimeSeriesMetricResponse> list1 = new ArrayList<TimeSeriesMetricResponse>(list.size());
        for (MetricTimeSeriesResult metricTimeSeriesResult : list) {
            list1.add(this.fromResult(metricTimeSeriesResult));
        }
        return list1;
    }

    protected FacetBucketResponse facetBucketResultToFacetBucketResponse(FacetBucketResult facetBucketResult) {
        if (facetBucketResult == null) {
            return null;
        }
        String key = null;
        List<FacetBucketResponse> buckets = null;
        List<io.gravitee.apim.core.analytics_engine.model.Measure> measures = null;
        key = facetBucketResult.key();
        buckets = this.facetBucketResultListToFacetBucketResponseList(facetBucketResult.buckets());
        measures = this.fromResult(facetBucketResult.measures());
        String name = null;
        FacetBucketResponse facetBucketResponse = new FacetBucketResponse(key, name, buckets, measures);
        return facetBucketResponse;
    }

    protected List<FacetBucketResponse> facetBucketResultListToFacetBucketResponseList(List<FacetBucketResult> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FacetBucketResponse> list1 = new ArrayList<FacetBucketResponse>(list.size());
        for (FacetBucketResult facetBucketResult : list) {
            list1.add(this.facetBucketResultToFacetBucketResponse(facetBucketResult));
        }
        return list1;
    }

    protected TimeSeriesBucketResponse timeSeriesBucketResultToTimeSeriesBucketResponse(TimeSeriesBucketResult timeSeriesBucketResult) {
        if (timeSeriesBucketResult == null) {
            return null;
        }
        String key = null;
        Long timestamp = null;
        List<FacetBucketResponse> buckets = null;
        List<io.gravitee.apim.core.analytics_engine.model.Measure> measures = null;
        key = timeSeriesBucketResult.key();
        timestamp = timeSeriesBucketResult.timestamp();
        buckets = this.facetBucketResultListToFacetBucketResponseList(timeSeriesBucketResult.buckets());
        measures = this.fromResult(timeSeriesBucketResult.measures());
        String name = null;
        TimeSeriesBucketResponse timeSeriesBucketResponse = new TimeSeriesBucketResponse(key, name, timestamp, buckets, measures);
        return timeSeriesBucketResponse;
    }

    protected List<TimeSeriesBucketResponse> timeSeriesBucketResultListToTimeSeriesBucketResponseList(List<TimeSeriesBucketResult> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TimeSeriesBucketResponse> list1 = new ArrayList<TimeSeriesBucketResponse>(list.size());
        for (TimeSeriesBucketResult timeSeriesBucketResult : list) {
            list1.add(this.timeSeriesBucketResultToTimeSeriesBucketResponse(timeSeriesBucketResult));
        }
        return list1;
    }

    protected MetricFacetsResponse metricFacetsResultToMetricFacetsResponse(MetricFacetsResult metricFacetsResult) {
        if (metricFacetsResult == null) {
            return null;
        }
        MetricSpec.Name metric = null;
        List<FacetBucketResponse> buckets = null;
        metric = this.fromResult(metricFacetsResult.metric());
        buckets = this.facetBucketResultListToFacetBucketResponseList(metricFacetsResult.buckets());
        MetricFacetsResponse metricFacetsResponse = new MetricFacetsResponse(metric, buckets);
        return metricFacetsResponse;
    }

    protected List<MetricFacetsResponse> metricFacetsResultListToMetricFacetsResponseList(List<MetricFacetsResult> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MetricFacetsResponse> list1 = new ArrayList<MetricFacetsResponse>(list.size());
        for (MetricFacetsResult metricFacetsResult : list) {
            list1.add(this.metricFacetsResultToMetricFacetsResponse(metricFacetsResult));
        }
        return list1;
    }

    protected List<MetricMeasuresQuery> metricMeasuresRequestListToMetricMeasuresQueryList(List<MetricMeasuresRequest> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MetricMeasuresQuery> list1 = new ArrayList<MetricMeasuresQuery>(list.size());
        for (MetricMeasuresRequest metricMeasuresRequest : list) {
            list1.add(this.fromRequest(metricMeasuresRequest));
        }
        return list1;
    }

    protected Metric nameToMetric(MetricSpec.Name name) {
        if (name == null) {
            return null;
        }
        return switch (name) {
            case MetricSpec.Name.HTTP_REQUESTS -> Metric.HTTP_REQUESTS;
            case MetricSpec.Name.HTTP_ERRORS -> Metric.HTTP_ERRORS;
            case MetricSpec.Name.HTTP_REQUEST_CONTENT_LENGTH -> Metric.HTTP_REQUEST_CONTENT_LENGTH;
            case MetricSpec.Name.HTTP_RESPONSE_CONTENT_LENGTH -> Metric.HTTP_RESPONSE_CONTENT_LENGTH;
            case MetricSpec.Name.HTTP_ENDPOINT_RESPONSE_TIME -> Metric.HTTP_ENDPOINT_RESPONSE_TIME;
            case MetricSpec.Name.HTTP_GATEWAY_RESPONSE_TIME -> Metric.HTTP_GATEWAY_RESPONSE_TIME;
            case MetricSpec.Name.HTTP_GATEWAY_LATENCY -> Metric.HTTP_GATEWAY_LATENCY;
            case MetricSpec.Name.LLM_PROMPT_TOKEN_SENT -> Metric.LLM_PROMPT_TOKEN_SENT;
            case MetricSpec.Name.LLM_PROMPT_TOKEN_RECEIVED -> Metric.LLM_PROMPT_TOKEN_RECEIVED;
            case MetricSpec.Name.LLM_PROMPT_TOKEN_SENT_COST -> Metric.LLM_PROMPT_TOKEN_SENT_COST;
            case MetricSpec.Name.LLM_PROMPT_TOKEN_RECEIVED_COST -> Metric.LLM_PROMPT_TOKEN_RECEIVED_COST;
            case MetricSpec.Name.MESSAGE_PAYLOAD_SIZE -> Metric.MESSAGE_PAYLOAD_SIZE;
            case MetricSpec.Name.MESSAGES -> Metric.MESSAGES;
            case MetricSpec.Name.MESSAGE_ERRORS -> Metric.MESSAGE_ERRORS;
            case MetricSpec.Name.MESSAGE_GATEWAY_LATENCY -> Metric.MESSAGE_GATEWAY_LATENCY;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_PUBLISH_MESSAGES -> Metric.KAFKA_DOWNSTREAM_PUBLISH_MESSAGES;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_SUBSCRIBE_MESSAGES -> Metric.KAFKA_DOWNSTREAM_SUBSCRIBE_MESSAGES;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_PUBLISH_MESSAGES_BYTES -> Metric.KAFKA_DOWNSTREAM_PUBLISH_MESSAGES_BYTES;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_SUBSCRIBE_MESSAGE_BYTES -> Metric.KAFKA_DOWNSTREAM_SUBSCRIBE_MESSAGE_BYTES;
            case MetricSpec.Name.KAFKA_UPSTREAM_PUBLISH_MESSAGES -> Metric.KAFKA_UPSTREAM_PUBLISH_MESSAGES;
            case MetricSpec.Name.KAFKA_UPSTREAM_SUBSCRIBE_MESSAGES -> Metric.KAFKA_UPSTREAM_SUBSCRIBE_MESSAGES;
            case MetricSpec.Name.KAFKA_UPSTREAM_PUBLISH_MESSAGE_BYTES -> Metric.KAFKA_UPSTREAM_PUBLISH_MESSAGE_BYTES;
            case MetricSpec.Name.KAFKA_UPSTREAM_SUBSCRIBE_MESSAGE_BYTES -> Metric.KAFKA_UPSTREAM_SUBSCRIBE_MESSAGE_BYTES;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_AUTHENTICATION_SUCCESSES -> Metric.KAFKA_DOWNSTREAM_AUTHENTICATION_SUCCESSES;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_AUTHENTICATED_CONNECTIONS -> Metric.KAFKA_DOWNSTREAM_AUTHENTICATED_CONNECTIONS;
            case MetricSpec.Name.KAFKA_UPSTREAM_AUTHENTICATION_SUCCESSES -> Metric.KAFKA_UPSTREAM_AUTHENTICATION_SUCCESSES;
            case MetricSpec.Name.KAFKA_UPSTREAM_AUTHENTICATED_CONNECTIONS -> Metric.KAFKA_UPSTREAM_AUTHENTICATED_CONNECTIONS;
            case MetricSpec.Name.KAFKA_UPSTREAM_AUTHENTICATION_ERRORS -> Metric.KAFKA_UPSTREAM_AUTHENTICATION_ERRORS;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_AUTHENTICATION_ERRORS -> Metric.KAFKA_DOWNSTREAM_AUTHENTICATION_ERRORS;
            case MetricSpec.Name.KAFKA_DOWNSTREAM_ACTIVE_CONNECTIONS -> Metric.KAFKA_DOWNSTREAM_ACTIVE_CONNECTIONS;
            case MetricSpec.Name.KAFKA_UPSTREAM_ACTIVE_CONNECTIONS -> Metric.KAFKA_UPSTREAM_ACTIVE_CONNECTIONS;
            case MetricSpec.Name.SUBSCRIPTIONS -> Metric.SUBSCRIPTIONS;
            case MetricSpec.Name.APIS -> Metric.APIS;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)name));
        };
    }

    protected Measure measureToMeasure(MetricSpec.Measure measure) {
        if (measure == null) {
            return null;
        }
        return switch (measure) {
            case MetricSpec.Measure.AVG -> Measure.AVG;
            case MetricSpec.Measure.COUNT -> Measure.COUNT;
            case MetricSpec.Measure.MAX -> Measure.MAX;
            case MetricSpec.Measure.MIN -> Measure.MIN;
            case MetricSpec.Measure.RPS -> Measure.RPS;
            case MetricSpec.Measure.P50 -> Measure.P50;
            case MetricSpec.Measure.P99 -> Measure.P99;
            case MetricSpec.Measure.P95 -> Measure.P95;
            case MetricSpec.Measure.P90 -> Measure.P90;
            case MetricSpec.Measure.PERCENTAGE -> Measure.PERCENTAGE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)measure));
        };
    }

    protected Set<Measure> measureListToMeasureSet(List<MetricSpec.Measure> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<Measure> set = LinkedHashSet.newLinkedHashSet(list.size());
        for (MetricSpec.Measure measure : list) {
            set.add(this.measureToMeasure(measure));
        }
        return set;
    }

    protected MetricMeasuresQuery.Sort.Order orderToOrder(FacetMetricMeasuresRequest.Sort.Order order) {
        if (order == null) {
            return null;
        }
        return switch (order) {
            case FacetMetricMeasuresRequest.Sort.Order.ASC -> MetricMeasuresQuery.Sort.Order.ASC;
            case FacetMetricMeasuresRequest.Sort.Order.DESC -> MetricMeasuresQuery.Sort.Order.DESC;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)order));
        };
    }

    protected MetricMeasuresQuery.Sort sortToSort(FacetMetricMeasuresRequest.Sort sort) {
        if (sort == null) {
            return null;
        }
        Measure measure = null;
        MetricMeasuresQuery.Sort.Order order = null;
        measure = this.measureToMeasure(sort.measure());
        order = this.orderToOrder(sort.order());
        MetricMeasuresQuery.Sort sort1 = new MetricMeasuresQuery.Sort(measure, order);
        return sort1;
    }

    protected List<MetricMeasuresQuery.Sort> sortListToSortList(List<FacetMetricMeasuresRequest.Sort> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MetricMeasuresQuery.Sort> list1 = new ArrayList<MetricMeasuresQuery.Sort>(list.size());
        for (FacetMetricMeasuresRequest.Sort sort : list) {
            list1.add(this.sortToSort(sort));
        }
        return list1;
    }
}

