/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.exception.PortalNavigationItemNotFoundException;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemViewerContext;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetPortalNavigationItemUseCase {
    private final PortalNavigationItemsQueryService portalNavigationItemsQueryService;

    public Output execute(Input input) {
        PortalNavigationItem foundItem = Optional.ofNullable(this.portalNavigationItemsQueryService.findByIdAndEnvironmentId(input.environmentId(), input.portalNavigationItemId())).orElseThrow(() -> new PortalNavigationItemNotFoundException(input.portalNavigationItemId().id().toString()));
        input.viewerContext().validateAccess(foundItem);
        return new Output(foundItem);
    }

    @Generated
    public GetPortalNavigationItemUseCase(PortalNavigationItemsQueryService portalNavigationItemsQueryService) {
        this.portalNavigationItemsQueryService = portalNavigationItemsQueryService;
    }

    public record Input(PortalNavigationItemId portalNavigationItemId, String environmentId, PortalNavigationItemViewerContext viewerContext) {
    }

    public record Output(PortalNavigationItem portalNavigationItem) {
    }
}

