/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.domain_service.PortalNavigationItemDomainService;
import io.gravitee.apim.core.portal_page.exception.PortalNavigationItemHasChildrenException;
import io.gravitee.apim.core.portal_page.exception.PortalNavigationItemNotFoundException;
import io.gravitee.apim.core.portal_page.model.PortalNavigationFolder;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import java.util.List;
import lombok.Generated;

@UseCase
public class DeletePortalNavigationItemUseCase {
    private final PortalNavigationItemDomainService portalNavigationItemDomainService;
    private final PortalNavigationItemsQueryService portalNavigationItemsQueryService;

    public Output execute(Input input) {
        PortalNavigationItem existing = this.portalNavigationItemsQueryService.findByIdAndEnvironmentId(input.environmentId(), input.navigationItemId());
        if (existing == null) {
            throw new PortalNavigationItemNotFoundException(input.navigationItemId().json());
        }
        this.validateItemHasNoChildren(existing);
        this.portalNavigationItemDomainService.delete(existing);
        return new Output();
    }

    private void validateItemHasNoChildren(PortalNavigationItem existing) {
        if (!(existing instanceof PortalNavigationFolder)) {
            return;
        }
        List<PortalNavigationItem> directChildren = this.portalNavigationItemsQueryService.findByParentIdAndEnvironmentId(existing.getEnvironmentId(), existing.getId());
        if (!directChildren.isEmpty()) {
            throw PortalNavigationItemHasChildrenException.forId(existing.getId().toString());
        }
    }

    @Generated
    public DeletePortalNavigationItemUseCase(PortalNavigationItemDomainService portalNavigationItemDomainService, PortalNavigationItemsQueryService portalNavigationItemsQueryService) {
        this.portalNavigationItemDomainService = portalNavigationItemDomainService;
        this.portalNavigationItemsQueryService = portalNavigationItemsQueryService;
    }

    public record Input(String organizationId, String environmentId, PortalNavigationItemId navigationItemId) {
    }

    public record Output() {
    }
}

