/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.domain_service.DocumentationValidationDomainService;
import io.gravitee.apim.core.documentation.domain_service.ValidatePageAccessControlsDomainService;
import io.gravitee.apim.core.documentation.domain_service.ValidatePageSourceDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.factory.PageModelFactory;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.rest.api.service.common.IdBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ValidatePagesDomainService
implements Validator<Input> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatePagesDomainService.class);
    private final ValidatePageSourceDomainService pageSourceValidator;
    private final ValidatePageAccessControlsDomainService accessControlsValidator;
    private final DocumentationValidationDomainService validationDomainService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        if (input.pages() == null || input.pages().isEmpty()) {
            log.debug("no pages to validate and sanitize");
            return Validator.Result.ofValue(input);
        }
        log.debug("validating pages");
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashMap<String, PageCRD> sanitizedPages = new HashMap<String, PageCRD>();
        input.pages.forEach((k, v) -> {
            try {
                Page page = PageModelFactory.fromCRDSpec(k, v);
                page.setReferenceId(input.apiId());
                if (page.getId() == null) {
                    page.setId(IdBuilder.builder(input.auditInfo, input.apiHrid).withExtraId((String)k).buildId());
                    v.setId(page.getId());
                }
                page.setHrid((String)k);
                if (v.getParentId() == null && v.getParentHrid() != null) {
                    page.setParentId(IdBuilder.builder(input.auditInfo, input.apiHrid).withExtraId(v.getParentHrid()).buildId());
                }
                this.pageSourceValidator.validateAndSanitize(new ValidatePageSourceDomainService.Input((String)k, page.getSource())).peek(sanitized -> page.setSource(sanitized.source()), errors::addAll);
                this.accessControlsValidator.validateAndSanitize(new ValidatePageAccessControlsDomainService.Input(input.auditInfo, page.getAccessControls())).peek(sanitized -> page.setAccessControls(sanitized.accessControls()), errors::addAll);
                if (errors.stream().noneMatch(Validator.Error::isSevere)) {
                    Page sanitizedPage = this.validationDomainService.validateAndSanitizeForUpdate(page, input.auditInfo.organizationId(), false);
                    sanitizedPages.put((String)k, PageModelFactory.toCRDSpec(sanitizedPage));
                }
                if (page.getType() != Page.Type.ROOT && StringUtils.isEmpty(page.getName())) {
                    errors.add(Validator.Error.severe("Page [%s] is missing required property [name]", k));
                }
            }
            catch (Exception e) {
                errors.add(Validator.Error.severe("invalid documentation page [%s]. Error: %s", k, e.getMessage()));
            }
        });
        return Validator.Result.ofBoth(input.sanitized(sanitizedPages), errors);
    }

    @Generated
    public ValidatePagesDomainService(ValidatePageSourceDomainService pageSourceValidator, ValidatePageAccessControlsDomainService accessControlsValidator, DocumentationValidationDomainService validationDomainService) {
        this.pageSourceValidator = pageSourceValidator;
        this.accessControlsValidator = accessControlsValidator;
        this.validationDomainService = validationDomainService;
    }

    public record Input(AuditInfo auditInfo, String apiId, String apiHrid, Map<String, PageCRD> pages) implements Validator.Input
    {
        Input sanitized(Map<String, PageCRD> sanitizedPages) {
            return new Input(this.auditInfo, this.apiId, this.apiHrid, sanitizedPages);
        }
    }
}

