/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case.cockpit;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.OAIDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.domain_service.cockpit.DeployModelToApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class DeployModelToApiUpdateUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployModelToApiUpdateUseCase.class);
    private final OAIDomainService oaiDomainService;
    private final UpdateApiDomainService updateApiDomainService;
    private final DeployModelToApiDomainService deployModelToApiDomainService;
    private final PlanCrudService planCrudService;
    private final PageCrudService pageCrudService;

    public DeployModelToApiUpdateUseCase(OAIDomainService oaiDomainService, UpdateApiDomainService updateApiDomainService, DeployModelToApiDomainService deployModelToApiDomainService, PlanCrudService planCrudService, PageCrudService pageCrudService) {
        this.oaiDomainService = oaiDomainService;
        this.updateApiDomainService = updateApiDomainService;
        this.deployModelToApiDomainService = deployModelToApiDomainService;
        this.planCrudService = planCrudService;
        this.pageCrudService = pageCrudService;
    }

    public Output execute(Input input) {
        log.debug("API [id: {} / crossId: {}] will be updated with mode {}.", new Object[]{input.apiId(), input.apiCrossId(), input.mode().name()});
        String organizationId = input.auditInfo().organizationId();
        String environmentId = input.auditInfo().environmentId();
        ImportSwaggerDescriptorEntity importSwaggerDescriptorEntity = this.deployModelToApiDomainService.configure(input.mode(), input.swaggerDefinition());
        ImportDefinition importDefinition = this.oaiDomainService.convert(organizationId, environmentId, importSwaggerDescriptorEntity, true, false);
        this.managePlan(input);
        this.manageDocumentationPage(input, importDefinition.getPages().getFirst());
        importDefinition.getApiExport().setId(input.apiId());
        importDefinition.getApiExport().setCrossId(input.apiCrossId());
        importDefinition.getApiExport().setLabels(input.labels());
        Api apiUpdated = this.updateApiDomainService.updateV4(ApiModelFactory.fromApiExport(importDefinition.getApiExport(), environmentId), input.auditInfo());
        Api api = this.deployModelToApiDomainService.manageApiState(apiUpdated, input.auditInfo(), input.mode());
        log.info("API [id: {} / crossId: {}] v4 updated.", (Object)api.getId(), (Object)api.getCrossId());
        return new Output(api);
    }

    private void managePlan(Input input) {
        Collection<Plan> plans = this.planCrudService.findByApiId(input.apiId());
        if (plans.stream().noneMatch(plan -> plan.getPlanStatus() == PlanStatus.PUBLISHED)) {
            this.planCrudService.create((Plan)((Plan.PlanBuilder)((Plan.PlanBuilder)new Plan(input.apiId(), this.deployModelToApiDomainService.createDefaultPlan()).toBuilder().needRedeployAt(Date.from(TimeProvider.now().toInstant()))).validation(Plan.PlanValidationType.AUTO)).build());
        }
    }

    private void manageDocumentationPage(Input input, Page pageToCreate) {
        List<Page> pages = this.pageCrudService.findByApiId(input.apiId());
        long swaggerDocumentationPageCount = pages.stream().filter(page -> page.getType() == Page.Type.SWAGGER).count();
        if (swaggerDocumentationPageCount > 1L) {
            log.warn("More than one Swagger documentation page already exists for this API [id: {} / crossId: {}].", (Object)input.apiId(), (Object)input.apiCrossId());
            return;
        }
        if (swaggerDocumentationPageCount == 0L) {
            log.warn("No Swagger documentation page exists for this API [id: {} / crossId: {}].", (Object)input.apiId(), (Object)input.apiCrossId());
            pageToCreate.setId(UuidString.generateRandom());
            pageToCreate.setCreatedAt(Date.from(TimeProvider.now().toInstant()));
            pageToCreate.setUpdatedAt(Date.from(TimeProvider.now().toInstant()));
            pageToCreate.setReferenceId(input.apiId());
            this.pageCrudService.createDocumentationPage(pageToCreate);
            return;
        }
        Page currentPage = pages.getFirst();
        currentPage.setContent(pageToCreate.getContent());
        currentPage.setUpdatedAt(Date.from(TimeProvider.now().toInstant()));
        this.pageCrudService.updateDocumentationPage(currentPage);
    }

    public record Input(String swaggerDefinition, AuditInfo auditInfo, String apiId, String apiCrossId, DeployModelToApiDomainService.Mode mode, List<String> labels) {
    }

    public record Output(Api api) {
    }
}

