/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case.cockpit;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.OAIDomainService;
import io.gravitee.apim.core.api.domain_service.cockpit.DeployModelToApiDomainService;
import io.gravitee.apim.core.api.domain_service.import_definition.ImportDefinitionCreateDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class DeployModelToApiCreateUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployModelToApiCreateUseCase.class);
    private final OAIDomainService oaiDomainService;
    private final ImportDefinitionCreateDomainService importDefinitionCreateDomainService;
    private final DeployModelToApiDomainService deployModelToApiDomainService;

    public DeployModelToApiCreateUseCase(OAIDomainService oaiDomainService, ImportDefinitionCreateDomainService importDefinitionCreateDomainService, DeployModelToApiDomainService deployModelToApiDomainService) {
        this.oaiDomainService = oaiDomainService;
        this.importDefinitionCreateDomainService = importDefinitionCreateDomainService;
        this.deployModelToApiDomainService = deployModelToApiDomainService;
    }

    public Output execute(Input input) {
        log.debug("API [crossId: {}] will be created with mode {}.", (Object)input.apiCrossId(), (Object)input.mode().name());
        String organizationId = input.auditInfo().organizationId();
        String environmentId = input.auditInfo().environmentId();
        ImportSwaggerDescriptorEntity importSwaggerDescriptorEntity = this.deployModelToApiDomainService.configure(input.mode(), input.swaggerDefinition());
        ImportDefinition importDefinition = this.oaiDomainService.convert(organizationId, environmentId, importSwaggerDescriptorEntity, true, false);
        importDefinition.getApiExport().setCrossId(input.apiCrossId());
        importDefinition.getApiExport().setLabels(input.labels());
        importDefinition.setPlans(Set.of(new PlanWithFlows((Plan)((Plan.PlanBuilder)new Plan(null, this.deployModelToApiDomainService.createDefaultPlan()).toBuilder().validation(Plan.PlanValidationType.AUTO)).build(), List.of())));
        ApiWithFlows apiWithFlows = this.importDefinitionCreateDomainService.create(input.auditInfo(), importDefinition);
        Api api = this.deployModelToApiDomainService.manageApiState(apiWithFlows, input.auditInfo, input.mode());
        log.info("API [id: {} / crossId: {}] v4 created.", (Object)api.getId(), (Object)api.getCrossId());
        return new Output(api);
    }

    public record Input(String swaggerDefinition, AuditInfo auditInfo, String apiCrossId, DeployModelToApiDomainService.Mode mode, List<String> labels) {
    }

    public record Output(Api api) {
    }
}

