/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.query_service.ApiEventQueryService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.environment.crud_service.EnvironmentCrudService;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.service.Service;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class UpdateDynamicPropertiesUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateDynamicPropertiesUseCase.class);
    private final ApiCrudService apiCrudService;
    private final ApiStateDomainService apiStateDomainService;
    private final EnvironmentCrudService environmentCrudService;
    private final AuditDomainService auditDomainService;
    private final ApiEventQueryService apiEventQueryService;
    private final CategoryDomainService categoryDomainService;

    public UpdateDynamicPropertiesUseCase(ApiCrudService apiCrudService, ApiStateDomainService apiStateDomainService, EnvironmentCrudService environmentCrudService, AuditDomainService auditDomainService, ApiEventQueryService apiEventQueryService, CategoryDomainService categoryDomainService) {
        this.apiCrudService = apiCrudService;
        this.apiStateDomainService = apiStateDomainService;
        this.environmentCrudService = environmentCrudService;
        this.auditDomainService = auditDomainService;
        this.apiEventQueryService = apiEventQueryService;
        this.categoryDomainService = categoryDomainService;
    }

    public void execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId());
        AuditInfo auditInfo = this.buildAuditInfo(input, api);
        boolean isApiSynchronized = this.apiStateDomainService.isSynchronized(api, auditInfo);
        List<Property> previousProperties = UpdateDynamicPropertiesUseCase.getCurrentProperties(api);
        boolean needToBeUpdated = api.updateDynamicProperties(input.dynamicProperties());
        if (!needToBeUpdated) {
            return;
        }
        api.setCategories(this.categoryDomainService.toCategoryId(api, api.getEnvironmentId()));
        Api updated = this.apiCrudService.update(api);
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().apiId(updated.getId()).environmentId(auditInfo.environmentId()).organizationId(auditInfo.organizationId()).event(ApiAuditEvent.API_UPDATED).actor(auditInfo.actor()).oldValue(api).newValue(updated).createdAt(ZonedDateTime.ofInstant(api.getUpdatedAt().toInstant(), ZoneId.systemDefault())).properties(Map.of(AuditProperties.API, api.getId())).build());
        if (isApiSynchronized && UpdateDynamicPropertiesUseCase.needRedployment(api.getApiDefinitionHttpV4().getProperties(), previousProperties)) {
            this.apiEventQueryService.findLastPublishedApi(auditInfo.organizationId(), auditInfo.environmentId(), api.getId()).ifPresent(deployedApi -> {
                if (deployedApi.getApiDefinitionHttpV4().getServices() == null || deployedApi.getApiDefinitionHttpV4().getServices().getDynamicProperty() == null) {
                    return;
                }
                Service deployedDynamicPropertiesService = deployedApi.getApiDefinitionHttpV4().getServices().getDynamicProperty();
                if (deployedDynamicPropertiesService.isEnabled()) {
                    updated.getApiDefinitionHttpV4().getServices().setDynamicProperty(deployedDynamicPropertiesService);
                }
            });
            this.apiStateDomainService.deploy(updated, String.format("%s sync", input.pluginId()), auditInfo);
        }
    }

    private static boolean needRedployment(List<Property> updatedProperties, List<Property> previousProperties) {
        return !new HashSet<Property>(updatedProperties).equals(new HashSet<Property>(previousProperties));
    }

    private static List<Property> getCurrentProperties(Api api) {
        return Optional.ofNullable(api.getApiDefinitionHttpV4().getProperties()).orElse(Collections.emptyList()).stream().toList();
    }

    private AuditInfo buildAuditInfo(Input input, Api apiForUpdate) {
        return AuditInfo.builder().environmentId(apiForUpdate.getEnvironmentId()).organizationId(this.environmentCrudService.get(apiForUpdate.getEnvironmentId()).getOrganizationId()).actor(AuditActor.builder().userId(String.format("%s-management-api-service", input.pluginId())).build()).build();
    }

    public record Input(String apiId, String pluginId, List<Property> dynamicProperties) {
    }
}

