/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics_engine.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics_engine.domain_service.AnalyticsQueryValidator;
import io.gravitee.apim.core.analytics_engine.domain_service.FilterPreProcessor;
import io.gravitee.apim.core.analytics_engine.model.Filter;
import io.gravitee.apim.core.analytics_engine.model.MeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MeasuresResponse;
import io.gravitee.apim.core.analytics_engine.model.MetricsContext;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsEngineQueryService;
import io.gravitee.apim.core.analytics_engine.service_provider.AnalyticsQueryContextProvider;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@UseCase
public class ComputeMeasuresUseCase {
    private final AnalyticsQueryContextProvider queryContextProvider;
    private final AnalyticsQueryValidator validator;
    private final FilterPreProcessor filterPreprocessor;

    public ComputeMeasuresUseCase(AnalyticsQueryContextProvider queryContextResolver, AnalyticsQueryValidator validator, FilterPreProcessor filterPreprocessor) {
        this.queryContextProvider = queryContextResolver;
        this.validator = validator;
        this.filterPreprocessor = filterPreprocessor;
    }

    public Output execute(Input input) {
        this.validator.validateMeasuresRequest(input.request);
        ExecutionContext executionContext = new ExecutionContext(input.auditInfo.organizationId(), input.auditInfo.environmentId());
        MetricsContext metricsContextWithPermissions = this.filterPreprocessor.buildFilters(new MetricsContext(input.auditInfo));
        Map<AnalyticsEngineQueryService, MeasuresRequest> queryContext = this.queryContextProvider.resolve(input.request);
        List<MeasuresResponse> responses = this.executeQueries(executionContext, metricsContextWithPermissions, queryContext);
        return new Output(MeasuresResponse.merge(responses));
    }

    private List<MeasuresResponse> executeQueries(ExecutionContext executionContext, MetricsContext metricsContext, Map<AnalyticsEngineQueryService, MeasuresRequest> queryExecutions) {
        ArrayList<MeasuresResponse> responses = new ArrayList<MeasuresResponse>();
        queryExecutions.forEach((queryService, request) -> {
            ArrayList<Filter> filters = new ArrayList<Filter>(request.filters());
            filters.addAll(metricsContext.filters());
            responses.add(queryService.searchMeasures(executionContext, request.withFilters(filters)));
        });
        return responses;
    }

    public record Input(AuditInfo auditInfo, MeasuresRequest request) {
    }

    public record Output(MeasuresResponse response) {
    }
}

