/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.analytics.query.AggregationType;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.response.histogram.Data;
import io.gravitee.repository.healthcheck.api.HealthCheckRepository;
import io.gravitee.repository.healthcheck.query.DateHistogramQueryBuilder;
import io.gravitee.repository.healthcheck.query.FieldBucket;
import io.gravitee.repository.healthcheck.query.Query;
import io.gravitee.repository.healthcheck.query.QueryBuilders;
import io.gravitee.repository.healthcheck.query.availability.AvailabilityQuery;
import io.gravitee.repository.healthcheck.query.availability.AvailabilityQueryBuilder;
import io.gravitee.repository.healthcheck.query.availability.AvailabilityResponse;
import io.gravitee.repository.healthcheck.query.log.ExtendedLog;
import io.gravitee.repository.healthcheck.query.log.LogsQueryBuilder;
import io.gravitee.repository.healthcheck.query.log.LogsResponse;
import io.gravitee.repository.healthcheck.query.log.Response;
import io.gravitee.repository.healthcheck.query.log.Step;
import io.gravitee.repository.healthcheck.query.response.histogram.DateHistogramResponse;
import io.gravitee.repository.healthcheck.query.responsetime.AverageResponseTimeQuery;
import io.gravitee.repository.healthcheck.query.responsetime.AverageResponseTimeQueryBuilder;
import io.gravitee.repository.healthcheck.query.responsetime.AverageResponseTimeResponse;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.analytics.Analytics;
import io.gravitee.rest.api.model.analytics.Bucket;
import io.gravitee.rest.api.model.analytics.HistogramAnalytics;
import io.gravitee.rest.api.model.analytics.Timestamp;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.healthcheck.ApiMetrics;
import io.gravitee.rest.api.model.healthcheck.Log;
import io.gravitee.rest.api.model.healthcheck.Request;
import io.gravitee.rest.api.model.healthcheck.SearchLogResponse;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.HealthCheckService;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.AnalyticsCalculateException;
import io.gravitee.rest.api.service.exceptions.InstanceNotFoundException;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckServiceImpl
implements HealthCheckService {
    private final Logger logger = LoggerFactory.getLogger(HealthCheckServiceImpl.class);
    @Lazy
    @Autowired
    private HealthCheckRepository healthCheckRepository;
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private InstanceService instanceService;

    @Override
    public Analytics query(DateHistogramQuery query) {
        try {
            DateHistogramResponse response;
            DateHistogramQueryBuilder queryBuilder = (DateHistogramQueryBuilder)((DateHistogramQueryBuilder)((DateHistogramQueryBuilder)QueryBuilders.dateHistogram().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier());
            if (query.getAggregations() != null) {
                query.getAggregations().stream().forEach(aggregation -> queryBuilder.aggregation(AggregationType.valueOf((String)aggregation.type().name()), aggregation.field()));
            }
            return (response = (DateHistogramResponse)this.healthCheckRepository.query((Query)queryBuilder.build())) != null ? this.convert(response) : null;
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new AnalyticsCalculateException("Unable to calculate analytics");
        }
    }

    private HistogramAnalytics convert(DateHistogramResponse histogramResponse) {
        HistogramAnalytics analytics = new HistogramAnalytics();
        List timestamps = histogramResponse.timestamps();
        if (timestamps != null && timestamps.size() > 1) {
            long from = (Long)timestamps.get(0);
            long interval = (Long)timestamps.get(1) - from;
            long to = (Long)timestamps.get(timestamps.size() - 1);
            analytics.setTimestamp(new Timestamp(Long.valueOf(from), Long.valueOf(to), Long.valueOf(interval)));
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(histogramResponse.values().size());
            for (io.gravitee.repository.analytics.query.response.histogram.Bucket bucket : histogramResponse.values()) {
                Bucket analyticsBucket = this.convertBucket(histogramResponse.timestamps(), from, interval, bucket);
                buckets.add(analyticsBucket);
            }
            analytics.setValues(buckets);
        }
        return analytics;
    }

    private Bucket convertBucket(List<Long> timestamps, long from, long interval, io.gravitee.repository.analytics.query.response.histogram.Bucket bucket) {
        Bucket analyticsBucket = new Bucket();
        analyticsBucket.setName(bucket.name());
        analyticsBucket.setField(bucket.field());
        ArrayList<Bucket> childBuckets = new ArrayList<Bucket>();
        for (io.gravitee.repository.analytics.query.response.histogram.Bucket bucket2 : bucket.buckets()) {
            childBuckets.add(this.convertBucket(timestamps, from, interval, bucket2));
        }
        for (Map.Entry entry : bucket.data().entrySet()) {
            Bucket analyticsDataBucket = new Bucket();
            analyticsDataBucket.setName((String)entry.getKey());
            Number[] values = new Number[timestamps.size()];
            for (int i = 0; i < timestamps.size(); ++i) {
                values[i] = 0;
            }
            for (Data data : (List)entry.getValue()) {
                values[(int)((data.timestamp() - from) / interval)] = data.value();
            }
            analyticsDataBucket.setData(values);
            childBuckets.add(analyticsDataBucket);
        }
        analyticsBucket.setBuckets(childBuckets);
        return analyticsBucket;
    }

    @Override
    public ApiMetrics getAvailability(ExecutionContext executionContext, String api, String field) {
        this.logger.debug("Run health availability query for API '{}'", (Object)api);
        try {
            GenericApiEntity apiEntity = this.apiSearchService.findGenericById(executionContext, api);
            AvailabilityResponse response = (AvailabilityResponse)this.healthCheckRepository.query((Query)((AvailabilityQueryBuilder)QueryBuilders.availability().api(api)).field(AvailabilityQuery.Field.valueOf((String)field)).build());
            return response != null ? this.convert(executionContext, apiEntity, response.getEndpointAvailabilities(), field) : null;
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public ApiMetrics getResponseTime(ExecutionContext executionContext, String api, String field) {
        this.logger.debug("Run health response-time query for API '{}'", (Object)api);
        try {
            GenericApiEntity apiEntity = this.apiSearchService.findGenericById(executionContext, api);
            AverageResponseTimeResponse response = (AverageResponseTimeResponse)this.healthCheckRepository.query((Query)((AverageResponseTimeQueryBuilder)QueryBuilders.responseTime().api(api)).field(AverageResponseTimeQuery.Field.valueOf((String)field)).build());
            return response != null ? this.convert(executionContext, apiEntity, response.getEndpointResponseTimes(), field) : null;
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public SearchLogResponse findByApi(ExecutionContext executionContext, String api, LogQuery query, Boolean transition) {
        this.logger.debug("Run health logs query for API '{}'", (Object)api);
        try {
            LogsResponse response = (LogsResponse)this.healthCheckRepository.query((Query)((LogsQueryBuilder)((LogsQueryBuilder)QueryBuilders.logs().api(api)).page(query.getPage()).size(query.getSize()).query(query.getQuery())).transition(transition).from(query.getFrom()).to(query.getTo()).build());
            return response != null ? this.convert(executionContext, response) : null;
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Log findLog(String id) {
        try {
            ExtendedLog log = this.healthCheckRepository.findById(id);
            return log != null ? this.toLog(log) : null;
        }
        catch (AnalyticsException ae) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ae);
            return null;
        }
    }

    private SearchLogResponse convert(ExecutionContext executionContext, LogsResponse response) {
        SearchLogResponse searchLogResponseResponse = new SearchLogResponse(response.getSize());
        searchLogResponseResponse.setLogs(response.getLogs().stream().map(this::toLog).collect(Collectors.toList()));
        if (response.getSize() > 0L) {
            HashMap metadata = new HashMap();
            searchLogResponseResponse.getLogs().forEach(logItem -> {
                String gateway = logItem.getGateway();
                if (gateway != null) {
                    metadata.computeIfAbsent(gateway, gateway1 -> this.getGatewayMetadata(executionContext, (String)gateway1));
                }
            });
            searchLogResponseResponse.setMetadata(metadata);
        }
        return searchLogResponseResponse;
    }

    private <T extends Number> ApiMetrics<T> convert(ExecutionContext executionContext, GenericApiEntity api, List<FieldBucket<T>> response, String field) {
        ApiMetrics apiMetrics = new ApiMetrics();
        HashMap buckets = new HashMap();
        response.forEach(bucket -> {
            Map<String, Number> bucketMetrics = bucket.getValues().stream().collect(Collectors.toMap(io.gravitee.repository.healthcheck.query.Bucket::getKey, io.gravitee.repository.healthcheck.query.Bucket::getValue));
            buckets.put(bucket.getName(), bucketMetrics);
        });
        apiMetrics.setBuckets(buckets);
        if (!apiMetrics.getBuckets().isEmpty()) {
            HashMap<String, Double> values = new HashMap<String, Double>();
            apiMetrics.getBuckets().values().forEach(stringTMap -> stringTMap.forEach((key, value) -> {
                if (value.intValue() >= 0) {
                    Double total = values.getOrDefault(key, 0.0);
                    total = total + value.doubleValue();
                    values.put((String)key, total);
                }
            }));
            values.forEach((key, value) -> {
                long availableBuckets = apiMetrics.getBuckets().values().stream().filter(stringTMap -> ((Number)stringTMap.get(key)).intValue() >= 0).count();
                values.put((String)key, value / (double)availableBuckets);
            });
            apiMetrics.setGlobal(values);
        }
        HashMap metadata = new HashMap();
        apiMetrics.getBuckets().keySet().forEach(name -> {
            if (field.equalsIgnoreCase("endpoint")) {
                metadata.put(name, this.getEndpointMetadata(api, (String)name));
            } else if (field.equalsIgnoreCase("gateway")) {
                metadata.put(name, this.getGatewayMetadata(executionContext, (String)name));
            }
        });
        apiMetrics.setMetadata(metadata);
        return apiMetrics;
    }

    private Log toLog(io.gravitee.repository.healthcheck.query.log.Log repoLog) {
        Log log = new Log();
        log.setId(repoLog.getId());
        log.setTimestamp(repoLog.getTimestamp());
        log.setAvailable(repoLog.isAvailable());
        log.setSuccess(repoLog.isSuccess());
        log.setEndpoint(repoLog.getEndpoint());
        log.setGateway(repoLog.getGateway());
        log.setResponseTime(repoLog.getResponseTime());
        log.setState(repoLog.getState());
        Request request = new Request();
        request.setMethod(repoLog.getMethod());
        request.setUri(repoLog.getUri());
        log.setRequest(request);
        io.gravitee.rest.api.model.healthcheck.Response response = new io.gravitee.rest.api.model.healthcheck.Response();
        response.setStatus(repoLog.getStatus());
        log.setResponse(response);
        return log;
    }

    private Log toLog(ExtendedLog repoLog) {
        Log log = new Log();
        log.setId(repoLog.getId());
        log.setTimestamp(repoLog.getTimestamp());
        log.setAvailable(repoLog.isAvailable());
        log.setSuccess(repoLog.isSuccess());
        log.setEndpoint(repoLog.getEndpoint());
        log.setGateway(repoLog.getGateway());
        log.setResponseTime(repoLog.getResponseTime());
        log.setState(repoLog.getState());
        log.setMessage(((Step)repoLog.getSteps().get(0)).getMessage());
        log.setRequest(this.createRequest(((Step)repoLog.getSteps().get(0)).getRequest()));
        log.setResponse(this.createResponse(((Step)repoLog.getSteps().get(0)).getResponse()));
        return log;
    }

    private Request createRequest(io.gravitee.repository.healthcheck.query.log.Request repoRequest) {
        if (repoRequest == null) {
            return null;
        }
        Request request = new Request();
        request.setUri(repoRequest.getUri());
        request.setMethod(repoRequest.getMethod());
        request.setHeaders((Map)repoRequest.getHeaders());
        request.setBody(repoRequest.getBody());
        return request;
    }

    private io.gravitee.rest.api.model.healthcheck.Response createResponse(Response repoResponse) {
        if (repoResponse == null) {
            return null;
        }
        io.gravitee.rest.api.model.healthcheck.Response response = new io.gravitee.rest.api.model.healthcheck.Response();
        response.setStatus(repoResponse.getStatus());
        response.setHeaders((Map)repoResponse.getHeaders());
        response.setBody(repoResponse.getBody());
        return response;
    }

    private Map<String, String> getEndpointMetadata(GenericApiEntity api, String endpointName) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            Optional<io.gravitee.definition.model.v4.endpointgroup.Endpoint> endpointOpt = ((io.gravitee.rest.api.model.v4.api.ApiEntity)api).getEndpointGroups().stream().filter(group -> group.getEndpoints() != null).flatMap(group -> group.getEndpoints().stream()).filter(endpoint -> endpoint.getName().equalsIgnoreCase(endpointName)).findFirst();
            if (endpointOpt.isPresent()) {
                io.gravitee.definition.model.v4.endpointgroup.Endpoint endpoint2 = endpointOpt.get();
                metadata.put("target", endpoint2.getType());
            } else {
                metadata.put("deleted", "true");
            }
        } else {
            Optional<Endpoint> endpointOpt = ((ApiEntity)api).getProxy().getGroups().stream().filter(group -> group.getEndpoints() != null).flatMap(group -> group.getEndpoints().stream()).filter(endpoint -> endpoint.getName().equalsIgnoreCase(endpointName)).findFirst();
            if (endpointOpt.isPresent()) {
                metadata.put("target", endpointOpt.get().getTarget());
            } else {
                metadata.put("deleted", "true");
            }
        }
        return metadata;
    }

    private Map<String, String> getGatewayMetadata(ExecutionContext executionContext, String gateway) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            InstanceEntity instance = this.instanceService.findById(executionContext, gateway);
            metadata.put("hostname", instance.getHostname());
            metadata.put("ip", instance.getIp());
            if (instance.getTenant() != null) {
                metadata.put("tenant", instance.getTenant());
            }
        }
        catch (InstanceNotFoundException infe) {
            metadata.put("deleted", "true");
        }
        return metadata;
    }
}

