/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.DuplicateApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiIdsCalculatorService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipDuplicateService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageDuplicateService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import io.gravitee.rest.api.service.exceptions.ApiImportException;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.imports.ImportApiJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNodeWithIds;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minidev.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiDuplicatorServiceImpl
extends AbstractService
implements ApiDuplicatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDuplicatorServiceImpl.class);
    public static final String API_DEFINITION_FIELD_GROUPS = "groups";
    public static final String API_DEFINITION_FIELD_PLANS = "plans";
    public static final String API_DEFINITION_FIELD_MEMBERS = "members";
    public static final String API_DEFINITION_FIELD_PAGES = "pages";
    private final HttpClientService httpClientService;
    private final ImportConfiguration importConfiguration;
    private final MediaService mediaService;
    private final ObjectMapper objectMapper;
    private final ApiMetadataService apiMetadataService;
    private final MembershipService membershipService;
    private final MembershipDuplicateService membershipDuplicateService;
    private final RoleService roleService;
    private final PageService pageService;
    private final PageDuplicateService pageDuplicateService;
    private final PlanService planService;
    private final GroupService groupService;
    private final UserService userService;
    private final ApiService apiService;
    private final ApiConverter apiConverter;
    private final PlanConverter planConverter;
    private final PermissionService permissionService;
    private final ApiIdsCalculatorService apiIdsCalculatorService;

    public ApiDuplicatorServiceImpl(HttpClientService httpClientService, ImportConfiguration importConfiguration, MediaService mediaService, ObjectMapper objectMapper, ApiMetadataService apiMetadataService, MembershipService membershipService, MembershipDuplicateService membershipDuplicateService, RoleService roleService, PageService pageService, PageDuplicateService pageDuplicateService, PlanService planService, GroupService groupService, UserService userService, @Lazy ApiService apiService, ApiConverter apiConverter, PlanConverter planConverter, PermissionService permissionService, ApiIdsCalculatorService apiIdsCalculatorService) {
        this.httpClientService = httpClientService;
        this.importConfiguration = importConfiguration;
        this.mediaService = mediaService;
        this.objectMapper = objectMapper;
        this.apiMetadataService = apiMetadataService;
        this.membershipService = membershipService;
        this.membershipDuplicateService = membershipDuplicateService;
        this.roleService = roleService;
        this.pageService = pageService;
        this.pageDuplicateService = pageDuplicateService;
        this.planService = planService;
        this.groupService = groupService;
        this.userService = userService;
        this.apiService = apiService;
        this.apiConverter = apiConverter;
        this.planConverter = planConverter;
        this.permissionService = permissionService;
        this.apiIdsCalculatorService = apiIdsCalculatorService;
    }

    @Override
    public ApiEntity createWithImportedDefinition(ExecutionContext executionContext, Object apiDefinitionOrURL) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            ImportApiJsonNode apiJsonNode = this.apiIdsCalculatorService.recalculateApiDefinitionIds(executionContext, new ImportApiJsonNode(this.objectMapper.readTree(apiDefinition)));
            this.checkApiJsonConsistency(apiJsonNode);
            UpdateApiEntity importedApi = this.convertToEntity(executionContext, apiJsonNode.toString(), apiJsonNode);
            ApiEntity createdApiEntity = this.apiService.createWithApiDefinition(executionContext, importedApi, this.getAuthenticatedUsername(), apiJsonNode.getJsonNode());
            this.createOrUpdateApiNestedEntities(executionContext, createdApiEntity, apiJsonNode);
            this.createPageAndMedia(executionContext, createdApiEntity, apiJsonNode);
            return createdApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity updateWithImportedDefinition(ExecutionContext executionContext, String urlApiId, Object apiDefinitionOrURL) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            ImportApiJsonNode apiJsonNode = this.apiIdsCalculatorService.recalculateApiDefinitionIds(executionContext, new ImportApiJsonNode(this.objectMapper.readTree(apiDefinition)), urlApiId);
            UpdateApiEntity importedApi = this.convertToEntity(executionContext, apiJsonNode.toString(), apiJsonNode);
            if (DefinitionVersion.V1.equals((Object)DefinitionVersion.valueOfLabel((String)importedApi.getGraviteeDefinitionVersion()))) {
                throw new ApiDefinitionVersionNotSupportedException(importedApi.getGraviteeDefinitionVersion());
            }
            if (!this.isAuthenticated() || !this.isEnvironmentAdmin() && !this.permissionService.hasPermission(executionContext, RolePermission.API_DEFINITION, apiJsonNode.getId(), RolePermissionAction.UPDATE)) {
                throw new ForbiddenAccessException();
            }
            this.checkApiJsonConsistency(executionContext, apiJsonNode, urlApiId);
            ApiEntity updatedApiEntity = this.apiService.update(executionContext, apiJsonNode.getId(), importedApi);
            this.createOrUpdateApiNestedEntities(executionContext, updatedApiEntity, apiJsonNode);
            return updatedApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity duplicate(ExecutionContext executionContext, ApiEntity apiEntity, DuplicateApiEntity duplicateApiEntity) {
        Objects.requireNonNull(apiEntity, "Missing ApiEntity");
        String apiId = apiEntity.getId();
        LOGGER.debug("Duplicate API {}", (Object)apiId);
        UpdateApiEntity newApiEntity = this.apiConverter.toUpdateApiEntity(apiEntity, true);
        Proxy proxy = apiEntity.getProxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(duplicateApiEntity.getContextPath())));
        newApiEntity.setProxy(proxy);
        newApiEntity.setVersion(duplicateApiEntity.getVersion() == null ? apiEntity.getVersion() : duplicateApiEntity.getVersion());
        if (duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_GROUPS)) {
            newApiEntity.setGroups(null);
        } else {
            newApiEntity.setGroups(apiEntity.getGroups());
        }
        HashMap plansIdsMap = new HashMap();
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            newApiEntity.getPlans().forEach(plan -> {
                String newPlanId = UuidString.generateRandom();
                plansIdsMap.put(plan.getId(), newPlanId);
                plan.setId(newPlanId);
            });
        }
        ApiEntity duplicatedApi = this.apiService.createWithApiDefinition(executionContext, newApiEntity, this.getAuthenticatedUsername(), null);
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_MEMBERS)) {
            this.membershipDuplicateService.duplicateMemberships(executionContext, apiId, duplicatedApi.getId(), this.getAuthenticatedUsername());
        }
        HashMap<String, String> pagesIdsMap = new HashMap<String, String>();
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PAGES)) {
            pagesIdsMap.putAll(this.pageDuplicateService.duplicatePages(executionContext, apiId, duplicatedApi.getId(), this.getAuthenticatedUsername()));
        }
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            this.planService.findByApi(executionContext, apiId).forEach(plan -> {
                plan.setId((String)plansIdsMap.get(plan.getId()));
                plan.setApi(duplicatedApi.getId());
                if (plan.getGeneralConditions() != null) {
                    plan.setGeneralConditions((String)pagesIdsMap.get(plan.getGeneralConditions()));
                }
                this.planService.create(executionContext, this.planConverter.toNewPlanEntity((PlanEntity)plan, true));
            });
        }
        return duplicatedApi;
    }

    private UpdateApiEntity convertToEntity(ExecutionContext executionContext, String apiDefinition, ImportApiJsonNode apiJsonNode) throws IOException {
        UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(apiDefinition, UpdateApiEntity.class);
        if (Objects.equals(importedApi.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (importedApi.getPaths() == null || importedApi.getPaths().isEmpty())) {
            importedApi.setPaths(Collections.singletonMap("/", new ArrayList()));
        }
        if (importedApi.getGroups() != null) {
            HashSet groupNames = new HashSet(importedApi.getGroups());
            importedApi.getGroups().clear();
            for (String name : groupNames) {
                GroupEntity group;
                List<GroupEntity> groupEntities = this.groupService.findByName(executionContext.getEnvironmentId(), name);
                if (groupEntities.isEmpty()) {
                    NewGroupEntity newGroupEntity = new NewGroupEntity();
                    newGroupEntity.setName(name);
                    group = this.groupService.create(executionContext, newGroupEntity);
                } else {
                    group = groupEntities.get(0);
                }
                importedApi.getGroups().add(group.getId());
            }
        } else {
            importedApi.setGroups(Collections.emptySet());
        }
        List<ImportJsonNode> viewsNodes = apiJsonNode.getViews();
        if (!viewsNodes.isEmpty()) {
            Set categories = viewsNodes.stream().map(ImportJsonNode::asText).collect(Collectors.toSet());
            importedApi.setCategories(categories);
        }
        Map<String, PlanEntity> existingPlans = this.readApiPlansById(executionContext, apiJsonNode.getId());
        importedApi.setPlans(this.readPlansToImportFromDefinition(apiJsonNode, existingPlans));
        return importedApi;
    }

    private void createPageAndMedia(ExecutionContext executionContext, ApiEntity createdApiEntity, ImportApiJsonNode apiJsonNode) throws JsonProcessingException {
        for (ImportJsonNode media : apiJsonNode.getMedia()) {
            this.mediaService.createWithDefinition(createdApiEntity.getId(), media.toString());
        }
        List<PageEntity> search = this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(createdApiEntity.getId()).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build());
        if (search.isEmpty()) {
            this.pageService.createAsideFolder(executionContext, createdApiEntity.getId());
        }
    }

    private String fetchApiDefinitionContentFromURL(Object apiDefinitionOrURL) {
        String definitionOrURL = ApiDuplicatorServiceImpl.stringifyApiDefinitionFromJackson(apiDefinitionOrURL);
        if (definitionOrURL.toUpperCase().startsWith("HTTP")) {
            UrlSanitizerUtils.checkAllowed(definitionOrURL, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
            Buffer buffer = this.httpClientService.request(HttpMethod.GET, definitionOrURL, null, null, null);
            return buffer.toString();
        }
        return definitionOrURL;
    }

    private void createOrUpdateApiNestedEntities(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws IOException {
        this.createOrUpdateMembers(executionContext, apiEntity, apiJsonNode);
        this.createOrUpdatePages(executionContext, apiEntity, apiJsonNode);
        this.createOrUpdatePlans(executionContext, apiEntity, apiJsonNode);
        this.createOrUpdateMetadata(executionContext, apiEntity, apiJsonNode);
    }

    private void createOrUpdateMembers(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws JsonProcessingException {
        if (apiJsonNode.hasMembers()) {
            Set<MemberToImport> membersAlreadyPresent = this.getAPICurrentMembers(executionContext, apiEntity.getId());
            RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
            assert (poRole != null);
            String poRoleId = poRole.getId();
            MemberToImport currentPo = membersAlreadyPresent.stream().filter(memberToImport -> memberToImport.getRoles().contains(poRoleId)).findFirst().orElse(new MemberToImport());
            List<String> roleUsedInTransfert = null;
            MemberToImport futurePo = null;
            Optional<RoleEntity> apiUserRoleOpt = this.roleService.findByScopeAndName(RoleScope.API, "USER", executionContext.getOrganizationId());
            for (ImportJsonNode memberNode : apiJsonNode.getMembers()) {
                MemberToImport memberToImport2 = (MemberToImport)this.objectMapper.readValue(memberNode.toString(), MemberToImport.class);
                boolean presentWithSameRole = this.isPresentWithSameRole(membersAlreadyPresent, memberToImport2);
                List<String> roleIdsToImport = this.getRoleIdsToImport(executionContext, memberToImport2).stream().filter(roleId -> {
                    boolean isValidRole;
                    Optional<RoleEntity> role = this.roleService.findByIdAndOrganizationId((String)roleId, executionContext.getOrganizationId());
                    boolean bl = isValidRole = role.isPresent() && RoleScope.API.equals((Object)role.get().getScope());
                    if (!isValidRole) {
                        LOGGER.warn("Role {} does not exist in organization {} or is not an API role", roleId, (Object)executionContext.getOrganizationId());
                    }
                    return isValidRole;
                }).collect(Collectors.toList());
                if (roleIdsToImport.isEmpty() && apiUserRoleOpt.isPresent()) {
                    roleIdsToImport.add(apiUserRoleOpt.get().getId());
                }
                this.addOrUpdateMembers(executionContext, apiEntity.getId(), poRoleId, currentPo, memberToImport2, roleIdsToImport, presentWithSameRole);
                if (currentPo.getSourceId().equals(memberToImport2.getSourceId()) && currentPo.getSource().equals(memberToImport2.getSource()) && !roleIdsToImport.contains(poRoleId)) {
                    roleUsedInTransfert = roleIdsToImport;
                }
                if (!roleIdsToImport.contains(poRoleId)) continue;
                futurePo = memberToImport2;
            }
            this.transferOwnership(executionContext, apiEntity.getId(), currentPo, roleUsedInTransfert, futurePo);
        }
    }

    @NotNull
    protected Set<MemberToImport> getAPICurrentMembers(ExecutionContext executionContext, String apiId) {
        return this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.API, apiId).stream().filter(member -> member.getType() == MembershipMemberType.USER).map(member -> {
            UserEntity userEntity = this.userService.findById(executionContext, member.getId());
            return new MemberToImport(userEntity.getSource(), userEntity.getSourceId(), member.getRoles().stream().map(RoleEntity::getId).collect(Collectors.toList()), null);
        }).collect(Collectors.toSet());
    }

    protected boolean isPresentWithSameRole(Set<MemberToImport> membersAlreadyPresent, MemberToImport memberToImport) {
        return memberToImport.getRoles() != null && !memberToImport.getRoles().isEmpty() && membersAlreadyPresent.stream().anyMatch(m -> {
            m.getRoles().sort(Comparator.naturalOrder());
            return m.getRoles().equals(memberToImport.getRoles()) && m.getSourceId().equals(memberToImport.getSourceId()) && m.getSource().equals(memberToImport.getSource());
        });
    }

    protected List<String> getRoleIdsToImport(ExecutionContext executionContext, MemberToImport memberToImport) {
        List<String> roleIdsToImport = memberToImport.getRoles();
        if (roleIdsToImport == null) {
            roleIdsToImport = new ArrayList<String>();
            memberToImport.setRoles(roleIdsToImport);
        } else {
            roleIdsToImport = new ArrayList<String>(roleIdsToImport);
        }
        String roleNameToAdd = memberToImport.getRole();
        if (roleNameToAdd != null && !roleNameToAdd.isEmpty()) {
            Optional<RoleEntity> optRoleToAddEntity = this.roleService.findByScopeAndName(RoleScope.API, roleNameToAdd, executionContext.getOrganizationId());
            if (optRoleToAddEntity.isPresent()) {
                roleIdsToImport.add(optRoleToAddEntity.get().getId());
            } else {
                LOGGER.warn("Role {} does not exist", (Object)roleNameToAdd);
            }
        }
        roleIdsToImport.sort(Comparator.naturalOrder());
        return roleIdsToImport;
    }

    protected void addOrUpdateMembers(ExecutionContext executionContext, String apiId, String poRoleId, MemberToImport currentPo, MemberToImport memberToImport, List<String> rolesToImport, boolean presentWithSameRole) {
        if (!(presentWithSameRole || memberToImport.getRoles() == null || memberToImport.getRoles().isEmpty() || memberToImport.getRoles().contains(poRoleId) || memberToImport.getSourceId().equals(currentPo.getSourceId()) && memberToImport.getSource().equals(currentPo.getSource()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(executionContext, memberToImport.getSource(), memberToImport.getSourceId(), false);
                rolesToImport.forEach(role -> {
                    try {
                        this.membershipService.addRoleToMemberOnReference(executionContext, MembershipReferenceType.API, apiId, MembershipMemberType.USER, userEntity.getId(), (String)role);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to add role '{}' to member '{}' on API '{}' due to : {}", new Object[]{role, userEntity.getId(), apiId, e.getMessage()});
                    }
                });
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    private void transferOwnership(ExecutionContext executionContext, String apiId, MemberToImport currentPo, List<String> roleUsedInTransfert, MemberToImport futurePo) {
        if (!(futurePo == null || currentPo.getSource().equals(futurePo.getSource()) && currentPo.getSourceId().equals(futurePo.getSourceId()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(executionContext, futurePo.getSource(), futurePo.getSourceId(), false);
                List roleEntity = null;
                if (roleUsedInTransfert != null && !roleUsedInTransfert.isEmpty()) {
                    roleEntity = roleUsedInTransfert.stream().map(this.roleService::findById).collect(Collectors.toList());
                }
                this.membershipService.transferApiOwnership(executionContext, apiId, new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), roleEntity);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void createOrUpdateMetadata(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) {
        try {
            for (ImportJsonNode metadataNode : apiJsonNode.getMetadata()) {
                UpdateApiMetadataEntity updateApiMetadataEntity = (UpdateApiMetadataEntity)this.objectMapper.readValue(metadataNode.toString(), UpdateApiMetadataEntity.class);
                updateApiMetadataEntity.setApiId(apiEntity.getId());
                this.apiMetadataService.update(executionContext, updateApiMetadataEntity);
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while creating API metadata", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while creating API Metadata", ex);
        }
    }

    protected void createOrUpdatePlans(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws IOException {
        if (apiJsonNode.hasPlans()) {
            Map<String, PlanEntity> existingPlans = this.readApiPlansById(executionContext, apiEntity.getId());
            Set<PlanEntity> plansToImport = this.readPlansToImportFromDefinition(apiJsonNode, existingPlans);
            this.findRemovedPlans(existingPlans.values(), plansToImport).forEach(plan -> {
                this.planService.delete(executionContext, plan.getId());
                apiEntity.getPlans().remove(plan);
            });
            plansToImport.forEach(planEntity -> {
                planEntity.setApi(apiEntity.getId());
                this.planService.createOrUpdatePlan(executionContext, (PlanEntity)planEntity);
                apiEntity.getPlans().add(planEntity);
            });
        }
    }

    private Map<String, PlanEntity> readApiPlansById(ExecutionContext executionContext, String apiId) {
        return this.planService.findByApi(executionContext, apiId).stream().collect(Collectors.toMap(BasePlanEntity::getId, Function.identity()));
    }

    protected void createOrUpdatePages(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws JsonProcessingException {
        if (apiJsonNode.hasPages() && !apiJsonNode.getPages().isEmpty()) {
            List pagesList = (List)this.objectMapper.readValue(apiJsonNode.getPages().toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PageEntity.class));
            this.pageService.createOrUpdatePages(executionContext, pagesList, apiEntity.getId());
        }
    }

    private Stream<PlanEntity> findRemovedPlans(Collection<PlanEntity> existingPlans, Collection<PlanEntity> importedPlans) {
        return existingPlans.stream().filter(existingPlan -> !importedPlans.contains(existingPlan));
    }

    private Set<PlanEntity> readPlansToImportFromDefinition(ImportApiJsonNode apiJsonNode, Map<String, PlanEntity> existingPlans) throws IOException {
        HashSet<PlanEntity> plansToImport = new HashSet<PlanEntity>();
        for (ImportJsonNodeWithIds importJsonNodeWithIds : apiJsonNode.getPlans()) {
            PlanEntity existingPlan;
            PlanEntity planEntity = existingPlan = importJsonNodeWithIds.hasId() ? existingPlans.get(importJsonNodeWithIds.getId()) : null;
            if (existingPlan != null) {
                plansToImport.add((PlanEntity)this.objectMapper.readerForUpdating((Object)existingPlan).readValue(importJsonNodeWithIds.getJsonNode()));
                continue;
            }
            plansToImport.add((PlanEntity)this.objectMapper.readValue(importJsonNodeWithIds.toString(), PlanEntity.class));
        }
        return plansToImport;
    }

    private void checkApiJsonConsistency(ExecutionContext executionContext, ImportApiJsonNode apiJsonNode, String urlApiId) {
        if (urlApiId != null && !urlApiId.equals(apiJsonNode.getId())) {
            throw new ApiImportException(String.format("Can't update API [%s] cause crossId [%s] already belongs to another API in environment [%s]", urlApiId, apiJsonNode.getCrossId(), executionContext.getEnvironmentId()));
        }
        this.checkApiJsonConsistency(apiJsonNode);
    }

    private void checkApiJsonConsistency(ImportApiJsonNode apiJsonNode) {
        this.checkPagesConsistency(apiJsonNode);
        this.checkPlansConsistency(apiJsonNode);
    }

    private void checkPlansConsistency(ImportApiJsonNode apiJsonNode) {
        List<String> planIds;
        if (apiJsonNode.hasPlans() && this.planService.anyPlanMismatchWithApi(planIds = apiJsonNode.getPlans().stream().map(ImportJsonNodeWithIds::getId).collect(Collectors.toList()), apiJsonNode.getId())) {
            throw new ApiImportException("Some inconsistencies were found in the API plans definition");
        }
    }

    private void checkPagesConsistency(ImportApiJsonNode apiJsonNode) {
        long systemFoldersCount;
        if (apiJsonNode.hasPages() && (systemFoldersCount = apiJsonNode.getPagesArray().findValuesAsText("type").stream().filter(type -> PageType.SYSTEM_FOLDER.name().equals(type)).count()) > 1L) {
            throw new ApiImportException("Only one system folder is allowed in the API pages definition");
        }
    }

    private static String stringifyApiDefinitionFromJackson(Object apiDefinitionOrUrl) {
        return apiDefinitionOrUrl instanceof Map ? new JSONObject((Map)apiDefinitionOrUrl).toString() : apiDefinitionOrUrl.toString();
    }

    protected static class MemberToImport {
        private String source;
        private String sourceId;
        private List<String> roles;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, List<String> roles, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.roles = roles;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }
}

