/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.crud_service.analytics.log;

import io.gravitee.apim.crud_service.analytics.log.ConnectionLogCrudService;
import io.gravitee.apim.infra.adapter.ConnectionLogAdapter;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.log.v4.api.LogRepository;
import io.gravitee.repository.log.v4.model.LogResponse;
import io.gravitee.repository.log.v4.model.connection.ConnectionLog;
import io.gravitee.repository.log.v4.model.connection.ConnectionLogQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.v4.log.SearchLogResponse;
import io.gravitee.rest.api.model.v4.log.connection.BaseConnectionLog;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
class ConnectionLogCrudServiceImpl
implements ConnectionLogCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionLogCrudServiceImpl.class);
    private final LogRepository logRepository;

    public ConnectionLogCrudServiceImpl(@Lazy LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    @Override
    public SearchLogResponse<BaseConnectionLog> searchApiConnectionLog(String apiId, Pageable pageable) {
        try {
            LogResponse response = this.logRepository.searchConnectionLog(ConnectionLogQuery.builder().filter(ConnectionLogQuery.Filter.builder().apiId(apiId).build()).page(pageable.getPageNumber()).size(pageable.getPageSize()).build());
            return this.mapToConnectionResponse((LogResponse<ConnectionLog>)response);
        }
        catch (AnalyticsException e) {
            log.error("An error occurs while trying to search connection of api [apiId={}]", (Object)apiId, (Object)e);
            throw new TechnicalManagementException("Error while searching connection logs of api " + apiId, e);
        }
    }

    private SearchLogResponse<BaseConnectionLog> mapToConnectionResponse(LogResponse<ConnectionLog> logs) {
        long total = logs.total();
        List<BaseConnectionLog> data = ConnectionLogAdapter.INSTANCE.toEntitiesList(logs.data());
        return new SearchLogResponse(total, data);
    }
}

