/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserRoleEntity;
import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextHelper {
    private SecurityContextHelper() {
    }

    public static void authenticateAs(UserEntity user) {
        SecurityContextHelper.authenticateAs(user, false);
    }

    public static void authenticateAsSystem(String userId, Set<UserRoleEntity> userRoles) {
        UserEntity user = new UserEntity();
        user.setId(userId);
        user.setRoles(userRoles);
        SecurityContextHelper.authenticateAs(user, true);
    }

    private static void authenticateAs(final UserEntity user, final boolean isSystem) {
        SecurityContextHolder.setContext((SecurityContext)new SecurityContext(){

            public Authentication getAuthentication() {
                return new Authentication(){

                    public Collection<? extends GrantedAuthority> getAuthorities() {
                        return AuthorityUtils.createAuthorityList((String[])SecurityContextHelper.computeAuthorities(user));
                    }

                    public Object getCredentials() {
                        return null;
                    }

                    public Object getDetails() {
                        return null;
                    }

                    public Object getPrincipal() {
                        return new UserDetails(user.getId(), "", user.getEmail(), this.getAuthorities(), isSystem);
                    }

                    public boolean isAuthenticated() {
                        return true;
                    }

                    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
                    }

                    public String getName() {
                        return ((UserDetails)this.getPrincipal()).getDisplayName();
                    }
                };
            }

            public void setAuthentication(Authentication authentication) {
            }
        });
    }

    private static String[] computeAuthorities(UserEntity user) {
        if (user.getRoles() == null) {
            return new String[0];
        }
        return (String[])user.getRoles().stream().map(role -> role.getScope().name() + ":" + role.getName()).toArray(String[]::new);
    }
}

