/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.MessageRecipient;
import io.gravitee.rest.api.model.ApiPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.command.CommandSearchIndexerEntity;
import io.gravitee.rest.api.model.command.CommandTags;
import io.gravitee.rest.api.model.command.NewCommandEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.CommandService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentSearcher;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import io.gravitee.rest.api.service.impl.search.lucene.SearchEngineIndexer;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.ApiDocumentSearcher;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.search.query.Query;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SearchEngineServiceImpl
implements SearchEngineService {
    private static final String ACTION_INDEX = "I";
    private static final String ACTION_DELETE = "D";
    private final Logger logger = LoggerFactory.getLogger(SearchEngineServiceImpl.class);
    private final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private SearchEngineIndexer indexer;
    @Autowired
    private Collection<DocumentTransformer> transformers;
    @Autowired
    private Collection<DocumentSearcher> searchers;
    @Autowired
    @Lazy
    private CommandService commandService;
    @Autowired
    @Lazy
    private ApiMetadataService apiMetadataService;
    @Autowired
    @Lazy
    private ApiSearchService apiSearchService;
    @Autowired
    @Lazy
    private PageService pageService;
    @Autowired
    @Lazy
    private UserService userService;

    @Override
    @Async(value="indexerThreadPoolTaskExecutor")
    public void index(ExecutionContext executionContext, Indexable source, boolean locally, boolean commit) {
        this.indexLocally(source, commit);
        if (!locally) {
            CommandSearchIndexerEntity content = new CommandSearchIndexerEntity();
            content.setAction(ACTION_INDEX);
            content.setId(source.getId());
            content.setClazz(source.getClass().getName());
            this.sendCommands(executionContext, content);
        }
    }

    @Override
    @Async(value="indexerThreadPoolTaskExecutor")
    public void delete(ExecutionContext executionContext, Indexable source) {
        CommandSearchIndexerEntity content = new CommandSearchIndexerEntity();
        content.setAction(ACTION_DELETE);
        content.setId(source.getId());
        content.setClazz(source.getClass().getName());
        this.sendCommands(executionContext, content);
    }

    @Override
    public void commit() {
        try {
            this.indexer.commit();
        }
        catch (TechnicalException te) {
            this.logger.error("Unexpected error while Lucene commit", (Throwable)te);
        }
    }

    @Override
    public void process(ExecutionContext executionContext, CommandSearchIndexerEntity content) {
        Indexable source;
        if (ACTION_DELETE.equals(content.getAction())) {
            try {
                Indexable source2 = this.createInstance(content.getClazz());
                source2.setId(content.getId());
                this.deleteLocally(source2);
            }
            catch (Exception ex) {
                throw new TechnicalManagementException("Unable to delete document for content [ " + content.getId() + " - " + content.getClazz() + " ]", ex);
            }
        } else if (ACTION_INDEX.equals(content.getAction()) && (source = this.getSource(executionContext, content.getClazz(), content.getId())) != null) {
            this.indexLocally(source, true);
        }
    }

    private void sendCommands(ExecutionContext executionContext, CommandSearchIndexerEntity content) {
        try {
            NewCommandEntity msg = new NewCommandEntity();
            msg.setTags(Collections.singletonList(CommandTags.DATA_TO_INDEX));
            msg.setTo(MessageRecipient.MANAGEMENT_APIS.name());
            msg.setTtlInSeconds(60L);
            msg.setContent(this.mapper.writeValueAsString((Object)content));
            this.commandService.send(executionContext, msg);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Unexpected error while sending a message", (Throwable)e);
        }
    }

    private Indexable getSource(ExecutionContext executionContext, String clazz, String id) {
        try {
            if (ApiEntity.class.getName().equals(clazz) || io.gravitee.rest.api.model.v4.api.ApiEntity.class.getName().equals(clazz)) {
                GenericApiEntity genericApi = this.apiSearchService.findGenericById(executionContext, id);
                return this.apiMetadataService.fetchMetadataForApi(executionContext, genericApi);
            }
            if (PageEntity.class.getName().equals(clazz) || ApiPageEntity.class.getName().equals(clazz)) {
                return this.pageService.findById(id);
            }
            if (UserEntity.class.getName().equals(clazz)) {
                return this.userService.findById(executionContext, id);
            }
        }
        catch (AbstractNotFoundException abstractNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void indexLocally(Indexable source, boolean commit) {
        this.transformers.stream().filter(transformer -> transformer.handle(source.getClass())).findFirst().ifPresent(transformer -> {
            try {
                this.indexer.index(transformer.transform(source), commit);
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while indexing a document", (Throwable)te);
            }
        });
    }

    private void deleteLocally(Indexable source) {
        this.transformers.stream().filter(transformer -> transformer.handle(source.getClass())).findFirst().ifPresent(transformer -> {
            try {
                this.indexer.remove(transformer.transform(source));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while deleting a document", (Throwable)te);
            }
        });
    }

    private Indexable createInstance(String className) throws Exception {
        try {
            Class<?> clazz = Class.forName(className);
            Assert.isAssignable(Indexable.class, clazz);
            return (Indexable)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            this.logger.error("Unable to instantiate class: {}", (Object)className, (Object)ex);
            throw ex;
        }
    }

    @Override
    public SearchResult search(ExecutionContext executionContext, Query<? extends Indexable> query) {
        Optional results = this.searchers.stream().filter(searcher -> searcher.handle(query.getRoot())).findFirst().flatMap(searcher -> {
            try {
                SearchResult apiReferences;
                Optional<DocumentSearcher> pageDocumentSearcher;
                if (searcher instanceof ApiDocumentSearcher && (pageDocumentSearcher = this.searchers.stream().filter(s -> s.handle(PageEntity.class)).findFirst()).isPresent() && !(apiReferences = pageDocumentSearcher.get().searchReference(executionContext, query)).getDocuments().isEmpty()) {
                    query.setIds(apiReferences.getDocuments());
                }
                return Optional.of(searcher.search(executionContext, query));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while searching a document", (Throwable)te);
                return Optional.empty();
            }
        });
        return results.orElse(null);
    }
}

