/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.usecase.log;

import io.gravitee.apim.crud_service.analytics.log.MessageLogCrudService;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.v4.log.SearchLogResponse;
import io.gravitee.rest.api.model.v4.log.message.BaseMessageLog;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SearchMessageLogUsecase {
    private final MessageLogCrudService messageLogCrudService;

    public SearchMessageLogUsecase(MessageLogCrudService messageLogCrudService) {
        this.messageLogCrudService = messageLogCrudService;
    }

    public Output execute(Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 20));
        SearchLogResponse<BaseMessageLog> response = this.messageLogCrudService.searchApiMessageLog(input.apiId(), input.requestId(), pageable);
        return this.mapToResponse(response);
    }

    private Output mapToResponse(SearchLogResponse<BaseMessageLog> logs) {
        long total = logs.total();
        List data = logs.logs();
        return new Output(total, data);
    }

    public record Input(String apiId, String requestId, Optional<Pageable> pageable) {
        public Input(String apiId, String requestId) {
            this(apiId, requestId, Optional.empty());
        }

        public Input(String apiId, String requestId, Pageable pageable) {
            this(apiId, requestId, Optional.of(pageable));
        }
    }

    public record Output(long total, List<BaseMessageLog> data) {
    }
}

