/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.CockpitApiPermissionChecker;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CockpitApiPermissionCheckerImpl
implements CockpitApiPermissionChecker {
    private final PermissionService permissionService;

    public CockpitApiPermissionCheckerImpl(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public Optional<String> checkCreatePermission(ExecutionContext executionContext, String userId, String environmentId, DeploymentMode mode) {
        if (this.isNotAllowedToCreateApi(executionContext, userId, environmentId)) {
            return Optional.of("You are not allowed to create APIs on this environment.");
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> checkUpdatePermission(ExecutionContext executionContext, String userId, String environmentId, String apiId, DeploymentMode mode) {
        if (this.isNotAllowedToUpdateApi(executionContext, userId, environmentId)) {
            return Optional.of("You are not allowed to update APIs on this environment.");
        }
        if (this.isNotAllowedToUpdateDocumentation(executionContext, userId, apiId)) {
            return Optional.of("You are not allowed to update the documentation of this API.");
        }
        if (mode != DeploymentMode.API_DOCUMENTED && this.isNotAllowedToUpdateApiDefinition(executionContext, userId, apiId)) {
            return Optional.of("You are not allowed to mock and deploy this API.");
        }
        return Optional.empty();
    }

    private boolean isNotAllowedToCreateApi(ExecutionContext executionContext, String userId, String environmentId) {
        return !this.isAdmin(executionContext, userId) && !this.permissionService.hasPermission(executionContext, userId, RolePermission.ENVIRONMENT_API, environmentId, RolePermissionAction.CREATE);
    }

    private boolean isNotAllowedToUpdateApi(ExecutionContext executionContext, String userId, String environmentId) {
        return !this.isAdmin(executionContext, userId) && !this.permissionService.hasPermission(executionContext, userId, RolePermission.ENVIRONMENT_API, environmentId, RolePermissionAction.UPDATE);
    }

    private boolean isNotAllowedToUpdateDocumentation(ExecutionContext executionContext, String userId, String apiId) {
        return !this.isAdmin(executionContext, userId) && !this.permissionService.hasPermission(executionContext, userId, RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.UPDATE);
    }

    private boolean isNotAllowedToUpdateApiDefinition(ExecutionContext executionContext, String userId, String apiId) {
        return !this.isAdmin(executionContext, userId) && !this.permissionService.hasPermission(executionContext, userId, RolePermission.API_DEFINITION, apiId, RolePermissionAction.UPDATE);
    }

    protected boolean isAdmin(ExecutionContext executionContext, String userId) {
        return this.permissionService.hasManagementRights(executionContext, userId);
    }
}

