/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.crud_service.plan;

import io.gravitee.apim.crud_service.plan.PlanCrudService;
import io.gravitee.apim.crud_service.plan.adapter.BasePlanAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlanCrudServiceImpl
implements PlanCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanCrudServiceImpl.class);
    private final PlanRepository planRepository;
    private final ApiRepository apiRepository;
    private final BasePlanAdapter planAdapter;

    public PlanCrudServiceImpl(@Lazy PlanRepository planRepository, @Lazy ApiRepository apiRepository, BasePlanAdapter planAdapter) {
        this.planRepository = planRepository;
        this.apiRepository = apiRepository;
        this.planAdapter = planAdapter;
    }

    @Override
    public GenericPlanEntity findById(String planId) {
        try {
            log.debug("Find plan by id : {}", (Object)planId);
            return this.planRepository.findById((Object)planId).map(this::mapToGeneric).orElseThrow(() -> new PlanNotFoundException(planId));
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by id: %s", planId), ex);
        }
    }

    private GenericPlanEntity mapToGeneric(Plan plan) {
        try {
            Optional apiOptional = this.apiRepository.findById((Object)plan.getApi());
            Api api = (Api)apiOptional.orElseThrow(() -> new ApiNotFoundException(plan.getApi()));
            return api.getDefinitionVersion() == DefinitionVersion.V4 ? this.planAdapter.toEntityV4(plan) : this.planAdapter.toEntityV2(plan);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + plan.getApi(), e);
        }
    }
}

