/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.mapper;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.mapper.PlanMapper;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class GenericPlanMapper {
    private final PlanMapper planMapper;
    private final FlowService flowService;
    private final PlanConverter planConverter;
    private final io.gravitee.rest.api.service.configuration.flow.FlowService flowServiceV2;

    public GenericPlanMapper(PlanMapper planMapper, @Lazy FlowService flowService, PlanConverter planConverter, @Lazy io.gravitee.rest.api.service.configuration.flow.FlowService flowServiceV2) {
        this.planMapper = planMapper;
        this.flowService = flowService;
        this.planConverter = planConverter;
        this.flowServiceV2 = flowServiceV2;
    }

    public GenericPlanEntity toGenericPlan(Api api, Plan plan) {
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            List<io.gravitee.definition.model.v4.flow.Flow> flows = this.flowService.findByReference(FlowReferenceType.PLAN, plan.getId());
            return this.planMapper.toEntity(plan, flows);
        }
        List<Flow> flows = this.flowServiceV2.findByReference(FlowReferenceType.PLAN, plan.getId());
        return this.planConverter.toPlanEntity(plan, flows);
    }
}

