/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.v4.analytics.logging.Logging;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.Visibility;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.plan.BasePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.ApiNotDeletableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiRunningStateException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.TagNotAllowedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.HookScope;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.v4.ApiAuthorizationService;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.ApiService;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.service.v4.PlanService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.PropertiesService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.service.v4.mapper.GenericApiMapper;
import io.gravitee.rest.api.service.v4.validation.ApiValidationService;
import io.gravitee.rest.api.service.v4.validation.TagsValidationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="ApiServiceImplV4")
public class ApiServiceImpl
extends AbstractService
implements ApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ApiMapper apiMapper;
    private final GenericApiMapper genericApiMapper;
    private final PrimaryOwnerService primaryOwnerService;
    private final ApiValidationService apiValidationService;
    private final ParameterService parameterService;
    private final WorkflowService workflowService;
    private final AuditService auditService;
    private final MembershipService membershipService;
    private final GenericNotificationConfigService genericNotificationConfigService;
    private final ApiMetadataService apiMetadataService;
    private final FlowService flowService;
    private final SearchEngineService searchEngineService;
    private final PlanService planService;
    private final PlanSearchService planSearchService;
    private final SubscriptionService subscriptionService;
    private final EventService eventService;
    private final PageService pageService;
    private final TopApiService topApiService;
    private final PortalNotificationConfigService portalNotificationConfigService;
    private final AlertService alertService;
    private final ApiQualityRuleRepository apiQualityRuleRepository;
    private final MediaService mediaService;
    private final PropertiesService propertiesService;
    private final ApiNotificationService apiNotificationService;
    private final TagsValidationService tagsValidationService;
    private final ApiAuthorizationService apiAuthorizationService;
    private final GroupService groupService;
    private static final String EMAIL_METADATA_VALUE = "${(api.primaryOwner.email)!''}";

    public ApiServiceImpl(@Lazy ApiRepository apiRepository, ApiMapper apiMapper, GenericApiMapper genericApiMapper, PrimaryOwnerService primaryOwnerService, ApiValidationService apiValidationService, ParameterService parameterService, WorkflowService workflowService, AuditService auditService, MembershipService membershipService, GenericNotificationConfigService genericNotificationConfigService, @Lazy ApiMetadataService apiMetadataService, FlowService flowService, @Lazy SearchEngineService searchEngineService, PlanService planService, PlanSearchService planSearchService, @Lazy SubscriptionService subscriptionService, EventService eventService, @Lazy PageService pageService, @Lazy TopApiService topApiService, PortalNotificationConfigService portalNotificationConfigService, @Lazy AlertService alertService, @Lazy ApiQualityRuleRepository apiQualityRuleRepository, MediaService mediaService, PropertiesService propertiesService, ApiNotificationService apiNotificationService, TagsValidationService tagsValidationService, ApiAuthorizationService apiAuthorizationService, GroupService groupService) {
        this.apiRepository = apiRepository;
        this.apiMapper = apiMapper;
        this.genericApiMapper = genericApiMapper;
        this.primaryOwnerService = primaryOwnerService;
        this.apiValidationService = apiValidationService;
        this.parameterService = parameterService;
        this.workflowService = workflowService;
        this.auditService = auditService;
        this.membershipService = membershipService;
        this.genericNotificationConfigService = genericNotificationConfigService;
        this.apiMetadataService = apiMetadataService;
        this.flowService = flowService;
        this.searchEngineService = searchEngineService;
        this.planService = planService;
        this.planSearchService = planSearchService;
        this.subscriptionService = subscriptionService;
        this.eventService = eventService;
        this.pageService = pageService;
        this.topApiService = topApiService;
        this.portalNotificationConfigService = portalNotificationConfigService;
        this.alertService = alertService;
        this.apiQualityRuleRepository = apiQualityRuleRepository;
        this.mediaService = mediaService;
        this.propertiesService = propertiesService;
        this.apiNotificationService = apiNotificationService;
        this.tagsValidationService = tagsValidationService;
        this.apiAuthorizationService = apiAuthorizationService;
        this.groupService = groupService;
    }

    @Override
    public ApiEntity create(ExecutionContext executionContext, NewApiEntity newApiEntity, String userId) {
        try {
            PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, userId, null);
            this.apiValidationService.validateAndSanitizeNewApi(executionContext, newApiEntity, primaryOwner);
            Api repositoryApi = this.apiMapper.toRepository(executionContext, newApiEntity);
            repositoryApi.setApiLifecycleState(io.gravitee.repository.management.model.ApiLifecycleState.CREATED);
            if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                this.workflowService.create(WorkflowReferenceType.API, repositoryApi.getId(), WorkflowType.REVIEW, userId, WorkflowState.DRAFT, "");
            }
            Api createdApi = (Api)this.apiRepository.create((Object)repositoryApi);
            this.auditService.createApiAuditLog(executionContext, createdApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_CREATED, createdApi.getCreatedAt(), null, createdApi);
            this.addPrimaryOwnerToCreatedApi(executionContext, primaryOwner, createdApi);
            this.createDefaultMailNotification(createdApi);
            this.createDefaultSupportEmailMetadata(executionContext, createdApi);
            this.flowService.save(FlowReferenceType.API, createdApi.getId(), newApiEntity.getFlows());
            ApiEntity apiEntity = this.apiMapper.toEntity(executionContext, createdApi, primaryOwner, null, true);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (TechnicalException | IllegalStateException ex) {
            String errorMsg = String.format("An error occurs while trying to create '%s' for user '%s'", newApiEntity, userId);
            log.error(errorMsg, ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
    }

    @Override
    public ApiEntity createWithImport(ExecutionContext executionContext, ApiEntity apiEntity, String userId) {
        Api createdApi;
        String id = apiEntity.getId() != null && !apiEntity.getId().isEmpty() ? apiEntity.getId() : UuidString.generateRandom();
        apiEntity.setId(id);
        log.debug("Importing API {}", (Object)id);
        try {
            this.apiRepository.findById((Object)id).ifPresent(action -> {
                throw new ApiAlreadyExistsException(id);
            });
        }
        catch (TechnicalException ex) {
            String errorMsg = String.format("An error occurs while trying to check if 'id' %s is already used", id);
            log.error(errorMsg, (Throwable)ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, userId, apiEntity.getPrimaryOwner());
        this.apiValidationService.validateAndSanitizeImportApiForCreation(executionContext, apiEntity, primaryOwner);
        Api repositoryApi = this.apiMapper.toRepository(executionContext, apiEntity);
        repositoryApi.setEnvironmentId(executionContext.getEnvironmentId());
        repositoryApi.setCreatedAt(new Date());
        repositoryApi.setUpdatedAt(repositoryApi.getCreatedAt());
        repositoryApi.setApiLifecycleState(io.gravitee.repository.management.model.ApiLifecycleState.CREATED);
        if (DefinitionContext.isKubernetes((String)repositoryApi.getOrigin())) {
            repositoryApi.setLifecycleState(LifecycleState.STARTED);
        } else {
            repositoryApi.setLifecycleState(LifecycleState.STOPPED);
        }
        repositoryApi.setVisibility(apiEntity.getVisibility() == null ? Visibility.PRIVATE : Visibility.valueOf((String)apiEntity.getVisibility().toString()));
        Set defaultGroups = this.groupService.findByEvent(executionContext.getEnvironmentId(), GroupEvent.API_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
        if (repositoryApi.getGroups() == null) {
            repositoryApi.setGroups(defaultGroups.isEmpty() ? null : defaultGroups);
        } else {
            repositoryApi.getGroups().addAll(defaultGroups);
        }
        if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwner.getType())) {
            if (repositoryApi.getGroups() == null) {
                repositoryApi.setGroups(new HashSet());
            }
            repositoryApi.getGroups().add(primaryOwner.getId());
        }
        if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
            this.workflowService.create(WorkflowReferenceType.API, id, WorkflowType.REVIEW, userId, WorkflowState.DRAFT, "");
        }
        try {
            createdApi = (Api)this.apiRepository.create((Object)repositoryApi);
            log.debug("API {} imported", (Object)createdApi.getId());
        }
        catch (TechnicalException ex) {
            String errorMsg = String.format("An error occurs while trying to create '%s' for user '%s'", apiEntity, userId);
            log.error(errorMsg, (Throwable)ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
        this.auditService.createApiAuditLog(executionContext, createdApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_CREATED, createdApi.getCreatedAt(), null, createdApi);
        this.addPrimaryOwnerToCreatedApi(executionContext, primaryOwner, createdApi);
        this.createDefaultMailNotification(createdApi);
        this.createDefaultSupportEmailMetadata(executionContext, createdApi);
        this.flowService.save(FlowReferenceType.API, createdApi.getId(), apiEntity.getFlows());
        ApiEntity createdApiEntity = this.apiMapper.toEntity(executionContext, createdApi, primaryOwner, null, true);
        GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)createdApiEntity);
        this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
        return createdApiEntity;
    }

    private void createDefaultSupportEmailMetadata(ExecutionContext executionContext, Api createdApi) {
        NewApiMetadataEntity newApiMetadataEntity = new NewApiMetadataEntity();
        newApiMetadataEntity.setFormat(MetadataFormat.MAIL);
        newApiMetadataEntity.setName("email-support");
        newApiMetadataEntity.setDefaultValue(EMAIL_METADATA_VALUE);
        newApiMetadataEntity.setValue(EMAIL_METADATA_VALUE);
        newApiMetadataEntity.setApiId(createdApi.getId());
        this.apiMetadataService.create(executionContext, newApiMetadataEntity);
    }

    private void createDefaultMailNotification(Api createdApi) {
        GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
        notificationConfigEntity.setName("Default Mail Notifications");
        notificationConfigEntity.setReferenceType(HookScope.API.name());
        notificationConfigEntity.setReferenceId(createdApi.getId());
        notificationConfigEntity.setHooks(Arrays.stream(ApiHook.values()).map(Enum::name).collect(Collectors.toList()));
        notificationConfigEntity.setNotifier("default-email");
        notificationConfigEntity.setConfig(EMAIL_METADATA_VALUE);
        this.genericNotificationConfigService.create(notificationConfigEntity);
    }

    private void addPrimaryOwnerToCreatedApi(ExecutionContext executionContext, PrimaryOwnerEntity primaryOwner, Api createdApi) {
        this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.API, createdApi.getId()), new MembershipService.MembershipMember(primaryOwner.getId(), null, MembershipMemberType.valueOf((String)primaryOwner.getType())), new MembershipService.MembershipRole(RoleScope.API, SystemRole.PRIMARY_OWNER.name()));
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity api, String userId) {
        return this.update(executionContext, apiId, api, false, userId);
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, boolean checkPlans, String userId) {
        try {
            PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, userId, null);
            Api apiToUpdate = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            ApiEntity existingApiEntity = this.apiMapper.toEntity(executionContext, apiToUpdate, primaryOwner, null, false);
            this.apiValidationService.validateAndSanitizeUpdateApi(executionContext, updateApiEntity, primaryOwner, existingApiEntity);
            if (updateApiEntity.getPlans() == null) {
                updateApiEntity.setPlans(new HashSet());
            } else if (checkPlans) {
                Set existingPlans = existingApiEntity.getPlans();
                HashMap<String, PlanStatus> planStatuses = new HashMap<String, PlanStatus>();
                if (existingPlans != null && !existingPlans.isEmpty()) {
                    planStatuses.putAll(existingPlans.stream().collect(Collectors.toMap(BasePlanEntity::getId, BasePlanEntity::getStatus)));
                }
                updateApiEntity.getPlans().forEach(planToUpdate -> {
                    if (!planStatuses.containsKey(planToUpdate.getId()) || planStatuses.containsKey(planToUpdate.getId()) && planStatuses.get(planToUpdate.getId()) == PlanStatus.CLOSED && planStatuses.get(planToUpdate.getId()) != planToUpdate.getStatus()) {
                        throw new InvalidDataException("Invalid status for plan '" + planToUpdate.getName() + "'");
                    }
                    try {
                        this.tagsValidationService.validatePlanTagsAgainstApiTags((Set<String>)planToUpdate.getTags(), updateApiEntity.getTags());
                    }
                    catch (TagNotAllowedException e) {
                        List missingTags = planToUpdate.getTags().stream().filter(tag -> !updateApiEntity.getTags().contains(tag)).collect(Collectors.toList());
                        throw new InvalidDataException("Sharding tags " + missingTags + " used by plan '" + planToUpdate.getName() + "'");
                    }
                });
            }
            updateApiEntity.setProperties(this.propertiesService.encryptProperties(updateApiEntity.getProperties()));
            if (ApiLifecycleState.DEPRECATED == updateApiEntity.getLifecycleState()) {
                this.planSearchService.findByApi(executionContext, apiId).forEach(plan -> {
                    if (PlanStatus.PUBLISHED == plan.getPlanStatus() || PlanStatus.STAGING == plan.getPlanStatus()) {
                        this.planService.deprecate(executionContext, plan.getId(), true);
                        updateApiEntity.getPlans().stream().filter(p -> p.getId().equals(plan.getId())).forEach(p -> p.setStatus(PlanStatus.DEPRECATED));
                    }
                });
            }
            Api api = this.apiMapper.toRepository(executionContext, updateApiEntity);
            api.setEnvironmentId(apiToUpdate.getEnvironmentId());
            api.setDeployedAt(apiToUpdate.getDeployedAt());
            api.setCreatedAt(apiToUpdate.getCreatedAt());
            api.setLifecycleState(apiToUpdate.getLifecycleState());
            if (updateApiEntity.getCrossId() == null) {
                api.setCrossId(apiToUpdate.getCrossId());
            }
            api.setPicture(apiToUpdate.getPicture());
            api.setBackground(apiToUpdate.getBackground());
            if (updateApiEntity.getGroups() == null) {
                api.setGroups(apiToUpdate.getGroups());
            }
            if (updateApiEntity.getLabels() == null && apiToUpdate.getLabels() != null) {
                api.setLabels(new ArrayList(new HashSet(apiToUpdate.getLabels())));
            }
            if (updateApiEntity.getCategories() == null) {
                api.setCategories(apiToUpdate.getCategories());
            }
            if (io.gravitee.repository.management.model.ApiLifecycleState.DEPRECATED.equals((Object)api.getApiLifecycleState())) {
                GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)existingApiEntity);
                this.apiNotificationService.triggerDeprecatedNotification(executionContext, apiWithMetadata);
            }
            Api updatedApi = (Api)this.apiRepository.update((Object)api);
            this.flowService.save(FlowReferenceType.API, api.getId(), updateApiEntity.getFlows());
            updateApiEntity.getPlans().forEach(plan -> {
                plan.setApiId(api.getId());
                this.planService.createOrUpdatePlan(executionContext, (PlanEntity)plan);
            });
            this.auditService.createApiAuditLog(executionContext, updatedApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, updatedApi.getUpdatedAt(), apiToUpdate, updatedApi);
            if (this.parameterService.findAsBoolean(executionContext, Key.LOGGING_AUDIT_TRAIL_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                Logging existingApiLogging = null;
                if (existingApiEntity.getAnalytics() != null) {
                    existingApiLogging = existingApiEntity.getAnalytics().getLogging();
                }
                Logging updateApiLogging = null;
                if (updateApiEntity.getAnalytics() != null) {
                    updateApiLogging = updateApiEntity.getAnalytics().getLogging();
                }
                this.auditApiLogging(executionContext, updateApiEntity.getId(), existingApiLogging, updateApiLogging);
            }
            ApiEntity apiEntity = this.apiMapper.toEntity(executionContext, updatedApi, primaryOwner, null, true);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.apiNotificationService.triggerUpdateNotification(executionContext, apiWithMetadata);
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (TechnicalException ex) {
            String errorMsg = String.format("An error occurs while trying to update API '%s'", apiId);
            log.error(errorMsg, (Object)apiId, (Object)ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String apiId, boolean closePlans) {
        try {
            Set<String> plansNotClosed;
            log.debug("Delete API {}", (Object)apiId);
            Api api = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            if (DefinitionContext.isManagement((String)api.getOrigin()) && api.getLifecycleState() == LifecycleState.STARTED) {
                throw new ApiRunningStateException(apiId);
            }
            Set<Object> plans = this.planSearchService.findByApi(executionContext, apiId);
            if (closePlans) {
                plans = plans.stream().filter(plan -> plan.getPlanStatus() != PlanStatus.CLOSED).map(plan -> this.planService.close(executionContext, plan.getId())).collect(Collectors.toSet());
            }
            if (!(plansNotClosed = plans.stream().filter(plan -> plan.getPlanStatus() == PlanStatus.PUBLISHED).map(GenericPlanEntity::getName).collect(Collectors.toSet())).isEmpty()) {
                throw new ApiNotDeletableException(plansNotClosed);
            }
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApi(executionContext, apiId);
            subscriptions.forEach(sub -> this.subscriptionService.delete(executionContext, sub.getId()));
            plans.forEach(plan -> this.planService.delete(executionContext, plan.getId()));
            this.flowService.save(FlowReferenceType.API, apiId, null);
            this.eventService.deleteApiEvents(apiId);
            HashMap<String, String> properties = new HashMap<String, String>(2);
            if (this.getAuthenticatedUser() != null) {
                properties.put(Event.EventProperties.USER.getValue(), this.getAuthenticatedUser().getUsername());
            }
            this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), EventType.UNPUBLISH_API, apiId, properties);
            this.pageService.deleteAllByApi(executionContext, apiId);
            this.topApiService.delete(executionContext, apiId);
            this.apiRepository.delete((Object)apiId);
            this.membershipService.deleteReference(executionContext, MembershipReferenceType.API, apiId);
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            this.portalNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            List<AlertTriggerEntity> alerts = this.alertService.findByReferenceWithEventCounts(AlertReferenceType.API, apiId);
            alerts.forEach(alert -> this.alertService.delete(alert.getId(), alert.getReferenceId()));
            this.apiQualityRuleRepository.deleteByApi(apiId);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_DELETED, new Date(), api, null);
            this.searchEngineService.delete(executionContext, (Indexable)this.apiMapper.toEntity(executionContext, api, null, null, false));
            this.mediaService.deleteAllByApi(apiId);
            this.apiMetadataService.deleteAllByApi(executionContext, apiId);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to delete API " + apiId, ex);
        }
    }

    @Override
    public Page<GenericApiEntity> findAll(ExecutionContext executionContext, String userId, boolean isAdmin, Pageable pageable) {
        ApiCriteria.Builder criteria = new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId());
        if (!isAdmin) {
            Set<String> userApiIds = this.apiAuthorizationService.findApiIdsByUserId(executionContext, userId, null);
            if (userApiIds.isEmpty()) {
                return new Page(List.of(), 0, 0, 0L);
            }
            criteria.ids(userApiIds);
        }
        Page apis = this.apiRepository.search(criteria.build(), null, ApiServiceImpl.convert(pageable), new ApiFieldFilter.Builder().excludePicture().build());
        return apis.getContent().stream().map(api -> this.genericApiMapper.toGenericApi((Api)api, null)).collect(Collectors.collectingAndThen(Collectors.toList(), apiEntityList -> new Page(apiEntityList, apis.getPageNumber(), (int)apis.getPageElements(), apis.getTotalElements())));
    }

    @Override
    public Optional<ApiEntity> findByEnvironmentIdAndCrossId(String environment, String crossId) {
        try {
            return this.apiRepository.findByEnvironmentIdAndCrossId(environment, crossId).map(api -> this.apiMapper.toEntity((Api)api, null));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred while finding API by environment " + environment + " and crossId " + crossId, e);
        }
    }

    private void auditApiLogging(ExecutionContext executionContext, String apiId, Logging existingLogging, Logging updatedLogging) {
        try {
            if (existingLogging == updatedLogging || existingLogging != null && updatedLogging != null && Objects.equals(existingLogging.getMode(), updatedLogging.getMode()) && Objects.equals(existingLogging.getContent(), updatedLogging.getContent()) && Objects.equals(existingLogging.getPhase(), updatedLogging.getPhase()) && Objects.equals(existingLogging.getCondition(), updatedLogging.getCondition())) {
                return;
            }
            Api.AuditEvent auditEvent = (existingLogging == null || !existingLogging.getMode().isEnabled()) && updatedLogging != null && updatedLogging.getMode().isEnabled() ? Api.AuditEvent.API_LOGGING_ENABLED : (existingLogging != null && existingLogging.getMode().isEnabled() && (updatedLogging == null || !updatedLogging.getMode().isEnabled()) ? Api.AuditEvent.API_LOGGING_DISABLED : Api.AuditEvent.API_LOGGING_UPDATED);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)auditEvent, new Date(), existingLogging, updatedLogging);
        }
        catch (Exception ex) {
            String errorMsg = String.format("An error occurs while auditing API logging configuration for API:  %s", apiId);
            log.error(errorMsg, (Object)apiId, (Object)ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
    }
}

