/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.media.api.MediaRepository;
import io.gravitee.repository.media.model.Media;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.PageMediaEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiMediaNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import jakarta.xml.bind.DatatypeConverter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MediaServiceImpl
implements MediaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaServiceImpl.class);
    private static final String MEDIA_TYPE_IMAGE = "image";
    private final MediaRepository mediaRepository;
    private final ConfigService configService;
    private final ObjectMapper objectMapper;

    public MediaServiceImpl(@Lazy MediaRepository mediaRepository, ConfigService configService, ObjectMapper objectMapper) {
        this.mediaRepository = mediaRepository;
        this.configService = configService;
        this.objectMapper = objectMapper;
    }

    @Override
    public String savePortalMedia(MediaEntity mediaEntity) {
        return this.saveApiMedia(null, mediaEntity);
    }

    @Override
    public String saveApiMedia(String api, MediaEntity mediaEntity) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = digest.digest(mediaEntity.getData());
            String hashString = DatatypeConverter.printHexBinary((byte[])hash);
            String id = mediaEntity.getId() != null ? mediaEntity.getId() : UuidString.generateRandom();
            Optional checkMedia = api != null ? this.mediaRepository.findByHashAndApiAndType(hashString, api, mediaEntity.getType()) : this.mediaRepository.findByHashAndType(hashString, mediaEntity.getType());
            if (checkMedia.isPresent()) {
                return ((Media)checkMedia.get()).getHash();
            }
            Media media = MediaServiceImpl.convert(mediaEntity);
            media.setId(id);
            media.setHash(hashString);
            media.setSize(Long.valueOf(mediaEntity.getData().length));
            media.setApi(api);
            media.setData(mediaEntity.getData());
            this.mediaRepository.create(media);
            return hashString;
        }
        catch (TechnicalException | NoSuchAlgorithmException ex) {
            LOGGER.error("An error has occurred while trying to create media " + mediaEntity, ex);
            throw new TechnicalManagementException("An error occurs while trying create media");
        }
    }

    @Override
    public MediaEntity findByHash(String hash) {
        try {
            return this.mediaRepository.findByHashAndType(hash, MEDIA_TYPE_IMAGE).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error has occurred trying to find media with hash " + hash, (Throwable)e);
            throw new TechnicalManagementException("An error has occurred trying to find media");
        }
    }

    @Override
    public MediaEntity findByHashAndApiId(String hash, String apiId) {
        try {
            return this.mediaRepository.findByHashAndApiAndType(hash, apiId, MEDIA_TYPE_IMAGE).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error as occurred trying to find media for API " + apiId + " with hash " + hash, (Throwable)e);
            throw new TechnicalManagementException("An error as occurred trying to find media");
        }
    }

    @Override
    public MediaEntity findByHash(String hash, boolean ignoreType) {
        try {
            if (ignoreType) {
                return this.mediaRepository.findByHash(hash).map(MediaServiceImpl::convert).orElse(null);
            }
            return this.mediaRepository.findByHashAndType(hash, MEDIA_TYPE_IMAGE).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error as occurred trying to find media with hash " + hash, (Throwable)e);
            throw new TechnicalManagementException("An error has occurred trying to find media");
        }
    }

    @Override
    public MediaEntity findByHashAndApi(String hash, String api, boolean ignoreType) {
        try {
            if (ignoreType) {
                return this.mediaRepository.findByHashAndApi(hash, api).map(MediaServiceImpl::convert).orElse(null);
            }
            return this.mediaRepository.findByHashAndApiAndType(hash, api, MEDIA_TYPE_IMAGE).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error as occurred trying to find media for API " + api + " with hash " + hash, (Throwable)e);
            throw new TechnicalManagementException("An error as occurred trying to find media");
        }
    }

    @Override
    public List<MediaEntity> findAllWithoutContent(List<PageMediaEntity> pageMediaEntities) {
        return this.findAllWithoutContent(pageMediaEntities, null);
    }

    @Override
    public List<MediaEntity> findAllWithoutContent(List<PageMediaEntity> pageMediaEntities, String api) {
        try {
            ArrayList<MediaEntity> result = new ArrayList<MediaEntity>();
            if (pageMediaEntities != null && !pageMediaEntities.isEmpty()) {
                for (PageMediaEntity pme : pageMediaEntities) {
                    Optional foundMedia = this.mediaRepository.findByHashAndApi(pme.getMediaHash(), api, false);
                    if (!foundMedia.isPresent()) continue;
                    MediaEntity me = MediaServiceImpl.convert((Media)foundMedia.get());
                    me.setFileName(pme.getMediaName());
                    me.setUploadDate(pme.getAttachedAt());
                    result.add(me);
                }
            }
            return result;
        }
        catch (TechnicalException e) {
            LOGGER.error("An error as occurred trying to find medias for API " + api, (Throwable)e);
            throw new TechnicalManagementException("An error as occurred trying to find medias");
        }
    }

    @Override
    public Long getMediaMaxSize(ExecutionContext executionContext) {
        return (long)this.configService.getPortalSettings(executionContext).getPortal().getUploadMedia().getMaxSizeInOctet();
    }

    @Override
    public List<MediaEntity> findAllByApiId(String apiId) {
        try {
            return this.mediaRepository.findAllByApi(apiId).stream().map(MediaServiceImpl::convert).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            LOGGER.error("An error as occurred trying to find medias for API " + apiId, (Throwable)e);
            throw new TechnicalManagementException("An error as occurred trying to find medias");
        }
    }

    @Override
    public String createWithDefinition(String api, String mediaDefinition) {
        try {
            MediaEntity media = this.convertToEntity(mediaDefinition);
            return this.saveApiMedia(api, media);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error as occurred while trying to JSON deserialize the media " + mediaDefinition, (Throwable)e);
            throw new TechnicalManagementException("An error has occurred while trying to create media");
        }
    }

    @Override
    public void deleteAllByApi(String apiId) {
        try {
            this.mediaRepository.deleteAllByApi(apiId);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error has occurred while trying delete medias for API " + apiId, (Throwable)e);
            throw new TechnicalManagementException("An error occurred trying to delete medias");
        }
    }

    @Override
    public void deleteByHashAndApi(String hash, String apiId) {
        try {
            Media media = (Media)this.mediaRepository.findByHashAndApi(hash, apiId).orElseThrow(() -> new ApiMediaNotFoundException(hash, apiId));
            this.mediaRepository.deleteByHashAndApi(media.getHash(), apiId);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error has occurred trying to delete media for API " + apiId + " with hash " + hash, (Throwable)e);
            throw new TechnicalManagementException("An error has occurred trying to delete media");
        }
    }

    private MediaEntity convertToEntity(String mediaDefinition) throws JsonProcessingException {
        return (MediaEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(mediaDefinition, MediaEntity.class);
    }

    private static Media convert(MediaEntity imageEntity) {
        Media media = new Media();
        media.setFileName(imageEntity.getFileName());
        media.setSize(Long.valueOf(imageEntity.getSize()));
        media.setType(imageEntity.getType());
        media.setSubType(imageEntity.getSubType());
        media.setId(imageEntity.getId());
        return media;
    }

    private static MediaEntity convert(Media media) {
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setId(media.getId());
        mediaEntity.setData(media.getData());
        mediaEntity.setType(media.getType());
        mediaEntity.setSubType(media.getSubType());
        mediaEntity.setFileName(media.getFileName());
        mediaEntity.setSize(media.getSize().longValue());
        mediaEntity.setUploadDate(media.getCreatedAt());
        mediaEntity.setHash(media.getHash());
        return mediaEntity;
    }
}

