/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.usecase.log;

import io.gravitee.apim.crud_service.analytics.log.MessageLogCrudService;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.v4.log.SearchLogResponse;
import io.gravitee.rest.api.model.v4.log.message.BaseMessageLog;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SearchMessageLogUsecase {
    private final MessageLogCrudService messageLogCrudService;

    public SearchMessageLogUsecase(MessageLogCrudService messageLogCrudService) {
        this.messageLogCrudService = messageLogCrudService;
    }

    public Response execute(Request request) {
        Pageable pageable = request.pageable.orElse((Pageable)new PageableImpl(1, 20));
        SearchLogResponse<BaseMessageLog> response = this.messageLogCrudService.searchApiMessageLog(request.apiId(), request.requestId(), pageable);
        return this.mapToResponse(response);
    }

    private Response mapToResponse(SearchLogResponse<BaseMessageLog> logs) {
        long total = logs.total();
        List data = logs.logs();
        return new Response(total, data);
    }

    public record Request(String apiId, String requestId, String userId, Optional<Pageable> pageable) {
        public Request(String apiId, String requestId, String userId) {
            this(apiId, requestId, userId, Optional.empty());
        }

        public Request(String apiId, String requestId, String userId, Pageable pageable) {
            this(apiId, requestId, userId, Optional.of(pageable));
        }
    }

    public record Response(long total, List<BaseMessageLog> data) {
    }
}

