/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Collections;
import java.util.Map;

public class ClientIdAlreadyExistsException
extends AbstractManagementException {
    private final String clientId;

    public ClientIdAlreadyExistsException(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "An application already exists with client_id [" + this.clientId + "]";
    }

    @Override
    public String getTechnicalCode() {
        return "application.clientId.exists";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("clientId", this.clientId);
    }
}

