/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserMembership;
import io.gravitee.rest.api.model.alert.ApplicationAlertEventType;
import io.gravitee.rest.api.model.alert.ApplicationAlertMembershipEvent;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.providers.User;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApplicationAlertService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EmailNotification;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.IdentityService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiOwnershipTransferException;
import io.gravitee.rest.api.service.exceptions.ApiPrimaryOwnerRemovalException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.MembershipAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.NotAuthorizedMembershipException;
import io.gravitee.rest.api.service.exceptions.PaginationInvalidException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.v4.ApiGroupService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MembershipServiceImpl
extends AbstractService
implements MembershipService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MembershipServiceImpl.class);
    private static final String DEFAULT_SOURCE = "system";
    private final Cache<String, Set<RoleEntity>> roles = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private final UserService userService;
    private final EmailService emailService;
    private final IdentityService identityService;
    private final MembershipRepository membershipRepository;
    private final RoleService roleService;
    private final ApplicationService applicationService;
    private final ApplicationAlertService applicationAlertService;
    private final ApiSearchService apiSearchService;
    private final ApiGroupService apiGroupService;
    private final GroupService groupService;
    private final AuditService auditService;
    private final ApiRepository apiRepository;
    private final ApplicationRepository applicationRepository;
    private final EventManager eventManager;
    private final PrimaryOwnerService primaryOwnerService;

    public MembershipServiceImpl(@Autowired @Lazy IdentityService identityService, @Autowired @Lazy UserService userService, @Autowired @Lazy ApplicationRepository applicationRepository, @Autowired EventManager eventManager, @Autowired @Lazy PrimaryOwnerService primaryOwnerService, @Autowired EmailService emailService, @Autowired @Lazy MembershipRepository membershipRepository, @Autowired @Lazy RoleService roleService, @Autowired @Lazy ApplicationService applicationService, @Autowired @Lazy ApplicationAlertService applicationAlertService, @Autowired ApiSearchService apiSearchService, @Autowired @Lazy ApiGroupService apiGroupService, @Autowired @Lazy ApiRepository apiRepository, @Autowired @Lazy GroupService groupService, @Autowired AuditService auditService) {
        this.identityService = identityService;
        this.userService = userService;
        this.applicationRepository = applicationRepository;
        this.eventManager = eventManager;
        this.primaryOwnerService = primaryOwnerService;
        this.emailService = emailService;
        this.membershipRepository = membershipRepository;
        this.roleService = roleService;
        this.applicationService = applicationService;
        this.applicationAlertService = applicationAlertService;
        this.apiSearchService = apiSearchService;
        this.apiGroupService = apiGroupService;
        this.apiRepository = apiRepository;
        this.groupService = groupService;
        this.auditService = auditService;
    }

    @Override
    public MemberEntity addRoleToMemberOnReference(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String role) {
        return this.addRoleToMemberOnReference(executionContext, referenceType, referenceId, memberType, memberId, role, DEFAULT_SOURCE);
    }

    @Override
    public MemberEntity addRoleToMemberOnReference(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String role, String source) {
        RoleEntity roleToAdd = this.roleService.findById(role);
        return this._addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(referenceType, referenceId), new MembershipService.MembershipMember(memberId, null, memberType), new MembershipService.MembershipRole(roleToAdd.getScope(), roleToAdd.getName()), source, true, false);
    }

    @Override
    public MemberEntity addRoleToMemberOnReference(ExecutionContext executionContext, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, MembershipService.MembershipRole role) {
        return this._addRoleToMemberOnReference(executionContext, reference, member, role, DEFAULT_SOURCE, true, false);
    }

    private MemberEntity _addRoleToMemberOnReference(ExecutionContext executionContext, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, MembershipService.MembershipRole role, String source, boolean notify, boolean update) {
        try {
            LOGGER.debug("Add a new member for {} {}", (Object)reference.getType(), (Object)reference.getId());
            Optional<RoleEntity> optRoleEntity = this.roleService.findByScopeAndName(role.getScope(), role.getName(), executionContext.getOrganizationId());
            if (optRoleEntity.isPresent()) {
                Set similarMemberships;
                RoleEntity roleEntity = optRoleEntity.get();
                this.assertRoleScopeAllowedForReference(reference, roleEntity);
                this.assertRoleNameAllowedForReference(reference, roleEntity);
                if (member.getMemberId() != null && !(similarMemberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId(member.getMemberId(), this.convert(member.getMemberType()), this.convert(reference.getType()), reference.getId(), roleEntity.getId())).isEmpty()) {
                    if (update) {
                        UserEntity userEntity = this.findUserFromMembershipMember(executionContext, member);
                        return this.getUserMember(executionContext, reference.getType(), reference.getId(), userEntity.getId());
                    }
                    throw new MembershipAlreadyExistsException(member.getMemberId(), member.getMemberType(), reference.getId(), reference.getType());
                }
                Date updateDate = new Date();
                MemberEntity userMember = null;
                if (member.getMemberType() == MembershipMemberType.USER) {
                    EmailNotification emailNotification;
                    boolean shouldNotify;
                    UserEntity userEntity = this.findUserFromMembershipMember(executionContext, member);
                    Membership membership = new Membership(UuidString.generateRandom(), userEntity.getId(), this.convert(member.getMemberType()), reference.getId(), this.convert(reference.getType()), roleEntity.getId());
                    membership.setSource(source);
                    membership.setCreatedAt(updateDate);
                    membership.setUpdatedAt(updateDate);
                    this.membershipRepository.create(membership);
                    this.createAuditLog(executionContext, (Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_CREATED, membership.getCreatedAt(), null, membership);
                    if (MembershipReferenceType.APPLICATION.equals((Object)reference.getType())) {
                        this.applicationAlertService.addMemberToApplication(executionContext, reference.getId(), userEntity.getEmail());
                    }
                    Set userRolesOnReference = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(userEntity.getId(), this.convert(member.getMemberType()), this.convert(reference.getType()), reference.getId());
                    boolean bl = shouldNotify = notify && userRolesOnReference != null && userRolesOnReference.size() == 1 && userEntity.getEmail() != null && !userEntity.getEmail().isEmpty();
                    if (shouldNotify) {
                        if (MembershipReferenceType.GROUP.equals((Object)reference.getType())) {
                            GroupEntity group = this.groupService.findById(executionContext, reference.getId());
                            shouldNotify = !group.isDisableMembershipNotifications();
                        } else if (MembershipReferenceType.API.equals((Object)reference.getType())) {
                            GenericApiEntity api = this.apiSearchService.findGenericById(executionContext, reference.getId());
                            shouldNotify = !api.isDisableMembershipNotifications();
                        } else if (MembershipReferenceType.APPLICATION.equals((Object)reference.getType())) {
                            ApplicationEntity application = this.applicationService.findById(executionContext, reference.getId());
                            boolean bl2 = shouldNotify = !application.isDisableMembershipNotifications();
                        }
                    }
                    if (shouldNotify && (emailNotification = this.buildEmailNotification(executionContext, userEntity, reference.getType(), reference.getId())) != null) {
                        this.emailService.sendAsyncEmailNotification(executionContext, emailNotification);
                    }
                    userMember = this.getUserMember(executionContext, reference.getType(), reference.getId(), userEntity.getId());
                } else {
                    Membership membership = new Membership(UuidString.generateRandom(), member.getMemberId(), this.convert(member.getMemberType()), reference.getId(), this.convert(reference.getType()), roleEntity.getId());
                    membership.setSource(source);
                    membership.setCreatedAt(updateDate);
                    membership.setUpdatedAt(updateDate);
                    this.membershipRepository.create(membership);
                    this.createAuditLog(executionContext, (Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_CREATED, membership.getCreatedAt(), null, membership);
                }
                this.roles.invalidate((Object)(reference.getType().name() + reference.getId() + member.getMemberType() + member.getMemberId()));
                return userMember;
            }
            throw new RoleNotFoundException(role.getScope().name() + "_" + role.getName());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to add member for {} {}", new Object[]{reference.getType(), reference.getId(), ex});
            throw new TechnicalManagementException("An error occurs while trying to add member for " + reference.getType() + " " + reference.getId(), ex);
        }
    }

    private void createAuditLog(ExecutionContext executionContext, Audit.AuditEvent event, Date date, Membership oldValue, Membership newValue) {
        io.gravitee.repository.management.model.MembershipReferenceType referenceType = oldValue != null ? oldValue.getReferenceType() : newValue.getReferenceType();
        String referenceId = oldValue != null ? oldValue.getReferenceId() : newValue.getReferenceId();
        String username = oldValue != null ? oldValue.getMemberId() : newValue.getMemberId();
        HashMap<Audit.AuditProperties, String> properties = new HashMap<Audit.AuditProperties, String>();
        properties.put(Audit.AuditProperties.USER, username);
        switch (referenceType) {
            case API: {
                this.auditService.createApiAuditLog(executionContext, referenceId, properties, event, date, oldValue, newValue);
                break;
            }
            case APPLICATION: {
                this.auditService.createApplicationAuditLog(executionContext, referenceId, properties, event, date, oldValue, newValue);
                break;
            }
            case GROUP: {
                properties.put(Audit.AuditProperties.GROUP, referenceId);
                this.auditService.createAuditLog(executionContext, properties, event, date, oldValue, newValue);
                break;
            }
            case ENVIRONMENT: {
                this.auditService.createAuditLog(executionContext, properties, event, date, oldValue, newValue);
                break;
            }
            case ORGANIZATION: {
                this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), properties, event, date, oldValue, newValue);
            }
        }
    }

    private EmailNotification buildEmailNotification(ExecutionContext executionContext, UserEntity user, MembershipReferenceType referenceType, String referenceId) {
        EmailNotificationBuilder.EmailTemplate template = null;
        Map<String, Object> params = null;
        NotificationParamsBuilder paramsBuilder = new NotificationParamsBuilder();
        switch (referenceType) {
            case APPLICATION: {
                ApplicationEntity applicationEntity = this.applicationService.findById(executionContext, referenceId);
                template = EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_APPLICATION_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.application(applicationEntity).user(user).build();
                break;
            }
            case API: {
                GenericApiEntity indexableApi = this.apiSearchService.findGenericById(executionContext, referenceId);
                template = EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_API_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.api(indexableApi).user(user).build();
                break;
            }
            case GROUP: {
                GroupEntity groupEntity = this.groupService.findById(executionContext, referenceId);
                template = EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_GROUP_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.group(groupEntity).user(user).build();
                break;
            }
        }
        if (template == null) {
            return null;
        }
        return new EmailNotificationBuilder().to(user.getEmail()).template(template).params(params).build();
    }

    private MemberEntity convertToMemberEntity(Membership membership) {
        MemberEntity member = new MemberEntity();
        member.setId(membership.getMemberId());
        member.setCreatedAt(membership.getCreatedAt());
        member.setUpdatedAt(membership.getUpdatedAt());
        member.setReferenceId(membership.getReferenceId());
        member.setReferenceType(this.convert(membership.getReferenceType()));
        if (membership.getRoleId() != null) {
            RoleEntity role = this.roleService.findById(membership.getRoleId());
            member.setPermissions(role.getPermissions());
            ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>();
            roles.add(role);
            member.setRoles(roles);
        }
        member.setType(MembershipMemberType.valueOf((String)membership.getMemberType().name()));
        return member;
    }

    private void fillMemberUserInformation(ExecutionContext executionContext, Set<Membership> memberships, List<MemberEntity> members) {
        if (memberships != null && !memberships.isEmpty()) {
            HashSet<UserEntity> userEntities = new HashSet<UserEntity>();
            List<String> userIds = members.stream().filter(m -> m.getType() == MembershipMemberType.USER).map(MemberEntity::getId).collect(Collectors.toList());
            if (userIds != null && userIds.size() > 0) {
                userEntities.addAll(this.userService.findByIds(executionContext, userIds, false));
            }
            HashSet<GroupEntity> groupEntities = new HashSet<GroupEntity>();
            Set<String> groupsIds = members.stream().filter(m -> m.getType() == MembershipMemberType.GROUP).map(MemberEntity::getId).collect(Collectors.toSet());
            if (groupsIds != null && groupsIds.size() > 0) {
                groupEntities.addAll(this.groupService.findByIds(groupsIds));
            }
            members.forEach(m -> {
                Optional<Membership> membership = memberships.stream().filter(ms -> ms.getMemberId().equals(m.getId())).findFirst();
                membership.ifPresent(ms -> {
                    if (ms.getMemberType() == io.gravitee.repository.management.model.MembershipMemberType.USER) {
                        Optional<UserEntity> user = userEntities.stream().filter(u -> u.getId().equals(ms.getMemberId())).findFirst();
                        user.ifPresent(u -> {
                            m.setDisplayName(u.getDisplayName());
                            m.setEmail(u.getEmail());
                        });
                    } else {
                        Optional<GroupEntity> group = groupEntities.stream().filter(u -> u.getId().equals(ms.getMemberId())).findFirst();
                        group.ifPresent(g -> m.setDisplayName(g.getName()));
                    }
                });
            });
        }
    }

    private UserEntity findUserFromMembershipMember(ExecutionContext executionContext, MembershipService.MembershipMember member) {
        UserEntity userEntity;
        if (member.getMemberId() != null) {
            userEntity = this.userService.findById(executionContext, member.getMemberId());
        } else {
            Optional<User> providerUser = this.identityService.findByReference(member.getReference());
            if (providerUser.isPresent()) {
                User identityUser = providerUser.get();
                userEntity = this.findOrCreateUser(executionContext, identityUser);
            } else {
                throw new UserNotFoundException(member.getReference());
            }
        }
        return userEntity;
    }

    private UserEntity findOrCreateUser(ExecutionContext executionContext, User identityUser) {
        UserEntity userEntity;
        try {
            userEntity = this.userService.findBySource(executionContext, identityUser.getSource(), identityUser.getSourceId(), false);
        }
        catch (UserNotFoundException unfe) {
            NewExternalUserEntity newUser = new NewExternalUserEntity();
            newUser.setFirstname(identityUser.getFirstname());
            newUser.setLastname(identityUser.getLastname());
            newUser.setSource(identityUser.getSource());
            newUser.setEmail(identityUser.getEmail());
            newUser.setSourceId(identityUser.getSourceId());
            newUser.setPicture(identityUser.getPicture());
            if (identityUser.getRoles() == null || identityUser.getRoles().isEmpty()) {
                userEntity = this.userService.create(executionContext, newUser, true);
            }
            userEntity = this.userService.create(executionContext, newUser, false);
            for (Map.Entry role : identityUser.getRoles().entrySet()) {
                MembershipReferenceType membershipReferenceType = MembershipReferenceType.valueOf((String)((String)role.getKey()));
                MembershipService.MembershipReference reference = null;
                if (membershipReferenceType == MembershipReferenceType.ORGANIZATION) {
                    reference = new MembershipService.MembershipReference(membershipReferenceType, executionContext.getOrganizationId());
                } else if (membershipReferenceType == MembershipReferenceType.ENVIRONMENT) {
                    reference = new MembershipService.MembershipReference(membershipReferenceType, executionContext.getEnvironmentId());
                }
                if (reference == null) continue;
                this.addRoleToMemberOnReference(executionContext, reference, new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.valueOf((String)((String)role.getKey())), (String)role.getValue()));
            }
        }
        return userEntity;
    }

    private void assertRoleScopeAllowedForReference(MembershipService.MembershipReference reference, RoleEntity roleEntity) {
        if (MembershipReferenceType.API == reference.getType() && RoleScope.API != roleEntity.getScope() || MembershipReferenceType.APPLICATION == reference.getType() && RoleScope.APPLICATION != roleEntity.getScope() || MembershipReferenceType.GROUP == reference.getType() && RoleScope.GROUP != roleEntity.getScope() && RoleScope.API != roleEntity.getScope() && RoleScope.APPLICATION != roleEntity.getScope()) {
            throw new NotAuthorizedMembershipException(roleEntity.getName());
        }
    }

    public void assertRoleNameAllowedForReference(MembershipService.MembershipReference reference, RoleEntity roleEntity) throws TechnicalException {
        if (MembershipReferenceType.GROUP == reference.getType() && SystemRole.PRIMARY_OWNER.name().equals(roleEntity.getName())) {
            if (roleEntity.getScope() == RoleScope.APPLICATION) {
                throw new NotAuthorizedMembershipException(roleEntity.getName());
            }
            if (roleEntity.getScope() == RoleScope.API && this.membershipRepository.findByReferenceAndRoleId(io.gravitee.repository.management.model.MembershipReferenceType.GROUP, reference.getId(), roleEntity.getId()).size() > 0) {
                throw new NotAuthorizedMembershipException(roleEntity.getName());
            }
        }
    }

    @Override
    public void deleteMembership(ExecutionContext executionContext, String membershipId) {
        try {
            Optional membership = this.membershipRepository.findById(membershipId);
            if (membership.isPresent()) {
                LOGGER.debug("Delete membership {}", membership.get());
                this.membershipRepository.delete(membershipId);
                this.createAuditLog(executionContext, (Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_DELETED, new Date(), (Membership)membership.get(), null);
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete membership {}", (Object)membershipId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete membership " + membershipId, ex);
        }
    }

    @Override
    public void deleteReference(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId) {
        try {
            Set memberships = this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, null);
            if (!memberships.isEmpty()) {
                for (Membership membership : memberships) {
                    LOGGER.debug("Delete membership {}", (Object)membership.getId());
                    this.membershipRepository.delete(membership.getId());
                    this.createAuditLog(executionContext, (Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_DELETED, new Date(), membership, null);
                }
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete memberships for {} {}", new Object[]{referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete memberships for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public void deleteReferenceMember(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId) {
        this.deleteReferenceMemberBySource(executionContext, referenceType, referenceId, memberType, memberId, null);
    }

    @Override
    public void deleteReferenceMemberBySource(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String sourceId) {
        try {
            RoleEntity apiPORole = this.roleService.findByScopeAndName(RoleScope.API, SystemRole.PRIMARY_OWNER.name(), executionContext.getOrganizationId()).orElseThrow(() -> new TechnicalManagementException("Unable to find API Primary Owner role"));
            Set memberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(memberId, this.convert(memberType), this.convert(referenceType), referenceId);
            if (MembershipReferenceType.API.equals((Object)referenceType)) {
                this.assertNoPrimaryOwnerRemoval(apiPORole, memberships);
            }
            for (Membership membership : memberships) {
                if (sourceId == null || membership.getSource().equals(sourceId)) {
                    LOGGER.debug("Delete membership {}", (Object)membership.getId());
                    this.membershipRepository.delete(membership.getId());
                    this.createAuditLog(executionContext, (Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_DELETED, new Date(), membership, null);
                }
                if (MembershipReferenceType.APPLICATION.equals((Object)referenceType) && MembershipMemberType.USER.equals((Object)memberType)) {
                    UserEntity userEntity = this.findUserFromMembershipMember(executionContext, new MembershipService.MembershipMember(memberId, null, memberType));
                    this.applicationAlertService.deleteMemberFromApplication(executionContext, referenceId, userEntity.getEmail());
                }
                if (membership.getReferenceType() != io.gravitee.repository.management.model.MembershipReferenceType.GROUP || !membership.getRoleId().equals(apiPORole.getId())) continue;
                this.groupService.updateApiPrimaryOwner(membership.getReferenceId(), null);
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete memberships for {} {} {} {}", new Object[]{referenceType, referenceId, memberType, memberId, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete memberships for " + referenceType + " " + referenceId + " " + memberType + " " + memberId, ex);
        }
    }

    private void assertNoPrimaryOwnerRemoval(RoleEntity apiPORole, Set<Membership> memberships) {
        memberships.stream().filter(membership -> membership.getRoleId().equals(apiPORole.getId())).findFirst().ifPresent(membership -> {
            throw new ApiPrimaryOwnerRemovalException();
        });
    }

    @Override
    public List<UserMembership> findUserMembershipBySource(ExecutionContext executionContext, MembershipReferenceType type, String userId, String sourceId) {
        try {
            Map<String, RoleEntity> roleMap = this.roleService.findAllByOrganization(executionContext.getOrganizationId()).stream().collect(Collectors.toMap(RoleEntity::getId, r -> r));
            HashMap userMembershipMap = new HashMap();
            this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndSource(userId, io.gravitee.repository.management.model.MembershipMemberType.USER, this.convert(type), sourceId).stream().filter(membership -> sourceId != null && sourceId.equals(membership.getSource())).forEach(membership -> {
                UserMembership userMembership = new UserMembership();
                userMembership.setType(type.name());
                userMembership.setReference(membership.getReferenceId());
                userMembership.setSource(membership.getSource());
                RoleEntity role = (RoleEntity)roleMap.get(membership.getRoleId());
                if (role != null) {
                    int key = userMembership.hashCode();
                    if (userMembershipMap.containsKey(key)) {
                        ((UserMembership)userMembershipMap.get(key)).getRoles().put(role.getScope().name(), role.getName());
                    } else {
                        HashMap<String, String> roles = new HashMap<String, String>();
                        roles.put(role.getScope().name(), role.getName());
                        userMembership.setRoles(roles);
                        userMembershipMap.put(userMembership.hashCode(), userMembership);
                    }
                }
            });
            return new ArrayList<UserMembership>(userMembershipMap.values());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove user " + userId, ex);
        }
    }

    @Override
    public List<UserMembership> findUserMembership(ExecutionContext executionContext, MembershipReferenceType type, String userId) {
        if (type == null || !type.equals((Object)MembershipReferenceType.API) && !type.equals((Object)MembershipReferenceType.APPLICATION) && !type.equals((Object)MembershipReferenceType.GROUP)) {
            return Collections.emptyList();
        }
        try {
            Map<String, RoleEntity> roleMap = this.roleService.findByScope(this.roleService.findScopeByMembershipReferenceType(type), executionContext.getOrganizationId()).stream().collect(Collectors.toMap(RoleEntity::getId, r -> r));
            HashMap userMembershipMap = new HashMap();
            this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType(userId, io.gravitee.repository.management.model.MembershipMemberType.USER, this.convert(type)).forEach(membership -> {
                UserMembership userMembership = new UserMembership();
                userMembership.setType(type.name());
                userMembership.setReference(membership.getReferenceId());
                userMembership.setSource(membership.getSource());
                RoleEntity role = (RoleEntity)roleMap.get(membership.getRoleId());
                if (role != null) {
                    int key = userMembership.hashCode();
                    if (userMembershipMap.containsKey(key)) {
                        ((UserMembership)userMembershipMap.get(key)).getRoles().put(role.getScope().name(), role.getName());
                    } else {
                        HashMap<String, String> roles = new HashMap<String, String>();
                        roles.put(role.getScope().name(), role.getName());
                        userMembership.setRoles(roles);
                        userMembershipMap.put(userMembership.hashCode(), userMembership);
                    }
                }
            });
            HashSet userMemberships = new HashSet(userMembershipMap.values());
            if (type.equals((Object)MembershipReferenceType.APPLICATION) || type.equals((Object)MembershipReferenceType.API)) {
                ApiCriteria criteria;
                List groupApisIds;
                String[] groupIds = (String[])this.groupService.findByUser(userId).stream().map(GroupEntity::getId).toArray(String[]::new);
                ArrayList resourceIds = new ArrayList();
                if (type.equals((Object)MembershipReferenceType.APPLICATION) && groupIds.length > 0) {
                    Set groupApplications = this.applicationRepository.findByGroups(List.of(groupIds), new ApplicationStatus[0]);
                    groupApplications.forEach(application -> resourceIds.add(application.getId()));
                } else if (type.equals((Object)MembershipReferenceType.API) && groupIds.length > 0 && (groupApisIds = this.apiRepository.searchIds(List.of(criteria = new ApiCriteria.Builder().groups(groupIds).build()), MembershipServiceImpl.convert((Pageable)new PageableImpl(1, Integer.MAX_VALUE)), null).getContent()) != null) {
                    resourceIds.addAll(groupApisIds);
                }
                if (!resourceIds.isEmpty()) {
                    userMemberships.addAll(resourceIds.stream().map(id -> {
                        UserMembership userMembership = new UserMembership();
                        userMembership.setType(type.name());
                        userMembership.setReference(id);
                        return userMembership;
                    }).collect(Collectors.toSet()));
                }
            }
            return new ArrayList<UserMembership>(userMemberships);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove user " + userId, ex);
        }
    }

    @Override
    public Metadata findUserMembershipMetadata(List<UserMembership> memberships, MembershipReferenceType type) {
        if (memberships == null || memberships.isEmpty() || type == null || !type.equals((Object)MembershipReferenceType.API) && !type.equals((Object)MembershipReferenceType.APPLICATION) && !type.equals((Object)MembershipReferenceType.GROUP)) {
            return new Metadata();
        }
        try {
            Metadata metadata = new Metadata();
            if (type.equals((Object)MembershipReferenceType.API)) {
                ApiCriteria.Builder criteria = new ApiCriteria.Builder();
                criteria.ids((String[])memberships.stream().map(UserMembership::getReference).toArray(String[]::new));
                this.apiRepository.search(criteria.build(), null, ApiFieldFilter.defaultFields()).forEach(api -> {
                    metadata.put(api.getId(), "name", (Object)api.getName());
                    metadata.put(api.getId(), "version", (Object)api.getVersion());
                    metadata.put(api.getId(), "visibility", (Object)api.getVisibility());
                });
            } else if (type.equals((Object)MembershipReferenceType.APPLICATION)) {
                this.applicationRepository.findByIds((Collection)memberships.stream().map(UserMembership::getReference).collect(Collectors.toList())).forEach(application -> metadata.put(application.getId(), "name", (Object)application.getName()));
            }
            return metadata;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get user membership metadata", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to get user membership metadata", ex);
        }
    }

    @Override
    public Page<MemberEntity> getMembersByReference(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, Pageable pageable) {
        return this.getMembersByReference(executionContext, referenceType, referenceId, null, pageable);
    }

    @Override
    public Set<MemberEntity> getMembersByReference(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId) {
        return this.getMembersByReferenceAndRole(executionContext, referenceType, referenceId, null);
    }

    @Override
    public Page<MemberEntity> getMembersByReference(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, String role, Pageable pageable) {
        return this.getMembersByReferenceAndRole(executionContext, referenceType, referenceId, role, pageable);
    }

    @Override
    public Set<MemberEntity> getMembersByReference(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, String role) {
        return this.getMembersByReferenceAndRole(executionContext, referenceType, referenceId, role);
    }

    @Override
    public Page<MemberEntity> getMembersByReferenceAndRole(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, String role, Pageable pageable) {
        return this.getMembersByReferencesAndRole(executionContext, referenceType, Collections.singletonList(referenceId), role, pageable);
    }

    @Override
    public Set<MemberEntity> getMembersByReferenceAndRole(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, String role) {
        return new HashSet<MemberEntity>(this.getMembersByReference(executionContext, referenceType, referenceId, role, null).getContent());
    }

    @Override
    public Set<MemberEntity> getMembersByReferencesAndRole(ExecutionContext executionContext, MembershipReferenceType referenceType, List<String> referenceIds, String role) {
        return new HashSet<MemberEntity>(this.getMembersByReferencesAndRole(executionContext, referenceType, referenceIds, role, null).getContent());
    }

    @Override
    public Page<MemberEntity> getMembersByReferencesAndRole(ExecutionContext executionContext, MembershipReferenceType referenceType, List<String> referenceIds, String role, Pageable pageable) {
        try {
            LOGGER.debug("Get members for {} {}", (Object)referenceType, referenceIds);
            Set memberships = this.membershipRepository.findByReferencesAndRoleId(this.convert(referenceType), referenceIds, role);
            HashMap results = new HashMap();
            memberships.stream().map(this::convertToMemberEntity).forEach(member -> {
                String key = member.getId() + member.getReferenceId();
                MemberEntity existingEntity = (MemberEntity)results.get(key);
                if (existingEntity == null) {
                    results.put(key, member);
                    existingEntity = member;
                } else {
                    HashSet existingRoles = new HashSet(existingEntity.getRoles());
                    existingRoles.addAll(member.getRoles());
                    existingEntity.setRoles(new ArrayList(existingRoles));
                }
            });
            ArrayList<MemberEntity> members = new ArrayList<MemberEntity>(results.values());
            this.fillMemberUserInformation(executionContext, memberships, members);
            return this.paginate(results.values(), pageable);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get members for {} {}", new Object[]{referenceType, referenceIds, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for " + referenceType + " " + referenceIds, ex);
        }
    }

    private Page<MemberEntity> paginate(Collection<MemberEntity> members, Pageable pageable) {
        Comparator<MemberEntity> comparator = Comparator.comparing(memberEntity -> memberEntity.getDisplayName().toLowerCase(Locale.ROOT));
        if (pageable == null) {
            pageable = new PageableImpl(1, Integer.MAX_VALUE);
        }
        int totalCount = members.size();
        int startIndex = (pageable.getPageNumber() - 1) * pageable.getPageSize();
        if (pageable.getPageNumber() < 1 || totalCount > 0 && startIndex >= totalCount) {
            throw new PaginationInvalidException();
        }
        List subsetApis = members.stream().sorted(comparator).skip(startIndex).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new Page(subsetApis, pageable.getPageNumber(), pageable.getPageSize(), (long)members.size());
    }

    private io.gravitee.repository.management.model.MembershipReferenceType convert(MembershipReferenceType referenceType) {
        return io.gravitee.repository.management.model.MembershipReferenceType.valueOf((String)referenceType.name());
    }

    private MembershipReferenceType convert(io.gravitee.repository.management.model.MembershipReferenceType referenceType) {
        return MembershipReferenceType.valueOf((String)referenceType.name());
    }

    private io.gravitee.repository.management.model.MembershipMemberType convert(MembershipMemberType memberType) {
        return io.gravitee.repository.management.model.MembershipMemberType.valueOf((String)memberType.name());
    }

    private MembershipMemberType convert(io.gravitee.repository.management.model.MembershipMemberType memberType) {
        return MembershipMemberType.valueOf((String)memberType.name());
    }

    private MembershipEntity convert(Membership membership) {
        MembershipEntity result = new MembershipEntity();
        result.setCreatedAt(membership.getCreatedAt());
        result.setId(membership.getId());
        result.setMemberId(membership.getMemberId());
        result.setMemberType(this.convert(membership.getMemberType()));
        result.setReferenceId(membership.getReferenceId());
        result.setReferenceType(this.convert(membership.getReferenceType()));
        result.setRoleId(membership.getRoleId());
        result.setUpdatedAt(membership.getUpdatedAt());
        return result;
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMember(MembershipMemberType memberType, String memberId) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberType(memberId, this.convert(memberType)).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<String> getReferenceIdsByMemberAndReference(MembershipMemberType memberType, String memberId, MembershipReferenceType referenceType) {
        try {
            return this.membershipRepository.findRefIdsByMemberIdAndMemberTypeAndReferenceType(memberId, this.convert(memberType), this.convert(referenceType)).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMemberAndReference(MembershipMemberType memberType, String memberId, MembershipReferenceType referenceType) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType(memberId, this.convert(memberType), this.convert(referenceType)).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMemberAndReferenceAndRole(MembershipMemberType memberType, String memberId, MembershipReferenceType referenceType, String role) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndRoleId(memberId, this.convert(memberType), this.convert(referenceType), role).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMemberAndReferenceAndRoleIn(MembershipMemberType memberType, String memberId, MembershipReferenceType referenceType, Collection<String> roleIds) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndRoleIdIn(memberId, this.convert(memberType), this.convert(referenceType), roleIds).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<String> getReferenceIdsByMemberAndReferenceAndRoleIn(MembershipMemberType memberType, String memberId, MembershipReferenceType referenceType, Collection<String> roleIds) {
        try {
            return this.membershipRepository.findRefIdByMemberAndRefTypeAndRoleIdIn(memberId, this.convert(memberType), this.convert(referenceType), roleIds);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMembersAndReference(MembershipMemberType memberType, List<String> memberIds, MembershipReferenceType referenceType) {
        try {
            return this.membershipRepository.findByMemberIdsAndMemberTypeAndReferenceType(memberIds, this.convert(memberType), this.convert(referenceType)).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", memberIds, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberIds, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByReference(MembershipReferenceType referenceType, String referenceId) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, null).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} {} ", new Object[]{referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByReferenceAndRole(MembershipReferenceType referenceType, String referenceId, String role) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, role).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} {} and role", new Object[]{referenceType, referenceId, role, ex});
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + referenceType + " " + referenceId + " and role " + role, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByReferencesAndRole(MembershipReferenceType referenceType, List<String> referenceIds, String role) {
        try {
            return this.membershipRepository.findByReferencesAndRoleId(this.convert(referenceType), referenceIds, role).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} {} and role", new Object[]{referenceType, referenceIds, role, ex});
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + referenceType + " " + referenceIds + " and role " + role, ex);
        }
    }

    @Override
    public MembershipEntity getPrimaryOwner(String organizationId, MembershipReferenceType referenceType, String referenceId) {
        RoleScope poRoleScope;
        if (referenceType == MembershipReferenceType.API) {
            poRoleScope = RoleScope.API;
        } else if (referenceType == MembershipReferenceType.APPLICATION) {
            poRoleScope = RoleScope.APPLICATION;
        } else {
            throw new RoleNotFoundException(referenceType.name() + "_PRIMARY_OWNER");
        }
        RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, poRoleScope);
        if (poRole != null) {
            try {
                Optional poMember = this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, poRole.getId()).stream().findFirst();
                if (poMember.isPresent()) {
                    return this.convert((Membership)poMember.get());
                }
                return null;
            }
            catch (TechnicalException ex) {
                LOGGER.error("An error occurs while trying to get primary owner for {} {} and role", new Object[]{referenceType, referenceId, ex});
                throw new TechnicalManagementException("An error occurs while trying to get primary owner for " + referenceType + " " + referenceId, ex);
            }
        }
        throw new RoleNotFoundException(referenceType.name() + "_PRIMARY_OWNER");
    }

    @Override
    public Set<RoleEntity> getRoles(MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId) {
        try {
            LOGGER.debug("Get role for {} {} and member {} {}", new Object[]{referenceType, referenceId, memberType, memberId});
            return (Set)this.roles.get((Object)(referenceType.name() + referenceId + memberType + memberId), () -> this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(memberId, this.convert(memberType), this.convert(referenceType), referenceId).stream().map(Membership::getRoleId).map(this.roleService::findById).collect(Collectors.toSet()));
        }
        catch (Exception ex) {
            String message = "An error occurs while trying to get roles for " + referenceType + " " + referenceId + " " + memberType + " " + memberId;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public MemberEntity getUserMember(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, String userId) {
        try {
            Set userMemberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(userId, this.convert(MembershipMemberType.USER), this.convert(referenceType), referenceId);
            Set entityGroups = new HashSet();
            switch (referenceType) {
                case API: {
                    entityGroups = ((Api)this.apiRepository.findById((Object)referenceId).orElseThrow(() -> new ApiNotFoundException(referenceId))).getGroups();
                    break;
                }
                case APPLICATION: {
                    entityGroups = ((Application)this.applicationRepository.findById((Object)referenceId).orElseThrow(() -> new ApplicationNotFoundException(referenceId))).getGroups();
                    break;
                }
            }
            if (userMemberships.isEmpty() && (entityGroups == null || entityGroups.isEmpty())) {
                return null;
            }
            MemberEntity memberEntity = new MemberEntity();
            UserEntity userEntity = this.userService.findById(executionContext, userId);
            memberEntity.setCreatedAt(userEntity.getCreatedAt());
            memberEntity.setDisplayName(userEntity.getDisplayName());
            memberEntity.setEmail(userEntity.getEmail());
            memberEntity.setId(userEntity.getId());
            memberEntity.setUpdatedAt(userEntity.getUpdatedAt());
            HashSet<RoleEntity> userRoles = new HashSet<RoleEntity>();
            Set<Object> userDirectRoles = new HashSet();
            if (!userMemberships.isEmpty()) {
                userDirectRoles = userMemberships.stream().map(Membership::getRoleId).map(this.roleService::findById).collect(Collectors.toSet());
                userRoles.addAll(userDirectRoles);
            }
            memberEntity.setRoles(new ArrayList(userDirectRoles));
            if (entityGroups != null && !entityGroups.isEmpty()) {
                for (String group : entityGroups) {
                    userRoles.addAll(this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(userId, this.convert(MembershipMemberType.USER), this.convert(MembershipReferenceType.GROUP), group).stream().map(Membership::getRoleId).map(this.roleService::findById).filter(role -> role.getScope().name().equals(referenceType.name())).map(role -> role.isApiPrimaryOwner() ? this.mapApiPrimaryOwnerRoleToGroupRole(executionContext, referenceId, group, (RoleEntity)role) : role).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
            }
            Map<Object, Object> permissions = new HashMap();
            if (!userRoles.isEmpty()) {
                permissions = this.computeGlobalPermissions(userRoles);
            }
            memberEntity.setPermissions(permissions);
            return memberEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get user member for {} {} {} {}", new Object[]{referenceType, referenceId, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get roles for " + referenceType + " " + referenceId + " " + userId, ex);
        }
    }

    private RoleEntity mapApiPrimaryOwnerRoleToGroupRole(ExecutionContext executionContext, String apiId, String groupId, RoleEntity role) {
        PrimaryOwnerEntity apiPrimaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, apiId);
        if (apiPrimaryOwner.getId().equals(groupId)) {
            return role;
        }
        GroupEntity userGroup = this.groupService.findById(executionContext, groupId);
        String groupApiRole = (String)userGroup.getRoles().get(RoleScope.API);
        return groupApiRole == null ? null : (RoleEntity)this.roleService.findByScopeAndName(RoleScope.API, groupApiRole, executionContext.getOrganizationId()).orElse(null);
    }

    private Map<String, char[]> computeGlobalPermissions(Set<RoleEntity> userRoles) {
        HashMap<String, Set> mergedPermissions = new HashMap<String, Set>();
        for (RoleEntity role : userRoles) {
            for (Map.Entry perm : role.getPermissions().entrySet()) {
                if (mergedPermissions.containsKey(perm.getKey())) {
                    Set previousCRUD = (Set)mergedPermissions.get(perm.getKey());
                    for (char c : (char[])perm.getValue()) {
                        previousCRUD.add(Character.valueOf(c));
                    }
                    continue;
                }
                HashSet<Character> crudAsSet = new HashSet<Character>();
                for (char c : (char[])perm.getValue()) {
                    crudAsSet.add(Character.valueOf(c));
                }
                mergedPermissions.put((String)perm.getKey(), crudAsSet);
            }
        }
        HashMap<String, char[]> permissions = new HashMap<String, char[]>(mergedPermissions.size());
        mergedPermissions.forEach((k, v) -> {
            Character[] characters = v.toArray(new Character[v.size()]);
            char[] chars = new char[characters.length];
            for (int i = 0; i < characters.length; ++i) {
                chars[i] = characters[i].charValue();
            }
            permissions.put((String)k, chars);
        });
        return permissions;
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, String userId) {
        MemberEntity member = this.getUserMember(executionContext, referenceType, referenceId, userId);
        if (member != null) {
            return member.getPermissions();
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(ExecutionContext executionContext, GenericApiEntity api, String userId) {
        return this.getUserMemberPermissions(executionContext, MembershipReferenceType.API, api.getId(), userId);
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(ExecutionContext executionContext, ApplicationEntity application, String userId) {
        return this.getUserMemberPermissions(executionContext, MembershipReferenceType.APPLICATION, application.getId(), userId);
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(ExecutionContext executionContext, GroupEntity group, String userId) {
        return this.getUserMemberPermissions(executionContext, MembershipReferenceType.GROUP, group.getId(), userId);
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(ExecutionContext executionContext, EnvironmentEntity environment, String userId) {
        return this.getUserMemberPermissions(executionContext, MembershipReferenceType.ENVIRONMENT, environment.getId(), userId);
    }

    @Override
    public void removeRole(MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String roleId) {
        try {
            Set membershipsToDelete = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId(memberId, this.convert(memberType), this.convert(referenceType), referenceId, roleId);
            for (Membership m : membershipsToDelete) {
                this.membershipRepository.delete(m.getId());
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove role {} from member {} {} for {} {}", new Object[]{roleId, memberType, memberId, referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove role " + roleId + " from member " + memberType + " " + memberId + " for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public void removeRoleUsage(String oldRoleId, String newRoleId) {
        try {
            Set membershipsWithOldRole = this.membershipRepository.findByRoleId(oldRoleId);
            for (Membership membership : membershipsWithOldRole) {
                Set membershipsWithNewRole = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId(membership.getMemberId(), membership.getMemberType(), membership.getReferenceType(), membership.getReferenceId(), newRoleId);
                String oldMembershipId = membership.getId();
                if (membershipsWithNewRole.isEmpty()) {
                    membership.setId(UuidString.generateRandom());
                    membership.setRoleId(newRoleId);
                    membership.setSource(DEFAULT_SOURCE);
                    this.membershipRepository.create(membership);
                }
                this.membershipRepository.delete(oldMembershipId);
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove role {} {}", (Object)oldRoleId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove role " + oldRoleId, ex);
        }
    }

    @Override
    public void removeMemberMemberships(ExecutionContext executionContext, MembershipMemberType memberType, String memberId) {
        HashSet<String> applicationIds = new HashSet<String>();
        HashSet<String> groupIds = new HashSet<String>();
        try {
            for (Membership membership : this.membershipRepository.findByMemberIdAndMemberType(memberId, this.convert(memberType))) {
                if (this.convert(MembershipReferenceType.APPLICATION).equals((Object)membership.getReferenceType())) {
                    applicationIds.add(membership.getReferenceId());
                }
                if (this.convert(MembershipReferenceType.GROUP).equals((Object)membership.getReferenceType())) {
                    groupIds.add(membership.getReferenceId());
                }
                this.membershipRepository.delete(membership.getId());
            }
            this.eventManager.publishEvent((Enum)ApplicationAlertEventType.APPLICATION_MEMBERSHIP_UPDATE, (Object)new ApplicationAlertMembershipEvent(executionContext.getOrganizationId(), applicationIds, groupIds));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove member {} {}", new Object[]{memberType, memberId, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove " + memberType + " " + memberId, ex);
        }
    }

    @Override
    public void transferApiOwnership(ExecutionContext executionContext, String apiId, MembershipService.MembershipMember member, List<RoleEntity> newPrimaryOwnerRoles) {
        if (MembershipMemberType.GROUP.equals((Object)member.getMemberType()) && !this.hasApiPrimaryOwnerMemberInGroup(executionContext, member.getMemberId())) {
            throw new ApiOwnershipTransferException(apiId);
        }
        this.transferOwnership(executionContext, MembershipReferenceType.API, RoleScope.API, apiId, member, newPrimaryOwnerRoles);
    }

    @Override
    public void transferApplicationOwnership(ExecutionContext executionContext, String applicationId, MembershipService.MembershipMember member, List<RoleEntity> newPrimaryOwnerRoles) {
        this.transferOwnership(executionContext, MembershipReferenceType.APPLICATION, RoleScope.APPLICATION, applicationId, member, newPrimaryOwnerRoles);
    }

    private void transferOwnership(ExecutionContext executionContext, MembershipReferenceType membershipReferenceType, RoleScope roleScope, String itemId, MembershipService.MembershipMember member, List<RoleEntity> newPrimaryOwnerRoles) {
        RoleEntity poRoleEntity;
        List<RoleEntity> newRoles = newPrimaryOwnerRoles == null || newPrimaryOwnerRoles.isEmpty() ? this.roleService.findDefaultRoleByScopes(executionContext.getOrganizationId(), roleScope) : newPrimaryOwnerRoles;
        MembershipEntity primaryOwner = this.getPrimaryOwner(executionContext.getOrganizationId(), membershipReferenceType, itemId);
        this.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(membershipReferenceType, itemId), new MembershipService.MembershipMember(member.getMemberId(), member.getReference(), member.getMemberType()), new MembershipService.MembershipRole(roleScope, SystemRole.PRIMARY_OWNER.name()));
        if (membershipReferenceType == MembershipReferenceType.API && member.getMemberType() == MembershipMemberType.GROUP) {
            this.apiGroupService.addGroup(executionContext, itemId, member.getMemberId());
        }
        if ((poRoleEntity = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), roleScope)) != null) {
            if (member.getMemberType() == MembershipMemberType.USER) {
                this.getRoles(membershipReferenceType, itemId, member.getMemberType(), member.getMemberId()).forEach(role -> {
                    if (!role.getId().equals(poRoleEntity.getId())) {
                        this.removeRole(membershipReferenceType, itemId, member.getMemberType(), member.getMemberId(), role.getId());
                    }
                });
            }
            this.removeRole(membershipReferenceType, itemId, primaryOwner.getMemberType(), primaryOwner.getMemberId(), poRoleEntity.getId());
            if (primaryOwner.getMemberType() == MembershipMemberType.USER) {
                for (RoleEntity newRole : newRoles) {
                    this.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(membershipReferenceType, itemId), new MembershipService.MembershipMember(primaryOwner.getMemberId(), null, primaryOwner.getMemberType()), new MembershipService.MembershipRole(roleScope, newRole.getName()));
                }
            } else if (primaryOwner.getMemberType() == MembershipMemberType.GROUP) {
                this.apiGroupService.removeGroup(executionContext, itemId, primaryOwner.getId());
            }
        }
    }

    @Override
    public MemberEntity updateRoleToMemberOnReference(ExecutionContext executionContext, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, MembershipService.MembershipRole role) {
        return this.updateRolesToMemberOnReference(executionContext, reference, member, Collections.singleton(role), null, true).stream().findFirst().orElse(null);
    }

    @Override
    public List<MemberEntity> updateRolesToMemberOnReference(ExecutionContext executionContext, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, Collection<MembershipService.MembershipRole> roles, String source, boolean notify) {
        try {
            RoleEntity apiPORole = this.roleService.findByScopeAndName(RoleScope.API, SystemRole.PRIMARY_OWNER.name(), executionContext.getOrganizationId()).orElseThrow(() -> new TechnicalManagementException("Unable to find API Primary Owner role"));
            Set existingMemberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(member.getMemberId(), this.convert(member.getMemberType()), this.convert(reference.getType()), reference.getId());
            if (roles.stream().filter(role -> role.getName().equals(SystemRole.PRIMARY_OWNER.name())).findAny().isEmpty()) {
                this.assertNoPrimaryOwnerRemoval(apiPORole, existingMemberships);
            }
            if (existingMemberships != null && !existingMemberships.isEmpty()) {
                existingMemberships.forEach(membership -> this.deleteMembership(executionContext, membership.getId()));
            }
            return roles.stream().map(role -> this._addRoleToMemberOnReference(executionContext, reference, member, (MembershipService.MembershipRole)role, source, notify, false)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to update member for {} {}", new Object[]{reference.getType(), reference.getId(), ex});
            throw new TechnicalManagementException("An error occurs while trying to update member for " + reference.getType() + " " + reference.getId(), ex);
        }
    }

    @Override
    public List<MemberEntity> updateRolesToMemberOnReferenceBySource(ExecutionContext executionContext, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, Collection<MembershipService.MembershipRole> roles, String source) {
        return roles.stream().map(role -> this._addRoleToMemberOnReference(executionContext, reference, member, (MembershipService.MembershipRole)role, source, false, true)).collect(Collectors.toList());
    }

    @Override
    public MemberEntity createNewMembershipForApi(ExecutionContext executionContext, String apiId, String userId, String externalReference, String roleName) {
        MemberEntity userMember;
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.API, apiId);
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(userId, externalReference, MembershipMemberType.USER);
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.API, roleName);
        if (member.getMemberId() != null && (userMember = this.getUserMember(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, apiId, member.getMemberId())) != null && userMember.getRoles() != null && !userMember.getRoles().isEmpty()) {
            throw new MembershipAlreadyExistsException(member.getMemberId(), MembershipMemberType.USER, apiId, MembershipReferenceType.API);
        }
        return this.addRoleToMemberOnReference(GraviteeContext.getExecutionContext(), reference, member, role);
    }

    @Override
    public MemberEntity updateMembershipForApi(ExecutionContext executionContext, String apiId, String memberId, String roleName) {
        MemberEntity membership = null;
        MemberEntity userMember = this.getUserMember(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, apiId, memberId);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.API, apiId);
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(memberId, null, MembershipMemberType.USER);
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.API, roleName);
        if (userMember != null && userMember.getRoles() != null && !userMember.getRoles().isEmpty()) {
            membership = this.updateRoleToMemberOnReference(GraviteeContext.getExecutionContext(), reference, member, role);
        }
        return membership;
    }

    @Override
    public void deleteMemberForApi(ExecutionContext executionContext, String apiId, String memberId) {
        this.deleteReferenceMember(executionContext, MembershipReferenceType.API, apiId, MembershipMemberType.USER, memberId);
    }

    private boolean hasApiPrimaryOwnerMemberInGroup(ExecutionContext executionContext, String groupId) {
        return this.getMembersByReference(executionContext, MembershipReferenceType.GROUP, groupId).stream().anyMatch(member -> member.getRoles().stream().anyMatch(RoleEntity::isApiPrimaryOwner));
    }
}

