/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.initializer;

import io.gravitee.node.api.initializer.Initializer;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewMetadataEntity;
import io.gravitee.rest.api.service.MetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMetadataInitializer
implements Initializer {
    private final Logger logger = LoggerFactory.getLogger(DefaultMetadataInitializer.class);
    public static final String METADATA_EMAIL_SUPPORT_KEY = "email-support";
    public static final String DEFAULT_METADATA_EMAIL_SUPPORT = "support@change.me";
    @Autowired
    private MetadataService metadataService;

    public boolean initialize() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        MetadataEntity defaultEmailSupportMetadata = this.metadataService.findDefaultByKey(METADATA_EMAIL_SUPPORT_KEY);
        if (defaultEmailSupportMetadata == null) {
            this.logger.info("    No default metadata for email support found. Add default one.");
            NewMetadataEntity metadata = new NewMetadataEntity();
            metadata.setFormat(MetadataFormat.MAIL);
            metadata.setName("Email support");
            metadata.setValue(DEFAULT_METADATA_EMAIL_SUPPORT);
            MetadataEntity metadataEntity = this.metadataService.create(executionContext, metadata);
            this.logger.info("    Added default metadata for email support with success: {}", (Object)metadataEntity);
        }
        return true;
    }

    public int getOrder() {
        return 100;
    }
}

