/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.ConnectorFeature;
import io.gravitee.definition.model.v4.ConnectorMode;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.entrypoint.Dlq;
import io.gravitee.definition.model.v4.listener.entrypoint.Entrypoint;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.subscription.SubscriptionListener;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.EndpointConnectorPluginService;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointDuplicatedException;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointInvalidDlqException;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointInvalidQosException;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointMissingException;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointMissingTypeException;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointUnsupportedDlqException;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointUnsupportedListenerTypeException;
import io.gravitee.rest.api.service.v4.exception.ListenerEntrypointUnsupportedQosException;
import io.gravitee.rest.api.service.v4.exception.ListenersDuplicatedException;
import io.gravitee.rest.api.service.v4.validation.CorsValidationService;
import io.gravitee.rest.api.service.v4.validation.ListenerValidationService;
import io.gravitee.rest.api.service.v4.validation.PathValidationService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ListenerValidationServiceImpl
extends TransactionalService
implements ListenerValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListenerValidationServiceImpl.class);
    private final PathValidationService pathValidationService;
    private final EntrypointConnectorPluginService entrypointService;
    private final EndpointConnectorPluginService endpointService;
    private final CorsValidationService corsValidationService;

    public ListenerValidationServiceImpl(PathValidationService pathValidationService, EntrypointConnectorPluginService entrypointService, EndpointConnectorPluginService endpointService, CorsValidationService corsValidationService) {
        this.pathValidationService = pathValidationService;
        this.entrypointService = entrypointService;
        this.endpointService = endpointService;
        this.corsValidationService = corsValidationService;
    }

    @Override
    public List<Listener> validateAndSanitize(ExecutionContext executionContext, String apiId, List<Listener> listeners, List<EndpointGroup> endpointGroups) {
        if (listeners != null && !listeners.isEmpty()) {
            this.checkDuplicatedListeners(listeners);
            listeners.forEach(listener -> {
                switch (listener.getType()) {
                    case HTTP: {
                        this.validateAndSanitizeHttpListener(executionContext, apiId, (HttpListener)listener, endpointGroups);
                        break;
                    }
                    case SUBSCRIPTION: {
                        this.validateAndSanitizeSubscriptionListener((SubscriptionListener)listener, endpointGroups);
                        break;
                    }
                }
            });
        }
        return listeners;
    }

    private void checkDuplicatedListeners(List<Listener> listeners) {
        HashSet seenListeners = new HashSet();
        Set<String> duplicatedListeners = listeners.stream().filter(e -> !seenListeners.add(e.getType())).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
        if (!duplicatedListeners.isEmpty()) {
            throw new ListenersDuplicatedException(duplicatedListeners);
        }
    }

    private void validateAndSanitizeHttpListener(ExecutionContext executionContext, String apiId, HttpListener httpListener, List<EndpointGroup> endpointGroups) {
        httpListener.setPaths(this.pathValidationService.validateAndSanitizePaths(executionContext, apiId, httpListener.getPaths()));
        this.validatePathMappings(httpListener.getPathMappings());
        this.validateEntrypoints(httpListener.getType(), httpListener.getEntrypoints(), endpointGroups);
        httpListener.setCors(this.corsValidationService.validateAndSanitize(httpListener.getCors()));
    }

    private void validateAndSanitizeSubscriptionListener(SubscriptionListener subscriptionListener, List<EndpointGroup> endpointGroups) {
        this.validateEntrypoints(subscriptionListener.getType(), subscriptionListener.getEntrypoints(), endpointGroups);
    }

    private void validateEntrypoints(ListenerType type, List<Entrypoint> entrypoints, List<EndpointGroup> endpointGroups) {
        if (entrypoints == null || entrypoints.isEmpty()) {
            throw new ListenerEntrypointMissingException(type);
        }
        this.checkDuplicatedEntrypoints(type, entrypoints);
        entrypoints.forEach(entrypoint -> {
            if (entrypoint.getType() == null) {
                throw new ListenerEntrypointMissingTypeException();
            }
            ConnectorPluginEntity connectorPlugin = (ConnectorPluginEntity)this.entrypointService.findById(entrypoint.getType());
            this.checkEntrypointListenerType(type, connectorPlugin);
            this.checkEntrypointQos((Entrypoint)entrypoint, connectorPlugin);
            this.checkEntrypointDlq((Entrypoint)entrypoint, endpointGroups, connectorPlugin);
            this.checkEntrypointConfiguration((Entrypoint)entrypoint);
        });
    }

    private void checkEntrypointQos(Entrypoint entrypoint, ConnectorPluginEntity connectorPlugin) {
        if (connectorPlugin.getSupportedApiType() == ApiType.MESSAGE) {
            if (entrypoint.getQos() == null) {
                throw new ListenerEntrypointInvalidQosException(entrypoint.getType());
            }
            if (!(connectorPlugin.getSupportedApiType() != ApiType.MESSAGE || connectorPlugin.getSupportedQos() != null && connectorPlugin.getSupportedQos().contains(entrypoint.getQos()))) {
                throw new ListenerEntrypointUnsupportedQosException(entrypoint.getType(), entrypoint.getQos().getLabel());
            }
        }
    }

    private void checkEntrypointDlq(Entrypoint entrypoint, List<EndpointGroup> endpointGroups, ConnectorPluginEntity connectorPlugin) {
        Dlq dlq = entrypoint.getDlq();
        if (dlq != null) {
            if (!connectorPlugin.getAvailableFeatures().contains(ConnectorFeature.DLQ)) {
                throw new ListenerEntrypointUnsupportedDlqException(entrypoint.getType());
            }
            if (dlq.getEndpoint() == null || !this.checkEntrypointDlqEndpoint(endpointGroups, dlq)) {
                throw new ListenerEntrypointInvalidDlqException(entrypoint.getType(), dlq.getEndpoint());
            }
        }
    }

    private boolean checkEntrypointDlqEndpoint(List<EndpointGroup> endpointGroups, Dlq dlq) {
        return endpointGroups.stream().anyMatch(endpointGroup -> {
            ConnectorPluginEntity endpointConnectorPlugin = (ConnectorPluginEntity)this.endpointService.findById(endpointGroup.getType());
            return endpointConnectorPlugin != null && endpointConnectorPlugin.getSupportedModes().contains(ConnectorMode.PUBLISH) && (endpointGroup.getName().equals(dlq.getEndpoint()) || endpointGroup.getEndpoints().stream().anyMatch(endpoint -> endpoint.getName().equals(dlq.getEndpoint())));
        });
    }

    private void checkEntrypointConfiguration(Entrypoint entrypoint) {
        String entrypointConfiguration = null;
        if (entrypoint.getConfiguration() != null) {
            entrypointConfiguration = entrypoint.getConfiguration();
        }
        entrypoint.setConfiguration(this.entrypointService.validateConnectorConfiguration(entrypoint.getType(), entrypointConfiguration));
    }

    private void checkEntrypointListenerType(ListenerType type, ConnectorPluginEntity connectorPlugin) {
        if (connectorPlugin.getSupportedListenerType() != null && type != connectorPlugin.getSupportedListenerType()) {
            throw new ListenerEntrypointUnsupportedListenerTypeException(connectorPlugin.getId(), type.getLabel());
        }
    }

    private void checkDuplicatedEntrypoints(ListenerType type, List<Entrypoint> entrypoints) {
        if (entrypoints != null) {
            HashSet seenEntrypoints = new HashSet();
            Set<String> duplicatedEntrypoints = entrypoints.stream().filter(e -> !seenEntrypoints.add(e)).map(Entrypoint::getType).collect(Collectors.toSet());
            if (!duplicatedEntrypoints.isEmpty()) {
                throw new ListenerEntrypointDuplicatedException(type, duplicatedEntrypoints);
            }
        }
    }

    private void validatePathMappings(Set<String> pathMappings) {
        if (pathMappings != null) {
            pathMappings.forEach(pathMapping -> {
                try {
                    Pattern.compile(pathMapping);
                }
                catch (PatternSyntaxException pse) {
                    String errorMsg = String.format("An error occurs while trying to parse the path mapping '%s'", pathMapping);
                    log.error(errorMsg, (Throwable)pse);
                    throw new TechnicalManagementException(errorMsg, pse);
                }
            });
        }
    }
}

