/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class ApplicationAlertMaximumException
extends AbstractManagementException {
    private final String application;
    private final int maximum;

    public ApplicationAlertMaximumException(String application, int maximum) {
        this.application = application;
        this.maximum = maximum;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "The application [" + this.application + "] has reached the maximum of " + this.maximum + " alerts.";
    }

    @Override
    public String getTechnicalCode() {
        return "application.alert.maximum";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("application", this.application);
        parameters.put("maximum", String.valueOf(this.maximum));
        return parameters;
    }
}

