/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.gateway.reactive.api.connector.ConnectorFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.endpoint.EndpointConnectorPlugin;
import io.gravitee.plugin.endpoint.EndpointConnectorPluginManager;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.EndpointConnectorPluginService;
import io.gravitee.rest.api.service.v4.impl.AbstractConnectorPluginService;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component(value="EndpointConnectorPluginServiceImplV4")
public class EndpointConnectorPluginServiceImpl
extends AbstractConnectorPluginService<EndpointConnectorPlugin<?, ?>>
implements EndpointConnectorPluginService {
    public EndpointConnectorPluginServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<EndpointConnectorPlugin<?, ?>> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    protected ConnectorFactory<?> getConnectorFactory(String connectorId) {
        return ((EndpointConnectorPluginManager)this.pluginManager).getFactoryById(connectorId, true);
    }

    @Override
    public String getSharedConfigurationSchema(String connectorId) {
        try {
            this.logger.debug("Find endpoint shared configuration configuration schema by ID: {}", (Object)connectorId);
            return ((EndpointConnectorPluginManager)this.pluginManager).getSharedConfigurationSchema(connectorId, true);
        }
        catch (IOException ioex) {
            this.logger.error("An error occurs while trying to get endpoint shared configuration schema for plugin {}", (Object)connectorId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get endpoint shared configuration schema for plugin " + connectorId, ioex);
        }
    }

    @Override
    public String validateSharedConfiguration(ConnectorPluginEntity endpointConnector, String configuration) {
        return this.validatePluginConfigurationAgainstSchema(endpointConnector.getId(), configuration, this::getSharedConfigurationSchema);
    }
}

