/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.analytics.sampling.Sampling;
import io.gravitee.definition.model.v4.analytics.sampling.SamplingType;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.TimeBoundedCharSequence;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.exception.AnalyticsIncompatibleApiTypeConfigurationException;
import io.gravitee.rest.api.service.v4.exception.AnalyticsMessageSamplingValueInvalidException;
import io.gravitee.rest.api.service.v4.exception.LoggingInvalidConfigurationException;
import io.gravitee.rest.api.service.v4.validation.AnalyticsValidationService;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsValidationServiceImpl
extends TransactionalService
implements AnalyticsValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyticsValidationServiceImpl.class);
    private static final Pattern LOGGING_MAX_DURATION_PATTERN = Pattern.compile("(?<before>.*)\\#request.timestamp\\s*\\<\\=?\\s*(?<timestamp>\\d*)l(?<after>.*)");
    private static final String LOGGING_MAX_DURATION_CONDITION = "#request.timestamp <= %dl";
    private static final String LOGGING_DELIMITER_BASE = "\\s+(\\|\\||\\&\\&)\\s+";
    private static final Duration REGEX_TIMEOUT = Duration.ofSeconds(2L);
    private final ParameterService parameterService;

    public AnalyticsValidationServiceImpl(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public Analytics validateAndSanitize(ExecutionContext executionContext, ApiType type, Analytics analytics) {
        if (analytics == null) {
            Analytics defaultAnalytics = new Analytics();
            if (type == ApiType.MESSAGE) {
                AnalyticsValidationServiceImpl.setDefaultMessageSampling(defaultAnalytics);
            }
            return defaultAnalytics;
        }
        if (analytics.isEnabled()) {
            this.validateAndSanitizeSampling(type, analytics);
            this.validateAndSanitizeLogging(executionContext, type, analytics);
            return analytics;
        }
        return analytics;
    }

    private static void setDefaultMessageSampling(Analytics analytics) {
        Sampling countSampling = new Sampling();
        countSampling.setType(SamplingType.COUNT);
        countSampling.setValue("10");
        analytics.setMessageSampling(countSampling);
    }

    private void validateAndSanitizeSampling(ApiType type, Analytics analytics) {
        if (ApiType.PROXY.equals((Object)type) && analytics.getMessageSampling() != null) {
            throw new AnalyticsIncompatibleApiTypeConfigurationException(Map.of("analytics.messageSampling", "invalid"));
        }
        if (ApiType.MESSAGE.equals((Object)type)) {
            Sampling messageSampling;
            if (analytics.getMessageSampling() == null) {
                AnalyticsValidationServiceImpl.setDefaultMessageSampling(analytics);
            }
            if (!(messageSampling = analytics.getMessageSampling()).getType().validate(messageSampling.getValue())) {
                throw new AnalyticsMessageSamplingValueInvalidException(messageSampling);
            }
        }
    }

    private void validateAndSanitizeLogging(ExecutionContext executionContext, ApiType type, Analytics analytics) {
        io.gravitee.definition.model.v4.analytics.logging.Logging logging = analytics.getLogging();
        if (logging != null && logging.getMode().isEnabled()) {
            if (logging.getPhase() == null || logging.getContent() == null) {
                throw new LoggingInvalidConfigurationException();
            }
            if (type == ApiType.PROXY && (logging.getContent().isMessageHeaders() || logging.getContent().isMessagePayload() || logging.getContent().isMessageMetadata() || logging.getMessageCondition() != null) || type == ApiType.MESSAGE && logging.getContent().isPayload()) {
                throw new LoggingInvalidConfigurationException();
            }
            logging.setCondition(this.computeMaxDurationCondition(executionContext, logging.getCondition()));
        }
        analytics.setLogging(logging);
    }

    @Override
    public Logging validateAndSanitize(ExecutionContext executionContext, Logging logging) {
        if (logging != null && !LoggingMode.NONE.equals((Object)logging.getMode())) {
            logging.setCondition(this.computeMaxDurationCondition(executionContext, logging.getCondition()));
        }
        return logging;
    }

    private String computeMaxDurationCondition(ExecutionContext executionContext, String existingCondition) {
        block6: {
            Optional optionalMaxDuration = this.parameterService.findAll(executionContext, Key.LOGGING_DEFAULT_MAX_DURATION, Long::valueOf, ParameterReferenceType.ORGANIZATION).stream().findFirst();
            if (optionalMaxDuration.isPresent() && (Long)optionalMaxDuration.get() > 0L) {
                long maxEndDate = Instant.now().toEpochMilli() + (Long)optionalMaxDuration.get();
                if (existingCondition == null || existingCondition.isEmpty()) {
                    return "{" + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + "}";
                }
                String conditionWithoutBraces = existingCondition.trim().replaceAll("\\{", "").replaceAll("\\}", "");
                Matcher matcher = LOGGING_MAX_DURATION_PATTERN.matcher(new TimeBoundedCharSequence(conditionWithoutBraces, REGEX_TIMEOUT));
                if (matcher.matches()) {
                    String currentDurationAsStr = matcher.group("timestamp");
                    String before = this.formatExpression(matcher, "before");
                    String after = this.formatExpression(matcher, "after");
                    try {
                        long currentDuration = Long.parseLong(currentDurationAsStr);
                        if (currentDuration > maxEndDate || !before.isEmpty() || !after.isEmpty()) {
                            return "{" + before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after + "}";
                        }
                        break block6;
                    }
                    catch (NumberFormatException nfe) {
                        log.error("Wrong format of the logging condition. Add the default one", (Throwable)nfe);
                        return "{" + before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after + "}";
                    }
                }
                return "{" + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + " && (" + conditionWithoutBraces + ")}";
            }
        }
        return existingCondition;
    }

    private String formatExpression(Matcher matcher, String group) {
        Object expression;
        String matchedExpression = Optional.ofNullable(matcher.group(group)).orElse("");
        boolean expressionBlank = "".equals(matchedExpression);
        boolean after = "after".equals(group);
        if (after) {
            if (matchedExpression.startsWith(" && (") && matchedExpression.endsWith(")")) {
                matchedExpression = matchedExpression.substring(5, matchedExpression.length() - 1);
            }
            expression = expressionBlank ? "" : " && (" + matchedExpression + ")";
            expression = ((String)expression).replaceAll("\\(\\s+(\\|\\||\\&\\&)\\s+", "\\(");
        } else {
            if (matchedExpression.startsWith("(") && matchedExpression.endsWith(") && ")) {
                matchedExpression = matchedExpression.substring(1, matchedExpression.length() - 5);
            }
            expression = expressionBlank ? "" : "(" + matchedExpression + ") && ";
            expression = ((String)expression).replaceAll("\\s+(\\|\\||\\&\\&)\\s+\\)", "\\)");
        }
        return expression;
    }
}

