/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HttpClientServiceImpl
extends AbstractService
implements HttpClientService {
    private final Logger LOGGER = LoggerFactory.getLogger(HttpClientServiceImpl.class);
    private static final String HTTPS_SCHEME = "https";
    @Value(value="${httpClient.timeout:10000}")
    private int httpClientTimeout;
    @Value(value="${httpClient.proxy.type:HTTP}")
    private String httpClientProxyType;
    @Value(value="${httpClient.proxy.http.host:#{systemProperties['http.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpHost;
    @Value(value="${httpClient.proxy.http.port:#{systemProperties['http.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpPort;
    @Value(value="${httpClient.proxy.http.username:#{null}}")
    private String httpClientProxyHttpUsername;
    @Value(value="${httpClient.proxy.http.password:#{null}}")
    private String httpClientProxyHttpPassword;
    @Value(value="${httpClient.proxy.https.host:#{systemProperties['https.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpsHost;
    @Value(value="${httpClient.proxy.https.port:#{systemProperties['https.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpsPort;
    @Value(value="${httpClient.proxy.https.username:#{null}}")
    private String httpClientProxyHttpsUsername;
    @Value(value="${httpClient.proxy.https.password:#{null}}")
    private String httpClientProxyHttpsPassword;
    @Value(value="#{systemProperties['httpClient.proxy'] == null ? false : true }")
    private boolean isProxyConfigured;
    @Autowired
    private Vertx vertx;

    @Override
    public HttpClient createHttpClient(String uriScheme, Boolean useSystemProxy) {
        boolean ssl = HTTPS_SCHEME.equalsIgnoreCase(uriScheme);
        HttpClientOptions options = new HttpClientOptions().setSsl(ssl).setTrustAll(true).setVerifyHost(false).setMaxPoolSize(1).setKeepAlive(false).setTcpKeepAlive(false).setConnectTimeout(this.httpClientTimeout);
        if (useSystemProxy == Boolean.TRUE || useSystemProxy == null && this.isProxyConfigured) {
            ProxyOptions proxyOptions = new ProxyOptions();
            proxyOptions.setType(ProxyType.valueOf((String)this.httpClientProxyType));
            if (HTTPS_SCHEME.equals(uriScheme)) {
                proxyOptions.setHost(this.httpClientProxyHttpsHost);
                proxyOptions.setPort(this.httpClientProxyHttpsPort);
                proxyOptions.setUsername(this.httpClientProxyHttpsUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpsPassword);
            } else {
                proxyOptions.setHost(this.httpClientProxyHttpHost);
                proxyOptions.setPort(this.httpClientProxyHttpPort);
                proxyOptions.setUsername(this.httpClientProxyHttpUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpPassword);
            }
            options.setProxyOptions(proxyOptions);
        }
        return this.vertx.createHttpClient(options);
    }

    @Override
    public Buffer request(HttpMethod method, final String uri, Map<String, String> headers, final String body, Boolean useSystemProxy) {
        if (uri == null || uri.isEmpty()) {
            this.LOGGER.error("HttpClient configuration is empty");
            return null;
        }
        final Promise promise = Promise.promise();
        URI requestUri = URI.create(uri);
        final HttpClient httpClient = this.createHttpClient(requestUri.getScheme(), useSystemProxy);
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : (HTTPS_SCHEME.equals(requestUri.getScheme()) ? 443 : 80);
        RequestOptions options = new RequestOptions().setMethod(io.vertx.core.http.HttpMethod.valueOf((String)method.name())).setHost(requestUri.getHost()).setPort(Integer.valueOf(port)).setURI(requestUri.getPath()).setTimeout((long)this.httpClientTimeout);
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((RequestOptions)options).putHeader(arg_0, arg_1));
        }
        options.putHeader("X-Gravitee-Request-Id", UuidString.generateRandom().trim());
        if (body != null) {
            if (!options.getHeaders().contains("Content-Type")) {
                options.putHeader("Content-Type", "application/json");
            }
            options.putHeader("Content-Length", Integer.toString(body.getBytes().length));
        }
        Future requestFuture = httpClient.request(options);
        requestFuture.onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                promise.fail(throwable);
                httpClient.close();
            }
        }).onSuccess((Handler)new Handler<HttpClientRequest>(){

            public void handle(HttpClientRequest request) {
                request.response((Handler)new Handler<AsyncResult<HttpClientResponse>>(){

                    public void handle(AsyncResult<HttpClientResponse> asyncResponse) {
                        if (asyncResponse.failed()) {
                            promise.fail(asyncResponse.cause());
                            httpClient.close();
                        } else {
                            HttpClientResponse response = (HttpClientResponse)asyncResponse.result();
                            HttpClientServiceImpl.this.LOGGER.debug("Web response status code : {}", (Object)response.statusCode());
                            if (response.statusCode() >= 200 && response.statusCode() <= 299) {
                                response.bodyHandler(buffer -> {
                                    promise.complete(buffer);
                                    httpClient.close();
                                });
                            } else {
                                response.bodyHandler(buffer -> promise.fail((Throwable)new TechnicalManagementException(" Error on url '" + uri + "'. Status code: " + response.statusCode() + ". Message: " + buffer.toString(), null)));
                            }
                        }
                    }
                }).exceptionHandler((Handler)new Handler<Throwable>(){

                    public void handle(Throwable throwable) {
                        promise.fail(throwable);
                        httpClient.close();
                    }
                });
                if (body != null) {
                    request.end(body);
                } else {
                    request.end();
                }
            }
        });
        try {
            return (Buffer)promise.future().toCompletionStage().toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new TechnicalManagementException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TechnicalManagementException(e.getMessage(), e);
        }
    }
}

