/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.EmailNotification;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.TimeBoundedCharSequence;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.spring.GraviteeJavaMailManager;
import jakarta.activation.MimetypesFileTypeMap;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class EmailServiceImpl
extends TransactionalService
implements EmailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailServiceImpl.class);
    private static final Duration REGEX_TIMEOUT = Duration.ofSeconds(2L);
    private final GraviteeJavaMailManager mailManager;
    private final NotificationTemplateService notificationTemplateService;
    private final ParameterService parameterService;
    private final String templatesPath;

    public EmailServiceImpl(GraviteeJavaMailManager mailManager, NotificationTemplateService notificationTemplateService, ParameterService parameterService, @Value(value="${templates.path:${gravitee.home}/templates}") String templatesPath) {
        this.mailManager = mailManager;
        this.notificationTemplateService = notificationTemplateService;
        this.parameterService = parameterService;
        this.templatesPath = templatesPath;
    }

    @Override
    public void sendEmailNotification(ExecutionContext executionContext, EmailNotification emailNotification) {
        GraviteeContext.ReferenceContext context = executionContext.getReferenceContext();
        this.sendEmailNotification(executionContext, emailNotification, context.getReferenceId(), ParameterReferenceType.valueOf((String)context.getReferenceType().name()));
    }

    private void sendEmailNotification(ExecutionContext executionContext, EmailNotification emailNotification, String referenceId, ParameterReferenceType referenceType) {
        Map<Key, String> mailParameters = this.getMailSenderConfiguration(executionContext, referenceId, referenceType);
        if (Boolean.parseBoolean(mailParameters.get(Key.EMAIL_ENABLED)) && emailNotification.getTo() != null && emailNotification.getTo().length > 0) {
            try {
                JavaMailSender mailSender = this.mailManager.getOrCreateMailSender(executionContext, referenceId, referenceType);
                MimeMessageHelper mailMessage = new MimeMessageHelper(mailSender.createMimeMessage(), true, StandardCharsets.UTF_8.name());
                String emailSubject = this.notificationTemplateService.resolveTemplateWithParam(executionContext.getOrganizationId(), emailNotification.getTemplate() + ".EMAIL.TITLE", emailNotification.getParams());
                String content = this.notificationTemplateService.resolveTemplateWithParam(executionContext.getOrganizationId(), emailNotification.getTemplate() + ".EMAIL", emailNotification.getParams());
                content = content.replaceAll("&lt;br /&gt;", "<br />");
                String from = Objects.isNull(emailNotification.getFrom()) || emailNotification.getFrom().isEmpty() ? mailParameters.get(Key.EMAIL_FROM) : emailNotification.getFrom();
                InternetAddress configuredFrom = new InternetAddress(from);
                if (StringUtils.isEmpty((CharSequence)configuredFrom.getPersonal())) {
                    if (StringUtils.isEmpty((CharSequence)emailNotification.getFromName())) {
                        mailMessage.setFrom(from);
                    } else {
                        mailMessage.setFrom(from, emailNotification.getFromName());
                    }
                } else {
                    mailMessage.setFrom(configuredFrom);
                }
                String sender = emailNotification.getFrom();
                if (!StringUtils.isEmpty((CharSequence)emailNotification.getReplyTo())) {
                    mailMessage.setReplyTo(emailNotification.getReplyTo());
                    sender = emailNotification.getReplyTo();
                }
                if (Arrays.equals(DEFAULT_MAIL_TO, emailNotification.getTo())) {
                    mailMessage.setTo(mailParameters.get(Key.EMAIL_FROM));
                } else {
                    mailMessage.setTo(emailNotification.getTo());
                }
                if (emailNotification.isCopyToSender() && sender != null) {
                    mailMessage.setBcc(sender);
                }
                if (emailNotification.getBcc() != null && emailNotification.getBcc().length > 0) {
                    mailMessage.setBcc(emailNotification.getBcc());
                }
                mailMessage.setSubject(String.format(mailParameters.get(Key.EMAIL_SUBJECT), emailSubject));
                String html = this.addResourcesInMessage(mailMessage, content);
                LOGGER.debug("Sending an email to: {}\nSubject: {}\nMessage: {}", new Object[]{emailNotification.getTo(), emailSubject, html});
                mailSender.send(mailMessage.getMimeMessage());
            }
            catch (Exception ex) {
                LOGGER.error("Error while sending email notification", (Throwable)ex);
                throw new TechnicalManagementException("Error while sending email notification", ex);
            }
        }
    }

    @Override
    @Async
    public void sendAsyncEmailNotification(ExecutionContext executionContext, EmailNotification emailNotification) {
        this.sendEmailNotification(executionContext, emailNotification, executionContext.getReferenceContext().getReferenceId(), ParameterReferenceType.valueOf((String)executionContext.getReferenceContext().getReferenceType().name()));
    }

    private String addResourcesInMessage(MimeMessageHelper mailMessage, String htmlText) throws Exception {
        Document document = Jsoup.parse((String)htmlText);
        ArrayList resources = new ArrayList();
        Elements imageElements = document.getElementsByTag("img");
        resources.addAll(imageElements.stream().filter(imageElement -> imageElement.hasAttr("src")).filter(imageElement -> !imageElement.attr("src").startsWith("http")).map(imageElement -> {
            String src = imageElement.attr("src");
            imageElement.attr("src", "cid:" + src);
            return src;
        }).collect(Collectors.toList()));
        String html = document.html();
        mailMessage.setText(html, true);
        for (String res : resources) {
            if (res.startsWith("data:image/")) {
                String value = res.replaceFirst("^data:image/[^;]*;base64,?", "");
                byte[] bytes = Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
                mailMessage.addInline(res, (InputStreamSource)new ByteArrayResource(bytes), EmailServiceImpl.extractMimeType(res));
                continue;
            }
            File file = new File(this.templatesPath, res);
            if (file.getCanonicalPath().startsWith(this.templatesPath)) {
                FileSystemResource templateResource = new FileSystemResource(file);
                mailMessage.addInline(res, (InputStreamSource)templateResource, this.getContentTypeByFileName(res));
                continue;
            }
            LOGGER.warn("Resource path invalid : {}", (Object)file.getPath());
        }
        return html;
    }

    private String getContentTypeByFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        return MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
    }

    private static String extractMimeType(String encoded) {
        Pattern mime = Pattern.compile("^data:([a-zA-Z0-9]+/[a-zA-Z0-9]+).*,.*");
        Matcher matcher = mime.matcher(new TimeBoundedCharSequence(encoded, REGEX_TIMEOUT));
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1).toLowerCase();
    }

    private Map<Key, String> getMailSenderConfiguration(ExecutionContext executionContext, String referenceId, ParameterReferenceType referenceType) {
        return this.parameterService.findAll(Arrays.asList(Key.EMAIL_ENABLED, Key.EMAIL_SUBJECT, Key.EMAIL_FROM), referenceId, referenceType, executionContext).entrySet().stream().collect(Collectors.toMap(e -> Key.findByKey((String)((String)e.getKey())), e -> ((List)e.getValue()).isEmpty() ? "" : (String)((List)e.getValue()).get(0)));
    }
}

