/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.commands;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.organization.OrganizationCommand;
import io.gravitee.cockpit.api.command.organization.OrganizationPayload;
import io.gravitee.cockpit.api.command.organization.OrganizationReply;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.OrganizationService;
import io.reactivex.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrganizationCommandHandler
implements CommandHandler<OrganizationCommand, OrganizationReply> {
    private final Logger logger = LoggerFactory.getLogger(OrganizationCommandHandler.class);
    private final OrganizationService organizationService;

    public OrganizationCommandHandler(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public Command.Type handleType() {
        return Command.Type.ORGANIZATION_COMMAND;
    }

    public Single<OrganizationReply> handle(OrganizationCommand command) {
        OrganizationPayload organizationPayload = (OrganizationPayload)command.getPayload();
        try {
            UpdateOrganizationEntity newOrganization = new UpdateOrganizationEntity();
            newOrganization.setHrids(organizationPayload.getHrids());
            newOrganization.setName(organizationPayload.getName());
            newOrganization.setDescription(organizationPayload.getDescription());
            newOrganization.setDomainRestrictions(organizationPayload.getDomainRestrictions());
            OrganizationEntity organization = this.organizationService.createOrUpdate(organizationPayload.getId(), newOrganization);
            this.logger.info("Organization [{}] handled with id [{}].", (Object)organization.getName(), (Object)organization.getId());
            return Single.just((Object)new OrganizationReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception e) {
            this.logger.error("Error occurred when handling organization [{}] with id [{}].", new Object[]{organizationPayload.getName(), organizationPayload.getId(), e});
            return Single.just((Object)new OrganizationReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

