/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.commands;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.membership.MembershipCommand;
import io.gravitee.cockpit.api.command.membership.MembershipPayload;
import io.gravitee.cockpit.api.command.membership.MembershipReply;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.reactivex.Single;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MembershipCommandHandler
implements CommandHandler<MembershipCommand, MembershipReply> {
    private final Logger logger = LoggerFactory.getLogger(MembershipCommandHandler.class);
    private final UserService userService;
    private final RoleService roleService;
    private final MembershipService membershipService;

    public MembershipCommandHandler(UserService userService, RoleService roleService, MembershipService membershipService) {
        this.userService = userService;
        this.roleService = roleService;
        this.membershipService = membershipService;
    }

    public Command.Type handleType() {
        return Command.Type.MEMBERSHIP_COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Single<MembershipReply> handle(MembershipCommand command) {
        MembershipPayload membershipPayload = (MembershipPayload)command.getPayload();
        GraviteeContext.setCurrentOrganization(membershipPayload.getOrganizationId());
        try {
            MembershipReferenceType membershipReferenceType;
            RoleScope roleScope;
            try {
                roleScope = RoleScope.valueOf((String)membershipPayload.getReferenceType());
                membershipReferenceType = MembershipReferenceType.valueOf((String)membershipPayload.getReferenceType());
            }
            catch (Exception e) {
                this.logger.error("Invalid referenceType [{}].", (Object)membershipPayload.getReferenceType());
                Single single = Single.just((Object)new MembershipReply(command.getId(), CommandStatus.ERROR));
                GraviteeContext.cleanContext();
                return single;
            }
            UserEntity userEntity = this.userService.findBySource("cockpit", membershipPayload.getUserId(), false);
            RoleEntity roleEntity = this.findRole(roleScope, membershipPayload.getRole());
            MembershipService.MembershipReference membershipReference = new MembershipService.MembershipReference(membershipReferenceType, membershipPayload.getReferenceId());
            MembershipService.MembershipMember membershipMember = new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER);
            MembershipService.MembershipRole membershipRole = new MembershipService.MembershipRole(roleEntity.getScope(), roleEntity.getName());
            this.membershipService.updateRolesToMemberOnReference(membershipReference, membershipMember, Collections.singletonList(membershipRole), "cockpit", false);
            this.logger.info("Role [{}] assigned on {} [{}] for user [{}] and organization [{}].", new Object[]{membershipPayload.getRole(), membershipPayload.getReferenceType(), membershipPayload.getReferenceId(), userEntity.getId(), membershipPayload.getOrganizationId()});
            Single single = Single.just((Object)new MembershipReply(command.getId(), CommandStatus.SUCCEEDED));
            return single;
        }
        catch (Exception e) {
            this.logger.error("Error occurred when trying to assign role [{}] on {} [{}] for cockpit user [{}] and organization [{}].", new Object[]{membershipPayload.getRole(), membershipPayload.getReferenceType(), membershipPayload.getReferenceId(), membershipPayload.getUserId(), membershipPayload.getOrganizationId(), e});
            Single single = Single.just((Object)new MembershipReply(command.getId(), CommandStatus.ERROR));
            return single;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }

    private RoleEntity findRole(RoleScope roleScope, String roleName) {
        String mappedRoleName = roleName.replace(roleScope.name() + "_", "").replace("PRIMARY_OWNER", "ADMIN").replace("OWNER", "ADMIN");
        Optional<RoleEntity> role = this.roleService.findByScopeAndName(roleScope, mappedRoleName);
        if (!role.isPresent()) {
            throw new RoleNotFoundException(roleScope, mappedRoleName);
        }
        return role.get();
    }
}

