/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.commands;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.goodbye.GoodbyeCommand;
import io.gravitee.cockpit.api.command.goodbye.GoodbyeReply;
import io.gravitee.rest.api.service.InstallationService;
import io.reactivex.Single;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GoodbyeCommandHandler
implements CommandHandler<GoodbyeCommand, GoodbyeReply> {
    static final String DELETED_STATUS = "DELETED";
    private final Logger logger = LoggerFactory.getLogger(GoodbyeCommandHandler.class);
    private final InstallationService installationService;

    public GoodbyeCommandHandler(InstallationService installationService) {
        this.installationService = installationService;
    }

    public Command.Type handleType() {
        return Command.Type.GOODBYE_COMMAND;
    }

    public Single<GoodbyeReply> handle(GoodbyeCommand command) {
        Map additionalInformation = this.installationService.getOrInitialize().getAdditionalInformation();
        additionalInformation.put("COCKPIT_INSTALLATION_STATUS", DELETED_STATUS);
        try {
            this.installationService.setAdditionalInformation(additionalInformation);
            this.logger.info("Installation status is [{}].", (Object)DELETED_STATUS);
            return Single.just((Object)new GoodbyeReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception ex) {
            this.logger.info("Error occurred when deleting installation.", (Throwable)ex);
            return Single.just((Object)new GoodbyeReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

