/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApplicationCriteria;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.application.OAuthClientSettings;
import io.gravitee.rest.api.model.application.SimpleApplicationSettings;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypeEntity;
import io.gravitee.rest.api.model.configuration.application.registration.ClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationAlertService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.configuration.application.ApplicationTypeService;
import io.gravitee.rest.api.service.configuration.application.ClientRegistrationService;
import io.gravitee.rest.api.service.exceptions.ApplicationActiveException;
import io.gravitee.rest.api.service.exceptions.ApplicationArchivedException;
import io.gravitee.rest.api.service.exceptions.ApplicationGrantTypesNotAllowedException;
import io.gravitee.rest.api.service.exceptions.ApplicationGrantTypesNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationRedirectUrisNotFound;
import io.gravitee.rest.api.service.exceptions.ApplicationRenewClientSecretException;
import io.gravitee.rest.api.service.exceptions.ClientIdAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.InvalidApplicationTypeException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotPausedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.register.ClientRegistrationResponse;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.HookScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationServiceImpl
extends AbstractService
implements ApplicationService {
    private final Logger LOGGER = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private PortalNotificationConfigService portalNotificationConfigService;
    @Autowired
    private ClientRegistrationService clientRegistrationService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApplicationAlertService applicationAlertService;
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ApplicationEntity findById(String applicationId) {
        try {
            this.LOGGER.debug("Find application by ID: {}", (Object)applicationId);
            Optional<Application> applicationOptional = this.applicationRepository.findById((Object)applicationId);
            if (GraviteeContext.getCurrentEnvironment() != null) {
                applicationOptional = applicationOptional.filter(result -> result.getEnvironmentId().equals(GraviteeContext.getCurrentEnvironment()));
            }
            if (applicationOptional.isPresent()) {
                Application application = applicationOptional.get();
                MembershipEntity primaryOwnerMemberEntity = this.membershipService.getPrimaryOwner(MembershipReferenceType.APPLICATION, application.getId());
                if (primaryOwnerMemberEntity == null) {
                    if (!ApplicationStatus.ARCHIVED.equals((Object)application.getStatus())) {
                        this.LOGGER.error("The Application {} doesn't have any primary owner.", (Object)applicationId);
                    }
                    return this.convert(application, null);
                }
                return this.convert(application, this.userService.findById(primaryOwnerMemberEntity.getMemberId()));
            }
            throw new ApplicationNotFoundException(applicationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an application using its ID {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an application using its ID " + applicationId, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByIds(List<String> applicationIds) {
        try {
            this.LOGGER.debug("Find application by IDs: {}", applicationIds);
            Set<Application> applications = this.applicationRepository.findByIds(applicationIds).stream().filter(app -> ApplicationStatus.ACTIVE.equals((Object)app.getStatus())).filter(app -> app.getEnvironmentId().equals(GraviteeContext.getCurrentEnvironment())).collect(Collectors.toSet());
            if (applications.isEmpty()) {
                return Collections.emptySet();
            }
            return this.convertToList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications by ids {}", applicationIds, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications by ids {}" + applicationIds, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByUser(String username) {
        try {
            this.LOGGER.debug("Find applications for user {}", (Object)username);
            Set appIds = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, username, MembershipReferenceType.APPLICATION).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
            List<String> groupIds = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, username, MembershipReferenceType.GROUP).stream().filter(m -> m.getRoleId() != null && this.roleService.findById(m.getRoleId()).getScope().equals((Object)RoleScope.APPLICATION)).map(MembershipEntity::getReferenceId).collect(Collectors.toList());
            appIds.addAll(this.findByGroups(groupIds).stream().map(ApplicationListItem::getId).collect(Collectors.toSet()));
            Set<Application> applications = this.applicationRepository.findByIds(new ArrayList(appIds)).stream().filter(app -> ApplicationStatus.ACTIVE.equals((Object)app.getStatus())).filter(app -> app.getEnvironmentId().equals(GraviteeContext.getCurrentEnvironment())).collect(Collectors.toSet());
            if (applications.isEmpty()) {
                return Collections.emptySet();
            }
            return this.convertToList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for user {}", (Object)username, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for user " + username, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByNameAndStatus(String userName, String name, String status) {
        this.LOGGER.debug("Find applications by name {} and status {}", (Object)name, (Object)status);
        try {
            if (name == null || name.trim().isEmpty()) {
                return Collections.emptySet();
            }
            Set<String> appIds = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userName, MembershipReferenceType.APPLICATION).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
            List<String> groupIds = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userName, MembershipReferenceType.GROUP).stream().filter(m -> m.getRoleId() != null && this.roleService.findById(m.getRoleId()).getScope().equals((Object)RoleScope.APPLICATION)).map(MembershipEntity::getReferenceId).collect(Collectors.toList());
            appIds.addAll(this.findByGroups(groupIds).stream().map(ApplicationListItem::getId).collect(Collectors.toSet()));
            ApplicationCriteria criteria = new ApplicationCriteria.Builder().status(ApplicationStatus.valueOf((String)status)).name(name.trim()).environmentIds(Collections.singletonList(GraviteeContext.getCurrentEnvironment())).ids(appIds.toArray(new String[0])).build();
            Page applications = this.applicationRepository.search(criteria, null);
            return ApplicationStatus.ACTIVE.equals((Object)status) ? this.convertToList(new HashSet<Application>(applications.getContent())) : this.convertToSimpleList(new HashSet<Application>(applications.getContent()));
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for name {}", (Object)name, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for name " + name, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByOrganization(String organizationId) {
        this.LOGGER.debug("Find applications by organization {} ", (Object)organizationId);
        try {
            if (organizationId == null || organizationId.trim().isEmpty()) {
                return Collections.emptySet();
            }
            List environmentIds = this.environmentService.findByOrganization(organizationId).stream().map(EnvironmentEntity::getId).collect(Collectors.toList());
            ApplicationCriteria criteria = new ApplicationCriteria.Builder().environmentIds(environmentIds).build();
            Page applications = this.applicationRepository.search(criteria, null);
            return this.convertToSimpleList(new HashSet<Application>(applications.getContent()));
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for organization {}", (Object)organizationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for organization {}" + organizationId, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByGroups(List<String> groupIds) {
        return this.findByGroupsAndStatus(groupIds, ApplicationStatus.ACTIVE.name());
    }

    @Override
    public Set<ApplicationListItem> findByGroupsAndStatus(List<String> groupIds, String status) {
        this.LOGGER.debug("Find applications by groups {}", groupIds);
        try {
            ApplicationStatus requestedStatus = ApplicationStatus.valueOf((String)status.toUpperCase());
            Set applications = this.applicationRepository.findByGroups(groupIds, new ApplicationStatus[]{ApplicationStatus.valueOf((String)status.toUpperCase())});
            return ApplicationStatus.ACTIVE.equals((Object)requestedStatus) ? this.convertToList(applications) : this.convertToSimpleList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for groups {}", groupIds, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for groups " + groupIds, ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findAll() {
        try {
            this.LOGGER.debug("Find all applications");
            Set applications = this.applicationRepository.findAllByEnvironment(GraviteeContext.getCurrentEnvironment(), new ApplicationStatus[]{ApplicationStatus.ACTIVE});
            if (applications == null || applications.isEmpty()) {
                return Collections.emptySet();
            }
            return this.convertToList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all applications", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all applications", ex);
        }
    }

    @Override
    public Set<ApplicationListItem> findByStatus(String status) {
        try {
            this.LOGGER.debug("Find all applications");
            ApplicationStatus requestedStatus = ApplicationStatus.valueOf((String)status.toUpperCase());
            Set applications = this.applicationRepository.findAllByEnvironment(GraviteeContext.getCurrentEnvironment(), new ApplicationStatus[]{requestedStatus});
            if (applications == null || applications.isEmpty()) {
                return Collections.emptySet();
            }
            return ApplicationStatus.ACTIVE.equals((Object)requestedStatus) ? this.convertToList(applications) : this.convertToSimpleList(applications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all applications", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all applications", ex);
        }
    }

    @Override
    public ApplicationEntity create(NewApplicationEntity newApplicationEntity, String userId) {
        return this.create(newApplicationEntity, userId, GraviteeContext.getCurrentEnvironment());
    }

    @Override
    public ApplicationEntity create(NewApplicationEntity newApplicationEntity, String userId, String environmentId) {
        this.LOGGER.debug("Create {} for user {}", (Object)newApplicationEntity, (Object)userId);
        if (newApplicationEntity.getSettings().getApp() != null && newApplicationEntity.getSettings().getoAuthClient() != null) {
            throw new InvalidApplicationTypeException();
        }
        if (newApplicationEntity.getSettings().getApp() == null && newApplicationEntity.getSettings().getoAuthClient() == null) {
            throw new InvalidApplicationTypeException();
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (newApplicationEntity.getSettings().getApp() != null) {
            if (this.isClientRegistrationEnabled(environmentId) && !this.isApplicationTypeAllowed("simple", environmentId)) {
                throw new IllegalStateException("Application type 'simple' is not allowed");
            }
            String clientId = newApplicationEntity.getSettings().getApp().getClientId();
            if (clientId != null && !clientId.trim().isEmpty()) {
                this.LOGGER.debug("Check that client_id is unique among all applications");
                try {
                    Set applications = this.applicationRepository.findAllByEnvironment(environmentId, new ApplicationStatus[]{ApplicationStatus.ACTIVE});
                    boolean alreadyExistingApp = applications.stream().anyMatch(app -> app.getMetadata() != null && clientId.equals(app.getMetadata().get("client_id")));
                    if (alreadyExistingApp) {
                        this.LOGGER.error("An application already exists with the same client_id");
                        throw new ClientIdAlreadyExistsException(clientId);
                    }
                }
                catch (TechnicalException ex) {
                    this.LOGGER.error("An error occurs while trying to create {} for user {}", new Object[]{newApplicationEntity, userId, ex});
                    throw new TechnicalManagementException("An error occurs while trying create " + newApplicationEntity + " for user " + userId, ex);
                }
            }
        } else {
            this.checkClientRegistrationEnabled(environmentId);
            String appType = newApplicationEntity.getSettings().getoAuthClient().getApplicationType();
            if (!this.isApplicationTypeAllowed(appType, environmentId)) {
                throw new IllegalStateException("Application type '" + appType + "' is not allowed");
            }
            this.checkClientSettings(newApplicationEntity.getSettings().getoAuthClient());
            ClientRegistrationResponse registrationResponse = this.clientRegistrationService.register(newApplicationEntity);
            try {
                metadata.put("client_id", registrationResponse.getClientId());
                metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        if (newApplicationEntity.getGroups() != null && !newApplicationEntity.getGroups().isEmpty()) {
            this.groupService.findByIds(newApplicationEntity.getGroups());
        }
        Application application = ApplicationServiceImpl.convert(newApplicationEntity);
        application.setId(RandomString.generate());
        application.setStatus(ApplicationStatus.ACTIVE);
        metadata.forEach((key, value) -> application.getMetadata().put(key, value));
        Set defaultGroups = this.groupService.findByEvent(GroupEvent.APPLICATION_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
        if (!defaultGroups.isEmpty() && application.getGroups() == null) {
            application.setGroups(defaultGroups);
        } else if (!defaultGroups.isEmpty()) {
            application.getGroups().addAll(defaultGroups);
        }
        application.setCreatedAt(new Date());
        application.setUpdatedAt(application.getCreatedAt());
        return this.createApplicationForEnvironment(userId, application, environmentId);
    }

    @NotNull
    private ApplicationEntity createApplicationForEnvironment(String userId, Application application, String environmentId) {
        try {
            application.setEnvironmentId(environmentId);
            Application createdApplication = (Application)this.applicationRepository.create((Object)application);
            this.auditService.createApplicationAuditLog(createdApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_CREATED, createdApplication.getCreatedAt(), null, createdApplication);
            this.membershipService.addRoleToMemberOnReference(new MembershipService.MembershipReference(MembershipReferenceType.APPLICATION, createdApplication.getId()), new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.APPLICATION, SystemRole.PRIMARY_OWNER.name()));
            UserEntity userEntity = this.userService.findById(userId);
            if (userEntity.getEmail() != null && !userEntity.getEmail().isEmpty()) {
                GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
                notificationConfigEntity.setName("Default Mail Notifications");
                notificationConfigEntity.setReferenceType(HookScope.APPLICATION.name());
                notificationConfigEntity.setReferenceId(createdApplication.getId());
                notificationConfigEntity.setHooks(Arrays.stream(ApplicationHook.values()).map(Enum::name).collect(Collectors.toList()));
                notificationConfigEntity.setNotifier("default-email");
                notificationConfigEntity.setConfig(userEntity.getEmail());
                this.genericNotificationConfigService.create(notificationConfigEntity);
            }
            return this.convert(createdApplication, userEntity);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for user {} in environment {}", new Object[]{application, userId, environmentId, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + application + " for user " + userId + " in environment " + environmentId, ex);
        }
    }

    private void checkClientSettings(OAuthClientSettings oAuthClientSettings) {
        if (oAuthClientSettings.getGrantTypes() == null || oAuthClientSettings.getGrantTypes().isEmpty()) {
            throw new ApplicationGrantTypesNotFoundException();
        }
        ApplicationTypeEntity applicationType = this.applicationTypeService.getApplicationType(oAuthClientSettings.getApplicationType());
        List targetGrantTypes = oAuthClientSettings.getGrantTypes();
        List allowedGrantTypes = applicationType.getAllowed_grant_types().stream().map(applicationGrantTypeEntity -> applicationGrantTypeEntity.getType()).collect(Collectors.toList());
        if (!allowedGrantTypes.containsAll(targetGrantTypes)) {
            throw new ApplicationGrantTypesNotAllowedException(oAuthClientSettings.getApplicationType(), targetGrantTypes);
        }
        List redirectUris = oAuthClientSettings.getRedirectUris();
        if (applicationType.getRequires_redirect_uris().booleanValue() && (redirectUris == null || redirectUris.isEmpty())) {
            throw new ApplicationRedirectUrisNotFound();
        }
        List responseTypes = applicationType.getAllowed_grant_types().stream().filter(applicationGrantTypeEntity -> targetGrantTypes.contains(applicationGrantTypeEntity.getType())).map(applicationGrantTypeEntity -> applicationGrantTypeEntity.getResponse_types()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        oAuthClientSettings.setResponseTypes(responseTypes);
    }

    @Override
    public ApplicationEntity update(String applicationId, UpdateApplicationEntity updateApplicationEntity) {
        try {
            Optional optApplicationToUpdate;
            this.LOGGER.debug("Update application {}", (Object)applicationId);
            if (updateApplicationEntity.getGroups() != null && !updateApplicationEntity.getGroups().isEmpty()) {
                this.groupService.findByIds(updateApplicationEntity.getGroups());
            }
            if (!(optApplicationToUpdate = this.applicationRepository.findById((Object)applicationId)).isPresent()) {
                throw new ApplicationNotFoundException(applicationId);
            }
            if (ApplicationStatus.ARCHIVED.equals((Object)((Application)optApplicationToUpdate.get()).getStatus())) {
                throw new ApplicationArchivedException(((Application)optApplicationToUpdate.get()).getName());
            }
            if (updateApplicationEntity.getSettings().getApp() != null && updateApplicationEntity.getSettings().getoAuthClient() != null) {
                throw new InvalidApplicationTypeException();
            }
            if (updateApplicationEntity.getSettings().getApp() == null && updateApplicationEntity.getSettings().getoAuthClient() == null) {
                throw new InvalidApplicationTypeException();
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (((Application)optApplicationToUpdate.get()).getType() == ApplicationType.SIMPLE && updateApplicationEntity.getSettings().getApp() != null) {
                String clientId = updateApplicationEntity.getSettings().getApp().getClientId();
                if (clientId != null && !clientId.trim().isEmpty()) {
                    this.LOGGER.debug("Check that client_id is unique among all applications");
                    Set applications = this.applicationRepository.findAllByEnvironment(GraviteeContext.getCurrentEnvironment(), new ApplicationStatus[]{ApplicationStatus.ACTIVE});
                    Optional<Application> byClientId = applications.stream().filter(app -> app.getMetadata() != null && clientId.equals(app.getMetadata().get("client_id"))).findAny();
                    if (byClientId.isPresent() && !byClientId.get().getId().equals(((Application)optApplicationToUpdate.get()).getId())) {
                        this.LOGGER.error("An application already exists with the same client_id");
                        throw new ClientIdAlreadyExistsException(clientId);
                    }
                }
            } else {
                ClientRegistrationResponse registrationResponse;
                this.checkClientRegistrationEnabled();
                this.checkClientSettings(updateApplicationEntity.getSettings().getoAuthClient());
                String registrationPayload = (String)((Application)optApplicationToUpdate.get()).getMetadata().get("registration_payload");
                if (registrationPayload != null && (registrationResponse = this.clientRegistrationService.update(registrationPayload, updateApplicationEntity)) != null) {
                    try {
                        metadata.put("client_id", registrationResponse.getClientId());
                        metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
            }
            final Application application = ApplicationServiceImpl.convert(updateApplicationEntity);
            application.setId(applicationId);
            application.setEnvironmentId(((Application)optApplicationToUpdate.get()).getEnvironmentId());
            application.setStatus(ApplicationStatus.ACTIVE);
            application.setType(((Application)optApplicationToUpdate.get()).getType());
            application.setCreatedAt(((Application)optApplicationToUpdate.get()).getCreatedAt());
            application.setUpdatedAt(new Date());
            metadata.forEach((key, value) -> application.getMetadata().put(key, value));
            Application updatedApplication = (Application)this.applicationRepository.update((Object)application);
            this.auditService.createApplicationAuditLog(updatedApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_UPDATED, updatedApplication.getUpdatedAt(), optApplicationToUpdate.get(), updatedApplication);
            SubscriptionQuery subQuery = new SubscriptionQuery();
            subQuery.setApplication(applicationId);
            subQuery.setStatuses(Collections.singleton(SubscriptionStatus.ACCEPTED));
            this.subscriptionService.search(subQuery).forEach(new Consumer<SubscriptionEntity>(){

                @Override
                public void accept(SubscriptionEntity subscriptionEntity) {
                    UpdateSubscriptionEntity updateSubscriptionEntity = new UpdateSubscriptionEntity();
                    updateSubscriptionEntity.setId(subscriptionEntity.getId());
                    updateSubscriptionEntity.setStartingAt(subscriptionEntity.getStartingAt());
                    updateSubscriptionEntity.setEndingAt(subscriptionEntity.getEndingAt());
                    ApplicationServiceImpl.this.subscriptionService.update(updateSubscriptionEntity, (String)application.getMetadata().get("client_id"));
                }
            });
            return this.convert(Collections.singleton(updatedApplication)).iterator().next();
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update application %s", applicationId), ex);
        }
    }

    @Override
    public ApplicationEntity renewClientSecret(String applicationId) {
        try {
            this.LOGGER.debug("Renew client secret for application {}", (Object)applicationId);
            Optional optApplicationToUpdate = this.applicationRepository.findById((Object)applicationId);
            if (!optApplicationToUpdate.isPresent()) {
                throw new ApplicationNotFoundException(applicationId);
            }
            if (ApplicationStatus.ARCHIVED.equals((Object)((Application)optApplicationToUpdate.get()).getStatus())) {
                throw new ApplicationArchivedException(((Application)optApplicationToUpdate.get()).getName());
            }
            this.checkClientRegistrationEnabled();
            Application application = (Application)optApplicationToUpdate.get();
            ApplicationEntity applicationEntity = this.findById(applicationId);
            if (applicationEntity.getSettings().getoAuthClient() != null && applicationEntity.getSettings().getoAuthClient().isRenewClientSecretSupported()) {
                ClientRegistrationResponse registrationResponse = this.clientRegistrationService.renewClientSecret((String)application.getMetadata().get("registration_payload"));
                HashMap<String, String> metadata = new HashMap<String, String>();
                try {
                    metadata.put("client_id", registrationResponse.getClientId());
                    metadata.put("registration_payload", this.mapper.writeValueAsString((Object)registrationResponse));
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                application.setUpdatedAt(new Date());
                metadata.forEach((key, value) -> application.getMetadata().put(key, value));
                Application updatedApplication = (Application)this.applicationRepository.update((Object)application);
                this.auditService.createApplicationAuditLog(updatedApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_UPDATED, updatedApplication.getUpdatedAt(), optApplicationToUpdate.get(), updatedApplication);
                return this.convert(Collections.singleton(updatedApplication)).iterator().next();
            }
            throw new ApplicationRenewClientSecretException(application.getName());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to renew client secret {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to renew client secret %s", applicationId), ex);
        }
    }

    @Override
    public ApplicationEntity restore(String applicationId) {
        try {
            this.LOGGER.debug("Restore application {}", (Object)applicationId);
            Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new ApplicationNotFoundException(applicationId));
            if (!ApplicationStatus.ARCHIVED.equals((Object)application.getStatus())) {
                throw new ApplicationActiveException(application.getName());
            }
            application.setStatus(ApplicationStatus.ACTIVE);
            application.setUpdatedAt(new Date());
            String userId = this.getAuthenticatedUsername();
            this.membershipService.deleteReference(MembershipReferenceType.APPLICATION, applicationId);
            this.membershipService.addRoleToMemberOnReference(new MembershipService.MembershipReference(MembershipReferenceType.APPLICATION, applicationId), new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.APPLICATION, SystemRole.PRIMARY_OWNER.name()));
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.APPLICATION, applicationId);
            this.portalNotificationConfigService.deleteReference(NotificationReferenceType.APPLICATION, applicationId);
            Application restoredApplication = (Application)this.applicationRepository.update((Object)application);
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApplicationAndPlan(applicationId, null);
            subscriptions.forEach(subscription -> {
                try {
                    this.subscriptionService.restore(subscription.getId());
                }
                catch (SubscriptionNotPausedException snce) {
                    this.LOGGER.debug("The subscription can not be closed: {}", (Object)snce.getMessage());
                }
            });
            UserEntity userEntity = this.userService.findById(userId);
            this.auditService.createApplicationAuditLog(restoredApplication.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_RESTORED, restoredApplication.getUpdatedAt(), application, restoredApplication);
            return this.convert(restoredApplication, userEntity);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to restore {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to restore %s", applicationId), ex);
        }
    }

    private void checkClientRegistrationEnabled() {
        this.checkClientRegistrationEnabled(GraviteeContext.getCurrentEnvironment());
    }

    private void checkClientRegistrationEnabled(String environmentId) {
        if (!this.isClientRegistrationEnabled(environmentId)) {
            throw new IllegalStateException("The client registration is disabled");
        }
    }

    private boolean isClientRegistrationEnabled(String environmentId) {
        return this.parameterService.findAsBoolean(Key.APPLICATION_REGISTRATION_ENABLED, environmentId, ParameterReferenceType.ENVIRONMENT);
    }

    private boolean isApplicationTypeAllowed(String applicationType, String environmentId) {
        Key key = Key.valueOf((String)("APPLICATION_TYPE_" + applicationType.toUpperCase() + "_ENABLED"));
        return this.parameterService.findAsBoolean(key, environmentId, ParameterReferenceType.ENVIRONMENT);
    }

    @Override
    public void archive(String applicationId) {
        try {
            this.LOGGER.debug("Delete application {}", (Object)applicationId);
            Optional optApplication = this.applicationRepository.findById((Object)applicationId);
            if (!optApplication.isPresent()) {
                throw new ApplicationNotFoundException(applicationId);
            }
            Application application = (Application)optApplication.get();
            Application previousApplication = new Application(application);
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApplicationAndPlan(applicationId, null);
            subscriptions.forEach(subscription -> {
                List<ApiKeyEntity> apiKeys = this.apiKeyService.findBySubscription(subscription.getId());
                apiKeys.forEach(apiKey -> {
                    try {
                        this.apiKeyService.delete(apiKey.getKey());
                    }
                    catch (TechnicalManagementException tme) {
                        this.LOGGER.error("An error occurs while deleting API Key {}", (Object)apiKey.getKey(), (Object)tme);
                    }
                });
                try {
                    this.subscriptionService.close(subscription.getId());
                }
                catch (SubscriptionNotClosableException snce) {
                    this.LOGGER.debug("The subscription can not be closed: {}", (Object)snce.getMessage());
                }
            });
            application.setUpdatedAt(new Date());
            application.setStatus(ApplicationStatus.ARCHIVED);
            this.applicationRepository.update((Object)application);
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.APPLICATION, applicationId);
            this.membershipService.deleteReference(MembershipReferenceType.APPLICATION, applicationId);
            this.applicationAlertService.deleteAll(applicationId);
            this.auditService.createApplicationAuditLog(application.getId(), Collections.emptyMap(), (Audit.AuditEvent)Application.AuditEvent.APPLICATION_ARCHIVED, application.getUpdatedAt(), previousApplication, application);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete application %s", applicationId), ex);
        }
    }

    private Set<ApplicationEntity> convert(Set<Application> applications) throws TechnicalException {
        if (applications == null || applications.isEmpty()) {
            return Collections.emptySet();
        }
        RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(GraviteeContext.getCurrentOrganization(), RoleScope.APPLICATION);
        if (primaryOwnerRole == null) {
            throw new RoleNotFoundException("APPLICATION_PRIMARY_OWNER");
        }
        List<String> appIds = applications.stream().map(Application::getId).collect(Collectors.toList());
        Set<MembershipEntity> memberships = this.membershipService.getMembershipsByReferencesAndRole(MembershipReferenceType.APPLICATION, appIds, primaryOwnerRole.getId());
        int poMissing = applications.size() - memberships.size();
        if (poMissing > 0) {
            Set appMembershipsIds = memberships.stream().map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
            appIds.removeAll(appMembershipsIds);
            Optional optionalApplicationsAsString = appIds.stream().reduce((a, b) -> a + " / " + b);
            String applicationsAsString = "?";
            if (optionalApplicationsAsString.isPresent()) {
                applicationsAsString = (String)optionalApplicationsAsString.get();
            }
            this.LOGGER.error("{} applications has no identified primary owners in this list {}.", (Object)poMissing, (Object)applicationsAsString);
            throw new TechnicalManagementException(poMissing + " applications has no identified primary owners in this list " + applicationsAsString + ".");
        }
        HashMap applicationToUser = new HashMap(memberships.size());
        memberships.forEach(membership -> applicationToUser.put(membership.getReferenceId(), membership.getMemberId()));
        HashMap userIdToUserEntity = new HashMap(memberships.size());
        this.userService.findByIds(memberships.stream().map(MembershipEntity::getMemberId).collect(Collectors.toList())).forEach(userEntity -> userIdToUserEntity.put(userEntity.getId(), userEntity));
        return applications.stream().map(publicApplication -> this.convert((Application)publicApplication, (UserEntity)userIdToUserEntity.get(applicationToUser.get(publicApplication.getId())))).collect(Collectors.toSet());
    }

    private Set<ApplicationListItem> convertToSimpleList(Set<Application> applications) {
        return applications.stream().map(application -> {
            ApplicationListItem item = new ApplicationListItem();
            item.setId(application.getId());
            item.setName(application.getName());
            item.setDescription(application.getDescription());
            item.setCreatedAt(application.getCreatedAt());
            item.setUpdatedAt(application.getUpdatedAt());
            item.setType(application.getType().name());
            item.setStatus(application.getStatus().name());
            item.setPicture(application.getPicture());
            item.setBackground(application.getBackground());
            return item;
        }).collect(Collectors.toSet());
    }

    private Set<ApplicationListItem> convertToList(Set<Application> applications) throws TechnicalException {
        Set<ApplicationEntity> entities = this.convert(applications);
        return entities.stream().map(applicationEntity -> {
            ApplicationListItem item = new ApplicationListItem();
            item.setId(applicationEntity.getId());
            item.setName(applicationEntity.getName());
            item.setDescription(applicationEntity.getDescription());
            item.setCreatedAt(applicationEntity.getCreatedAt());
            item.setUpdatedAt(applicationEntity.getUpdatedAt());
            item.setGroups(applicationEntity.getGroups());
            item.setPrimaryOwner(applicationEntity.getPrimaryOwner());
            item.setType(applicationEntity.getType());
            item.setStatus(applicationEntity.getStatus());
            item.setPicture(applicationEntity.getPicture());
            item.setBackground(applicationEntity.getBackground());
            Application app = applications.stream().filter(application -> application.getId().equals(applicationEntity.getId())).findFirst().get();
            item.setSettings(this.getSettings(app));
            return item;
        }).collect(Collectors.toSet());
    }

    private ApplicationEntity convert(Application application, UserEntity primaryOwner) {
        if (primaryOwner == null) {
            primaryOwner = new UserEntity();
            primaryOwner.setId("0");
            primaryOwner.setFirstname("Unknown");
            primaryOwner.setLastname("User");
        }
        ApplicationEntity applicationEntity = new ApplicationEntity();
        applicationEntity.setId(application.getId());
        applicationEntity.setName(application.getName());
        applicationEntity.setDescription(application.getDescription());
        if (application.getType() != null) {
            applicationEntity.setType(application.getType().name());
        }
        applicationEntity.setStatus(application.getStatus().toString());
        applicationEntity.setPicture(application.getPicture());
        applicationEntity.setBackground(application.getBackground());
        applicationEntity.setGroups(application.getGroups());
        applicationEntity.setCreatedAt(application.getCreatedAt());
        applicationEntity.setUpdatedAt(application.getUpdatedAt());
        applicationEntity.setPrimaryOwner(new PrimaryOwnerEntity(primaryOwner));
        applicationEntity.setSettings(this.getSettings(application));
        applicationEntity.setDisableMembershipNotifications(application.isDisableMembershipNotifications());
        return applicationEntity;
    }

    private ApplicationSettings getSettings(Application application) {
        ApplicationSettings settings = new ApplicationSettings();
        if (application.getType() == ApplicationType.SIMPLE) {
            SimpleApplicationSettings simpleSettings = new SimpleApplicationSettings();
            if (application.getMetadata() != null) {
                if (application.getMetadata().get("client_id") != null) {
                    simpleSettings.setClientId((String)application.getMetadata().get("client_id"));
                }
                if (application.getMetadata().get("type") != null) {
                    simpleSettings.setType((String)application.getMetadata().get("type"));
                }
            }
            settings.setApp(simpleSettings);
        } else {
            OAuthClientSettings clientSettings = new OAuthClientSettings();
            if (application.getMetadata() != null) {
                try {
                    Iterator<ClientRegistrationProviderEntity> clientRegistrationProviderIte;
                    String registrationPayload = (String)application.getMetadata().get("registration_payload");
                    if (registrationPayload != null) {
                        ClientRegistrationResponse registrationResponse = (ClientRegistrationResponse)this.mapper.readValue(registrationPayload, ClientRegistrationResponse.class);
                        clientSettings.setClientId(registrationResponse.getClientId());
                        clientSettings.setClientSecret(registrationResponse.getClientSecret());
                        clientSettings.setClientUri(registrationResponse.getClientUri());
                        clientSettings.setApplicationType(registrationResponse.getApplicationType());
                        clientSettings.setLogoUri(registrationResponse.getLogoUri());
                        clientSettings.setResponseTypes(registrationResponse.getResponseTypes());
                        clientSettings.setRedirectUris(registrationResponse.getRedirectUris());
                        clientSettings.setGrantTypes(registrationResponse.getGrantTypes());
                    }
                    if ((clientRegistrationProviderIte = this.clientRegistrationService.findAll().iterator()).hasNext()) {
                        clientSettings.setRenewClientSecretSupported(clientRegistrationProviderIte.next().isRenewClientSecretSupport());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            settings.setoAuthClient(clientSettings);
        }
        return settings;
    }

    private static Application convert(NewApplicationEntity newApplicationEntity) {
        Application application = new Application();
        application.setName(newApplicationEntity.getName().trim());
        application.setDescription(newApplicationEntity.getDescription().trim());
        application.setGroups(newApplicationEntity.getGroups());
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (newApplicationEntity.getSettings().getApp() != null) {
            application.setType(ApplicationType.SIMPLE);
            if (newApplicationEntity.getSettings().getApp().getClientId() != null) {
                metadata.put("client_id", newApplicationEntity.getSettings().getApp().getClientId());
            }
            if (newApplicationEntity.getSettings().getApp().getType() != null) {
                metadata.put("type", newApplicationEntity.getSettings().getApp().getType());
            }
        } else {
            application.setType(ApplicationType.valueOf((String)newApplicationEntity.getSettings().getoAuthClient().getApplicationType().toUpperCase()));
        }
        application.setPicture(newApplicationEntity.getPicture());
        application.setBackground(newApplicationEntity.getBackground());
        application.setMetadata(metadata);
        return application;
    }

    private static Application convert(UpdateApplicationEntity updateApplicationEntity) {
        Application application = new Application();
        application.setName(updateApplicationEntity.getName().trim());
        application.setPicture(updateApplicationEntity.getPicture());
        application.setBackground(updateApplicationEntity.getBackground());
        application.setDescription(updateApplicationEntity.getDescription().trim());
        application.setGroups(updateApplicationEntity.getGroups());
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (updateApplicationEntity.getSettings().getApp() != null) {
            if (updateApplicationEntity.getSettings().getApp().getClientId() != null) {
                metadata.put("client_id", updateApplicationEntity.getSettings().getApp().getClientId());
            }
            if (updateApplicationEntity.getSettings().getApp().getType() != null) {
                metadata.put("type", updateApplicationEntity.getSettings().getApp().getType());
            }
        }
        application.setMetadata(metadata);
        application.setDisableMembershipNotifications(updateApplicationEntity.isDisableMembershipNotifications());
        return application;
    }

    @Override
    public InlinePictureEntity getPicture(String applicationId) {
        ApplicationEntity applicationEntity = this.findById(applicationId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (applicationEntity.getPicture() != null) {
            String[] parts = applicationEntity.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = applicationEntity.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public InlinePictureEntity getBackground(String applicationId) {
        ApplicationEntity applicationEntity = this.findById(applicationId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (applicationEntity.getBackground() != null) {
            String[] parts = applicationEntity.getBackground().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = applicationEntity.getBackground().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }
}

