/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notifiers.impl;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notifiers.WebNotifierService;
import io.gravitee.rest.api.service.notifiers.WebhookNotifierService;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebhookNotifierServiceImpl
implements WebhookNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(WebhookNotifierServiceImpl.class);
    @Autowired
    WebNotifierService webNotifierService;

    @Override
    public void trigger(Hook hook, GenericNotificationConfig genericNotificationConfig, Map<String, Object> params) {
        String body = this.toJson(hook, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Gravitee-Event", hook.name());
        headers.put("X-Gravitee-Event-Scope", hook.getScope().name());
        this.webNotifierService.request(HttpMethod.POST, genericNotificationConfig.getConfig(), headers, body, genericNotificationConfig.isUseSystemProxy());
    }

    private String toJson(Hook hook, Map<String, Object> params) {
        SubscriptionEntity subscription;
        PlanEntity plan;
        PrimaryOwnerEntity owner;
        ApplicationEntity application;
        Object api;
        JsonObject content = new JsonObject();
        content.put("event", hook.name());
        content.put("scope", hook.getScope().name());
        if (params.containsKey("api") && (api = params.get("api")) != null) {
            JsonObject jsonApi = new JsonObject();
            jsonApi.put("id", api instanceof ApiModelEntity ? ((ApiModelEntity)api).getId() : ((ApiEntity)api).getId());
            jsonApi.put("name", api instanceof ApiModelEntity ? ((ApiModelEntity)api).getName() : ((ApiEntity)api).getName());
            jsonApi.put("version", api instanceof ApiModelEntity ? ((ApiModelEntity)api).getVersion() : ((ApiEntity)api).getVersion());
            content.put("api", jsonApi);
        }
        if (params.containsKey("application") && (application = (ApplicationEntity)params.get("application")) != null) {
            JsonObject jsonApplication = new JsonObject();
            jsonApplication.put("id", application.getId());
            jsonApplication.put("name", application.getName());
            content.put("application", jsonApplication);
        }
        if (params.containsKey("owner") && (owner = (PrimaryOwnerEntity)params.get("owner")) != null) {
            JsonObject jsonOwner = new JsonObject();
            jsonOwner.put("id", owner.getId());
            jsonOwner.put("username", owner.getDisplayName());
            content.put("owner", jsonOwner);
        }
        if (params.containsKey("plan") && (plan = (PlanEntity)params.get("plan")) != null) {
            JsonObject jsonPlan = new JsonObject();
            jsonPlan.put("id", plan.getId());
            jsonPlan.put("name", plan.getName());
            jsonPlan.put("security", (Enum)plan.getSecurity());
            content.put("plan", jsonPlan);
        }
        if (params.containsKey("subscription") && (subscription = (SubscriptionEntity)params.get("subscription")) != null) {
            JsonObject jsonSubscription = new JsonObject();
            jsonSubscription.put("id", subscription.getId());
            jsonSubscription.put("status", (Enum)subscription.getStatus());
            content.put("subscription", jsonSubscription);
        }
        return content.encode();
    }
}

