/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.util.Maps;
import io.gravitee.el.TemplateEngine;
import io.gravitee.el.spel.function.JsonPathFunction;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.InvitationEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.NewUserMetadataEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.RegisterUserEntity;
import io.gravitee.rest.api.model.ResetPasswordUserEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UpdateUserMetadataEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserMetadataEntity;
import io.gravitee.rest.api.model.UserRoleEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.application.SimpleApplicationSettings;
import io.gravitee.rest.api.model.audit.AuditEntity;
import io.gravitee.rest.api.model.audit.AuditQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.configuration.identity.GroupMappingEntity;
import io.gravitee.rest.api.model.configuration.identity.RoleMappingEntity;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.EmailValidator;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.InvitationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NewsletterService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PasswordValidator;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.PortalNotificationService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.UserMetadataService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.JWTHelper;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import io.gravitee.rest.api.service.exceptions.DefaultRoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.EmailFormatInvalidException;
import io.gravitee.rest.api.service.exceptions.EmailRequiredException;
import io.gravitee.rest.api.service.exceptions.GroupNotFoundException;
import io.gravitee.rest.api.service.exceptions.PasswordAlreadyResetException;
import io.gravitee.rest.api.service.exceptions.PasswordFormatInvalidException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.StillPrimaryOwnerException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.UserAlreadyFinalizedException;
import io.gravitee.rest.api.service.exceptions.UserNotActiveException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.exceptions.UserNotInternallyManagedException;
import io.gravitee.rest.api.service.exceptions.UserRegistrationUnavailableException;
import io.gravitee.rest.api.service.exceptions.UserStateConflictException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.notification.PortalHook;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.search.query.Query;
import io.gravitee.rest.api.service.search.query.QueryBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class UserServiceImpl
extends AbstractService
implements UserService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final String IDP_SOURCE_GRAVITEE = "gravitee";
    private static final String TEMPLATE_ENGINE_PROFILE_ATTRIBUTE = "profile";
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private EmailService emailService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private InvitationService invitationService;
    @Autowired
    private PortalNotificationService portalNotificationService;
    @Autowired
    private PortalNotificationConfigService portalNotificationConfigService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private NewsletterService newsletterService;
    @Autowired
    private PasswordValidator passwordValidator;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private IdentityProviderService identityProviderService;
    @Autowired
    private UserMetadataService userMetadataService;
    @Value(value="${user.login.defaultApplication:true}")
    private boolean defaultApplicationForFirstConnection;
    @Value(value="${user.anonymize-on-delete.enabled:false}")
    private boolean anonymizeOnDelete;
    private List<String> portalWhitelist;
    private PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    public void afterPropertiesSet() {
        String whitelistUrl;
        int i = 0;
        this.portalWhitelist = new ArrayList<String>();
        while ((whitelistUrl = this.environment.getProperty("portal.whitelist[" + i + "]")) != null) {
            this.portalWhitelist.add(whitelistUrl);
            ++i;
        }
    }

    @Override
    public UserEntity connect(String userId) {
        try {
            LOGGER.debug("Connection of {}", (Object)userId);
            Optional checkUser = this.userRepository.findById((Object)userId);
            if (!checkUser.isPresent()) {
                throw new UserNotFoundException(userId);
            }
            User user = (User)checkUser.get();
            User previousUser = new User(user);
            if (user.getLastConnectionAt() == null && user.getFirstConnectionAt() == null) {
                this.notifierService.trigger(PortalHook.USER_FIRST_LOGIN, new NotificationParamsBuilder().user(this.convert(user, false)).build());
                user.setFirstConnectionAt(new Date());
                if (this.defaultApplicationForFirstConnection) {
                    LOGGER.debug("Create a default application for {}", (Object)userId);
                    NewApplicationEntity defaultApp = new NewApplicationEntity();
                    defaultApp.setName("Default application");
                    defaultApp.setDescription("My default application");
                    ApplicationSettings settings = new ApplicationSettings();
                    SimpleApplicationSettings simpleAppSettings = new SimpleApplicationSettings();
                    settings.setApp(simpleAppSettings);
                    defaultApp.setSettings(settings);
                    try {
                        this.applicationService.create(defaultApp, userId, true);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
            user.setLastConnectionAt(new Date());
            if (user.getFirstConnectionAt() == null) {
                user.setFirstConnectionAt(user.getLastConnectionAt());
            }
            user.setUpdatedAt(user.getLastConnectionAt());
            user.setLoginCount(user.getLoginCount() + 1L);
            User updatedUser = (User)this.userRepository.update((Object)user);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, userId), (Audit.AuditEvent)User.AuditEvent.USER_CONNECTED, user.getUpdatedAt(), previousUser, user);
            UserEntity userEntity = this.convert(updatedUser, true);
            this.searchEngineService.index((Indexable)userEntity, false);
            return userEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to connect {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to connect " + userId, ex);
        }
    }

    @Override
    public UserEntity findById(String id, boolean defaultValue) {
        return GraviteeContext.getCurrentUsers().computeIfAbsent(id, k -> {
            try {
                LOGGER.debug("Find user by ID: {}", k);
                Optional optionalUser = this.userRepository.findById(k);
                if (optionalUser.isPresent()) {
                    return this.convert((User)optionalUser.get(), false, this.userMetadataService.findAllByUserId((String)k));
                }
                if (defaultValue) {
                    UserEntity unknownUser = new UserEntity();
                    unknownUser.setId(k);
                    unknownUser.setFirstname("Unknown user");
                    return unknownUser;
                }
                throw new UserNotFoundException((String)k);
            }
            catch (TechnicalException ex) {
                LOGGER.error("An error occurs while trying to find user using its ID {}", k, (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to find user using its ID " + k, ex);
            }
        });
    }

    @Override
    public Optional<UserEntity> findByEmail(String email) {
        try {
            LOGGER.debug("Find user by Email: {}", (Object)email);
            Optional optionalUser = this.userRepository.findByEmail(email, GraviteeContext.getCurrentOrganization());
            return optionalUser.map(user -> this.convert((User)optionalUser.get(), false));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find user using its email", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find user using its email", ex);
        }
    }

    @Override
    public UserEntity findByIdWithRoles(String id) {
        try {
            LOGGER.debug("Find user by ID: {}", (Object)id);
            Optional optionalUser = this.userRepository.findById((Object)id);
            if (optionalUser.isPresent()) {
                UserEntity userEntity = this.convert((User)optionalUser.get(), true, this.userMetadataService.findAllByUserId(id));
                this.populateUserFlags(Collections.singletonList(userEntity));
                return userEntity;
            }
            throw new UserNotFoundException(id);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find user using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find user using its ID " + id, ex);
        }
    }

    @Override
    public UserEntity findBySource(String source, String sourceId, boolean loadRoles) {
        try {
            LOGGER.debug("Find user by source[{}] user[{}]", (Object)source, (Object)sourceId);
            Optional optionalUser = this.userRepository.findBySource(source, sourceId, GraviteeContext.getCurrentOrganization());
            if (optionalUser.isPresent()) {
                return this.convert((User)optionalUser.get(), loadRoles);
            }
            throw new UserNotFoundException(sourceId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find user using source[{}], user[{}]", new Object[]{source, sourceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to find user using source " + source + ":" + sourceId, ex);
        }
    }

    @Override
    public Set<UserEntity> findByIds(List<String> ids) {
        return this.findByIds(ids, true);
    }

    @Override
    public Set<UserEntity> findByIds(List<String> ids, boolean withUserMetadata) {
        try {
            LOGGER.debug("Find users by ID: {}", ids);
            Set users = this.userRepository.findByIds(ids);
            if (!users.isEmpty()) {
                return users.stream().map(u -> this.convert((User)u, false, withUserMetadata ? this.userMetadataService.findAllByUserId(u.getId()) : Collections.emptyList())).collect(Collectors.toSet());
            }
            Optional idsAsString = ids.stream().reduce((a, b) -> a + "/" + b);
            if (idsAsString.isPresent()) {
                throw new UserNotFoundException((String)idsAsString.get());
            }
            throw new UserNotFoundException("?");
        }
        catch (TechnicalException ex) {
            Optional idsAsString = ids.stream().reduce((a, b) -> a + "/" + b);
            LOGGER.error("An error occurs while trying to find users using their ID {}", idsAsString, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find users using their ID " + idsAsString, ex);
        }
    }

    private void checkUserRegistrationEnabled(GraviteeContext.ReferenceContext currentContext) {
        boolean userCreationEnabled = currentContext.getReferenceType().equals((Object)GraviteeContext.ReferenceContextType.ORGANIZATION) ? this.parameterService.findAsBoolean(Key.CONSOLE_USERCREATION_ENABLED, currentContext.getReferenceId(), ParameterReferenceType.ORGANIZATION) : this.parameterService.findAsBoolean(Key.PORTAL_USERCREATION_ENABLED, currentContext.getReferenceId(), ParameterReferenceType.ENVIRONMENT);
        if (!userCreationEnabled) {
            throw new UserRegistrationUnavailableException();
        }
    }

    @Override
    public UserEntity finalizeRegistration(RegisterUserEntity registerUserEntity) {
        try {
            User user;
            DecodedJWT jwt = this.getDecodedJWT(registerUserEntity.getToken());
            String action = jwt.getClaim("action").asString();
            if (JWTHelper.ACTION.RESET_PASSWORD.name().equals(action)) {
                throw new UserStateConflictException("Reset password forbidden on this resource");
            }
            if (JWTHelper.ACTION.USER_REGISTRATION.name().equals(action)) {
                this.checkUserRegistrationEnabled(GraviteeContext.getCurrentContext());
            } else if (JWTHelper.ACTION.GROUP_INVITATION.name().equals(action)) {
                String email = jwt.getClaim("email").asString();
                List<InvitationEntity> invitations = this.invitationService.findAll();
                List userInvitations = invitations.stream().filter(invitation -> invitation.getEmail().equals(email)).collect(Collectors.toList());
                if (userInvitations.isEmpty()) {
                    throw new IllegalStateException("Invitation has been canceled");
                }
            }
            if (registerUserEntity.getPassword() != null && !this.passwordValidator.validate(registerUserEntity.getPassword())) {
                throw new PasswordFormatInvalidException();
            }
            String subject = jwt.getSubject();
            if (subject == null) {
                NewExternalUserEntity externalUser = new NewExternalUserEntity();
                String email = jwt.getClaim("email").asString();
                externalUser.setSource(IDP_SOURCE_GRAVITEE);
                externalUser.setSourceId(email);
                externalUser.setFirstname(registerUserEntity.getFirstname());
                externalUser.setLastname(registerUserEntity.getLastname());
                externalUser.setEmail(email);
                user = this.convert(this.create(externalUser, true));
                user.setOrganizationId(GraviteeContext.getCurrentOrganization());
            } else {
                String username = subject.toString();
                LOGGER.debug("Create an internal user {}", (Object)username);
                Optional checkUser = this.userRepository.findById((Object)username);
                user = (User)checkUser.orElseThrow(() -> new UserNotFoundException(username));
                if (StringUtils.isNotBlank((CharSequence)user.getPassword())) {
                    throw new UserAlreadyFinalizedException(GraviteeContext.getCurrentOrganization());
                }
            }
            if (JWTHelper.ACTION.GROUP_INVITATION.name().equals(action)) {
                String email = user.getEmail();
                String userId = user.getId();
                List<InvitationEntity> invitations = this.invitationService.findAll();
                invitations.stream().filter(invitation -> invitation.getEmail().equals(email)).forEach(invitation -> {
                    this.invitationService.addMember(invitation.getReferenceType().name(), invitation.getReferenceId(), userId, invitation.getApiRole(), invitation.getApplicationRole());
                    this.invitationService.delete(invitation.getId(), invitation.getReferenceId());
                });
            }
            user.setUpdatedAt(new Date());
            this.encryptPassword(user, registerUserEntity.getPassword());
            user = (User)this.userRepository.update((Object)user);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.USER_CREATED, user.getUpdatedAt(), null, user);
            user.setPassword(null);
            UserEntity userEntity = this.convert(user, true);
            this.searchEngineService.index((Indexable)userEntity, false);
            return userEntity;
        }
        catch (AbstractManagementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to create an internal user with the token {}", (Object)registerUserEntity.getToken(), (Object)ex);
            throw new TechnicalManagementException(ex.getMessage(), ex);
        }
    }

    @Override
    public UserEntity finalizeResetPassword(ResetPasswordUserEntity registerUserEntity) {
        try {
            DecodedJWT jwt = this.getDecodedJWT(registerUserEntity.getToken());
            String action = jwt.getClaim("action").asString();
            if (!JWTHelper.ACTION.RESET_PASSWORD.name().equals(action)) {
                throw new UserStateConflictException("Invalid action on reset password resource");
            }
            String subject = jwt.getSubject();
            if (subject == null) {
                throw new UserNotFoundException("Subject missing from JWT token");
            }
            String username = subject.toString();
            LOGGER.debug("Find user {} to update password", (Object)username);
            Optional checkUser = this.userRepository.findById((Object)username);
            User user = (User)checkUser.orElseThrow(() -> new UserNotFoundException(username));
            user.setUpdatedAt(new Date());
            this.encryptPassword(user, registerUserEntity.getPassword());
            user = (User)this.userRepository.update((Object)user);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.PASSWORD_CHANGED, user.getUpdatedAt(), null, null);
            user.setPassword(null);
            return this.convert(user, true);
        }
        catch (AbstractManagementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to change password of an internal user with the token {}", (Object)registerUserEntity.getToken(), (Object)ex);
            throw new TechnicalManagementException(ex.getMessage(), ex);
        }
    }

    private void encryptPassword(User user, String password) {
        if (password != null) {
            if (this.passwordValidator.validate(password)) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)password));
            } else {
                throw new PasswordFormatInvalidException();
            }
        }
    }

    private DecodedJWT getDecodedJWT(String token) {
        String jwtSecret = this.environment.getProperty("jwt.secret");
        if (jwtSecret == null || jwtSecret.isEmpty()) {
            throw new IllegalStateException("JWT secret is mandatory");
        }
        Algorithm algorithm = Algorithm.HMAC256((String)jwtSecret);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{this.environment.getProperty("jwt.issuer", "gravitee-management-auth")}).build();
        return verifier.verify(token);
    }

    @Override
    public PictureEntity getPicture(String id) {
        UserEntity user = this.findById(id);
        if (user.getPicture() != null) {
            String picture = user.getPicture();
            if (picture.matches("^(http|https)://.*$")) {
                return new UrlPictureEntity(picture);
            }
            try {
                InlinePictureEntity imageEntity = new InlinePictureEntity();
                String[] parts = picture.split(";", 2);
                imageEntity.setType(parts[0].split(":")[1]);
                String base64Content = picture.split(",", 2)[1];
                imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
                return imageEntity;
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to get user picture for id[{}]", (Object)id);
            }
        }
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        imageEntity.setType("image/png");
        return imageEntity;
    }

    @Override
    public UserEntity create(NewExternalUserEntity newExternalUserEntity, boolean addDefaultRole) {
        return this.create(newExternalUserEntity, addDefaultRole, true);
    }

    private UserEntity create(NewExternalUserEntity newExternalUserEntity, boolean addDefaultRole, boolean autoRegistrationEnabled) {
        try {
            String organizationId = GraviteeContext.getCurrentOrganization();
            this.organizationService.findById(organizationId);
            LOGGER.debug("Create an external user {}", (Object)newExternalUserEntity);
            Optional checkUser = this.userRepository.findBySource(newExternalUserEntity.getSource(), newExternalUserEntity.getSourceId(), organizationId);
            if (checkUser.isPresent()) {
                throw new UserAlreadyExistsException(newExternalUserEntity.getSource(), newExternalUserEntity.getSourceId(), organizationId);
            }
            User user = this.convert(newExternalUserEntity);
            user.setId(RandomString.generate());
            user.setOrganizationId(organizationId);
            user.setStatus(autoRegistrationEnabled ? UserStatus.ACTIVE : UserStatus.PENDING);
            user.setCreatedAt(new Date());
            user.setUpdatedAt(user.getCreatedAt());
            User createdUser = (User)this.userRepository.create((Object)user);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.USER_CREATED, user.getCreatedAt(), null, user);
            ArrayList<UserMetadataEntity> metadata = new ArrayList<UserMetadataEntity>();
            if (newExternalUserEntity.getCustomFields() != null) {
                for (Map.Entry entry : newExternalUserEntity.getCustomFields().entrySet()) {
                    NewUserMetadataEntity metadataEntity = new NewUserMetadataEntity();
                    metadataEntity.setName((String)entry.getKey());
                    metadataEntity.setUserId(createdUser.getId());
                    metadataEntity.setFormat(MetadataFormat.STRING);
                    metadataEntity.setValue(String.valueOf(entry.getValue()));
                    metadata.add(this.userMetadataService.create(metadataEntity));
                }
            }
            if (addDefaultRole) {
                this.addDefaultMembership(createdUser);
            }
            UserEntity userEntity = this.convert(createdUser, true, metadata);
            this.searchEngineService.index((Indexable)userEntity, false);
            return userEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to create an external user {}", (Object)newExternalUserEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create an external user" + newExternalUserEntity, ex);
        }
    }

    private void addDefaultMembership(User user) {
        RoleScope[] scopes = new RoleScope[]{RoleScope.ORGANIZATION, RoleScope.ENVIRONMENT};
        List<RoleEntity> defaultRoleByScopes = this.roleService.findDefaultRoleByScopes(scopes);
        if (defaultRoleByScopes == null || defaultRoleByScopes.isEmpty()) {
            throw new DefaultRoleNotFoundException(scopes);
        }
        for (RoleEntity defaultRoleByScope : defaultRoleByScopes) {
            switch (defaultRoleByScope.getScope()) {
                case ORGANIZATION: {
                    this.membershipService.addRoleToMemberOnReference(new MembershipService.MembershipReference(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization()), new MembershipService.MembershipMember(user.getId(), null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.ORGANIZATION, defaultRoleByScope.getName()));
                    break;
                }
                case ENVIRONMENT: {
                    this.membershipService.addRoleToMemberOnReference(new MembershipService.MembershipReference(MembershipReferenceType.ENVIRONMENT, GraviteeContext.getCurrentEnvironmentOrDefault()), new MembershipService.MembershipMember(user.getId(), null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.ENVIRONMENT, defaultRoleByScope.getName()));
                    break;
                }
            }
        }
    }

    @Override
    public UserEntity register(NewExternalUserEntity newExternalUserEntity) {
        return this.register(newExternalUserEntity, null);
    }

    @Override
    public UserEntity register(NewExternalUserEntity newExternalUserEntity, String confirmationPageUrl) {
        GraviteeContext.ReferenceContext currentContext = GraviteeContext.getCurrentContext();
        if (confirmationPageUrl != null) {
            UrlSanitizerUtils.checkAllowed(confirmationPageUrl, this.portalWhitelist, true);
        }
        this.checkUserRegistrationEnabled(currentContext);
        boolean autoRegistrationEnabled = this.isAutoRegistrationEnabled(currentContext);
        return this.createAndSendEmail(newExternalUserEntity, JWTHelper.ACTION.USER_REGISTRATION, confirmationPageUrl, autoRegistrationEnabled);
    }

    private boolean isAutoRegistrationEnabled(GraviteeContext.ReferenceContext currentContext) {
        if (currentContext.getReferenceType().equals((Object)GraviteeContext.ReferenceContextType.ORGANIZATION)) {
            return this.parameterService.findAsBoolean(Key.CONSOLE_USERCREATION_AUTOMATICVALIDATION_ENABLED, currentContext.getReferenceId(), ParameterReferenceType.ORGANIZATION);
        }
        return this.parameterService.findAsBoolean(Key.PORTAL_USERCREATION_AUTOMATICVALIDATION_ENABLED, currentContext.getReferenceId(), ParameterReferenceType.ENVIRONMENT);
    }

    @Override
    public UserEntity create(NewExternalUserEntity newExternalUserEntity) {
        return this.createAndSendEmail(newExternalUserEntity, JWTHelper.ACTION.USER_CREATION, null, true);
    }

    private UserEntity createAndSendEmail(NewExternalUserEntity newExternalUserEntity, JWTHelper.ACTION action, String confirmationPageUrl, boolean autoRegistrationEnabled) {
        if (!EmailValidator.isValid(newExternalUserEntity.getEmail())) {
            throw new EmailFormatInvalidException(newExternalUserEntity.getEmail());
        }
        String organizationId = GraviteeContext.getCurrentOrganization();
        if (StringUtils.isBlank((CharSequence)newExternalUserEntity.getSource())) {
            newExternalUserEntity.setSource(IDP_SOURCE_GRAVITEE);
        } else if (!IDP_SOURCE_GRAVITEE.equals(newExternalUserEntity.getSource())) {
            this.identityProviderService.findById(newExternalUserEntity.getSource());
        }
        if (StringUtils.isBlank((CharSequence)newExternalUserEntity.getSourceId())) {
            newExternalUserEntity.setSourceId(newExternalUserEntity.getEmail());
        }
        try {
            Optional optionalUser = this.userRepository.findBySource(newExternalUserEntity.getSource(), newExternalUserEntity.getSourceId(), organizationId);
            if (optionalUser.isPresent()) {
                throw new UserAlreadyExistsException(newExternalUserEntity.getSource(), newExternalUserEntity.getSourceId(), organizationId);
            }
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to create user {} / {}", new Object[]{newExternalUserEntity.getSource(), newExternalUserEntity.getSourceId(), e});
            throw new TechnicalManagementException(e.getMessage(), e);
        }
        UserEntity userEntity = this.create(newExternalUserEntity, true, autoRegistrationEnabled);
        if (IDP_SOURCE_GRAVITEE.equals(newExternalUserEntity.getSource())) {
            Map<String, Object> params = this.getTokenRegistrationParams(userEntity, "/#!/registration/confirm/", action, confirmationPageUrl);
            this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(userEntity.getEmail()).template(EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_USER_REGISTRATION).params(params).param("registrationAction", JWTHelper.ACTION.USER_REGISTRATION.equals((Object)action) ? "registration" : "creation").build(), GraviteeContext.getCurrentContext());
            if (autoRegistrationEnabled) {
                this.notifierService.trigger(JWTHelper.ACTION.USER_REGISTRATION.equals((Object)action) ? PortalHook.USER_REGISTERED : PortalHook.USER_CREATED, params);
            } else {
                this.notifierService.trigger(PortalHook.USER_REGISTRATION_REQUEST, params);
            }
        }
        if (newExternalUserEntity.getNewsletter() != null && newExternalUserEntity.getNewsletter().booleanValue()) {
            this.newsletterService.subscribe(newExternalUserEntity.getEmail());
        }
        return userEntity;
    }

    @Override
    public UserEntity processRegistration(String userId, boolean accepted) {
        UserEntity userToProcess = this.findById(userId);
        UserEntity processedUser = this.changeUserStatus(userId, accepted ? UserStatus.ACTIVE : UserStatus.REJECTED);
        Map<String, Object> params = new NotificationParamsBuilder().user(processedUser).build();
        this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(userToProcess.getEmail()).template(EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_USER_REGISTRATION_REQUEST_PROCESSED).params(params).param("registrationStatus", accepted ? "accepted" : "rejected").build(), GraviteeContext.getCurrentContext());
        this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, processedUser.getId()), (Audit.AuditEvent)(accepted ? User.AuditEvent.USER_CONFIRMED : User.AuditEvent.USER_REJECTED), processedUser.getUpdatedAt(), userToProcess, processedUser);
        return processedUser;
    }

    private UserEntity changeUserStatus(String userId, UserStatus newStatus) {
        try {
            Optional optionalUser = this.userRepository.findById((Object)userId);
            if (optionalUser.isPresent()) {
                User user = (User)optionalUser.get();
                user.setStatus(newStatus);
                user.setUpdatedAt(new Date());
                if (newStatus == UserStatus.REJECTED) {
                    user.setSourceId(newStatus.name().toLowerCase() + "-" + user.getSourceId());
                }
                return this.convert((User)this.userRepository.update((Object)user), true);
            }
            throw new UserNotFoundException(userId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to validate user registration {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create an external user" + userId, ex);
        }
    }

    @Override
    public Map<String, Object> getTokenRegistrationParams(UserEntity userEntity, String managementUri, JWTHelper.ACTION action) {
        return this.getTokenRegistrationParams(userEntity, managementUri, action, null);
    }

    @Override
    public Map<String, Object> getTokenRegistrationParams(UserEntity userEntity, String managementUri, JWTHelper.ACTION action, String targetPageUrl) {
        String jwtSecret = this.environment.getProperty("jwt.secret");
        if (jwtSecret == null || jwtSecret.isEmpty()) {
            throw new IllegalStateException("JWT secret is mandatory");
        }
        Algorithm algorithm = Algorithm.HMAC256((String)this.environment.getProperty("jwt.secret"));
        Date issueAt = new Date();
        Instant expireAt = issueAt.toInstant().plus(Duration.ofSeconds(((Integer)this.environment.getProperty("user.creation.token.expire-after", Integer.class, (Object)86400)).intValue()));
        String token = JWT.create().withIssuer(this.environment.getProperty("jwt.issuer", "gravitee-management-auth")).withIssuedAt(issueAt).withExpiresAt(Date.from(expireAt)).withSubject(userEntity.getId()).withClaim("email", userEntity.getEmail()).withClaim("firstname", userEntity.getFirstname()).withClaim("lastname", userEntity.getLastname()).withClaim("action", action.name()).sign(algorithm);
        String managementURL = this.parameterService.find(Key.MANAGEMENT_URL, ParameterReferenceType.ORGANIZATION);
        Object userURL = "";
        if (!StringUtils.isEmpty((CharSequence)managementURL)) {
            if (managementURL.endsWith("/")) {
                managementURL = managementURL.substring(0, managementURL.length() - 1);
            }
            userURL = managementURL + "/#!/settings/users/" + userEntity.getId();
        }
        Object registrationUrl = "";
        if (targetPageUrl != null && !targetPageUrl.isEmpty()) {
            registrationUrl = (String)registrationUrl + targetPageUrl;
            if (!targetPageUrl.endsWith("/")) {
                registrationUrl = (String)registrationUrl + "/";
            }
            registrationUrl = (String)registrationUrl + token;
        } else if (!StringUtils.isEmpty((CharSequence)managementURL)) {
            registrationUrl = managementURL + managementUri + token;
        } else {
            registrationUrl = "http://localhost:3000" + managementUri + token;
            LOGGER.warn("An email will be sent with a default '" + managementUri.substring(4, managementUri.indexOf(47, 4)) + "' link. You may want to change this default configuration of the 'Management URL' in the Settings.");
        }
        return new NotificationParamsBuilder().user(userEntity).token(token).registrationUrl((String)registrationUrl).userUrl((String)userURL).build();
    }

    @Override
    public UserEntity update(String id, UpdateUserEntity updateUserEntity) {
        return this.update(id, updateUserEntity, updateUserEntity.getEmail());
    }

    @Override
    public UserEntity update(String id, UpdateUserEntity updateUserEntity, String newsletterEmail) {
        try {
            LOGGER.debug("Updating {}", (Object)updateUserEntity);
            Optional checkUser = this.userRepository.findById((Object)id);
            if (!checkUser.isPresent()) {
                throw new UserNotFoundException(id);
            }
            User user = (User)checkUser.get();
            User previousUser = new User(user);
            user.setUpdatedAt(new Date());
            if (updateUserEntity.getPicture() != null) {
                user.setPicture(updateUserEntity.getPicture());
            }
            if (updateUserEntity.getFirstname() != null) {
                user.setFirstname(updateUserEntity.getFirstname());
            }
            if (updateUserEntity.getLastname() != null) {
                user.setLastname(updateUserEntity.getLastname());
            }
            if (updateUserEntity.getEmail() != null && !updateUserEntity.getEmail().equals(user.getEmail())) {
                if (this.isInternalUser(user)) {
                    Optional optionalUser = this.userRepository.findBySource(user.getSource(), updateUserEntity.getEmail(), user.getOrganizationId());
                    if (optionalUser.isPresent()) {
                        throw new UserAlreadyExistsException(user.getSource(), updateUserEntity.getEmail(), user.getOrganizationId());
                    }
                    user.setSourceId(updateUserEntity.getEmail());
                }
                user.setEmail(updateUserEntity.getEmail());
            }
            if (updateUserEntity.getStatus() != null) {
                user.setStatus(UserStatus.valueOf((String)updateUserEntity.getStatus()));
            }
            if (updateUserEntity.isNewsletter() != null) {
                user.setNewsletterSubscribed(updateUserEntity.isNewsletter());
                if (updateUserEntity.isNewsletter().booleanValue() && newsletterEmail != null) {
                    this.newsletterService.subscribe(newsletterEmail);
                }
            }
            User updatedUser = (User)this.userRepository.update((Object)user);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.USER_UPDATED, user.getUpdatedAt(), previousUser, user);
            ArrayList<UserMetadataEntity> updatedMetadata = new ArrayList<UserMetadataEntity>();
            if (updateUserEntity.getCustomFields() != null && !updateUserEntity.getCustomFields().isEmpty()) {
                List<UserMetadataEntity> metadata = this.userMetadataService.findAllByUserId(user.getId());
                for (Map.Entry entry : updateUserEntity.getCustomFields().entrySet()) {
                    Optional<UserMetadataEntity> existingMeta = metadata.stream().filter(meta -> meta.getKey().equals(entry.getKey())).findFirst();
                    if (existingMeta.isPresent()) {
                        UserMetadataEntity meta2 = existingMeta.get();
                        UpdateUserMetadataEntity metadataEntity = new UpdateUserMetadataEntity();
                        metadataEntity.setName(meta2.getName());
                        metadataEntity.setKey(meta2.getKey());
                        metadataEntity.setValue(String.valueOf(entry.getValue()));
                        metadataEntity.setUserId(meta2.getUserId());
                        metadataEntity.setFormat(meta2.getFormat());
                        updatedMetadata.add(this.userMetadataService.update(metadataEntity));
                        continue;
                    }
                    NewUserMetadataEntity metadataEntity = new NewUserMetadataEntity();
                    metadataEntity.setName((String)entry.getKey());
                    metadataEntity.setValue(String.valueOf(entry.getValue()));
                    metadataEntity.setUserId(user.getId());
                    metadataEntity.setFormat(MetadataFormat.STRING);
                    updatedMetadata.add(this.userMetadataService.create(metadataEntity));
                }
            }
            return this.convert(updatedUser, true, updatedMetadata);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to update {}", (Object)updateUserEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying update " + updateUserEntity, ex);
        }
    }

    @Override
    public Page<UserEntity> search(String query, Pageable pageable) {
        LOGGER.debug("search users");
        if (query == null || query.isEmpty()) {
            return this.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ACTIVE, UserStatus.PENDING, UserStatus.REJECTED}).build(), pageable);
        }
        String sanitizedQuery = query.indexOf(64) > 0 ? query.substring(0, query.indexOf(64)) : query;
        Query<UserEntity> userQuery = QueryBuilder.create(UserEntity.class).setQuery(sanitizedQuery).setPage(pageable).build();
        SearchResult results = this.searchEngineService.search(userQuery);
        if (results.hasResults()) {
            ArrayList<UserEntity> users = new ArrayList<UserEntity>(this.findByIds(results.getDocuments()));
            this.populateUserFlags(users);
            return new Page(users, pageable.getPageNumber(), pageable.getPageSize(), results.getHits());
        }
        return new Page(Collections.emptyList(), 1, 0, 0L);
    }

    private void populateUserFlags(List<UserEntity> users) {
        RoleEntity apiPORole = this.roleService.findPrimaryOwnerRoleByOrganization(GraviteeContext.getCurrentOrganization(), RoleScope.API);
        RoleEntity applicationPORole = this.roleService.findPrimaryOwnerRoleByOrganization(GraviteeContext.getCurrentOrganization(), RoleScope.APPLICATION);
        users.forEach(user -> {
            boolean apiPO = !this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.USER, user.getId(), MembershipReferenceType.API, apiPORole.getId()).isEmpty();
            boolean appPO = !this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.USER, user.getId(), MembershipReferenceType.APPLICATION, applicationPORole.getId()).isEmpty();
            user.setPrimaryOwner(apiPO || appPO);
            user.setNbActiveTokens(this.tokenService.findByUser(user.getId()).size());
        });
    }

    @Override
    public Page<UserEntity> search(UserCriteria criteria, Pageable pageable) {
        try {
            LOGGER.debug("search users");
            UserCriteria.Builder builder = new UserCriteria.Builder().organizationId(GraviteeContext.getCurrentOrganization()).statuses(criteria.getStatuses());
            if (criteria.hasNoStatus()) {
                builder.noStatus();
            }
            UserCriteria newCriteria = builder.build();
            Page users = this.userRepository.search(newCriteria, new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build());
            List<UserEntity> entities = users.getContent().stream().map(u -> this.convert((User)u, false)).collect(Collectors.toList());
            this.populateUserFlags(entities);
            return new Page(entities, users.getPageNumber() + 1, (int)users.getPageElements(), users.getTotalElements());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to search users", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search users", ex);
        }
    }

    @Override
    public void delete(String id) {
        try {
            long apiCount = this.apiService.findByUser(id, null, false).stream().filter(entity -> entity.getPrimaryOwner().getId().equals(id)).count();
            long applicationCount = this.applicationService.findByUser(id).stream().filter(app -> app.getPrimaryOwner() != null).filter(app -> app.getPrimaryOwner().getId().equals(id)).count();
            if (apiCount > 0L || applicationCount > 0L) {
                throw new StillPrimaryOwnerException(apiCount, applicationCount);
            }
            Optional optionalUser = this.userRepository.findById((Object)id);
            if (!optionalUser.isPresent()) {
                throw new UserNotFoundException(id);
            }
            this.membershipService.removeMemberMemberships(MembershipMemberType.USER, id);
            User user = (User)optionalUser.get();
            this.portalNotificationService.deleteAll(user.getId());
            this.portalNotificationConfigService.deleteByUser(user.getId());
            this.genericNotificationConfigService.deleteByUser(user);
            this.tokenService.revokeByUser(user.getId());
            user.setSourceId("deleted-" + user.getSourceId());
            user.setStatus(UserStatus.ARCHIVED);
            user.setUpdatedAt(new Date());
            if (this.anonymizeOnDelete) {
                User anonym = new User();
                anonym.setId(user.getId());
                anonym.setCreatedAt(user.getCreatedAt());
                anonym.setUpdatedAt(user.getUpdatedAt());
                anonym.setStatus(user.getStatus());
                anonym.setSource(user.getSource());
                anonym.setLastConnectionAt(user.getLastConnectionAt());
                anonym.setSourceId("deleted-" + user.getId());
                anonym.setFirstname("Unknown");
                anonym.setLastname("");
                anonym.setLoginCount(user.getLoginCount());
                user = anonym;
            }
            this.userRepository.update((Object)user);
            UserEntity userEntity = this.convert((User)optionalUser.get(), false);
            this.searchEngineService.delete((Indexable)userEntity, false);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete user", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete user", ex);
        }
    }

    @Override
    public void resetPassword(String id) {
        this.resetPassword(id, null);
    }

    @Override
    public UserEntity resetPasswordFromSourceId(String sourceId, String resetPageUrl) {
        if (sourceId.startsWith("deleted")) {
            throw new UserNotActiveException(sourceId);
        }
        UrlSanitizerUtils.checkAllowed(resetPageUrl, this.portalWhitelist, true);
        UserEntity foundUser = this.findBySource(IDP_SOURCE_GRAVITEE, sourceId, false);
        if ("ACTIVE".equals(foundUser.getStatus())) {
            this.resetPassword(foundUser.getId(), resetPageUrl);
            return foundUser;
        }
        throw new UserNotActiveException(foundUser.getSourceId());
    }

    private boolean isInternalUser(User user) {
        return IDP_SOURCE_GRAVITEE.equals(user.getSource());
    }

    private void resetPassword(String id, String resetPageUrl) {
        try {
            LOGGER.debug("Resetting password of user id {}", (Object)id);
            Optional optionalUser = this.userRepository.findById((Object)id);
            if (!optionalUser.isPresent()) {
                throw new UserNotFoundException(id);
            }
            User user = (User)optionalUser.get();
            if (!this.isInternalUser(user)) {
                throw new UserNotInternallyManagedException(id);
            }
            if (!this.isAuthenticated() || !this.canResetPassword()) {
                AuditQuery query = new AuditQuery();
                query.setEvents(Arrays.asList(User.AuditEvent.PASSWORD_RESET.name()));
                query.setFrom(Instant.now().minus(1L, ChronoUnit.HOURS).toEpochMilli());
                query.setPage(1);
                query.setSize(100);
                MetadataPage<AuditEntity> events = this.auditService.search(query);
                if (events != null) {
                    Optional<AuditEntity> optReset;
                    if (events.getContent().size() == 100) {
                        LOGGER.warn("More than 100 reset password received in less than 1 hour", (Object)user.getId());
                    }
                    if ((optReset = events.getContent().stream().filter(evt -> user.getId().equals(evt.getProperties().get(Audit.AuditProperties.USER.name()))).findFirst()).isPresent()) {
                        LOGGER.warn("Multiple reset password received for user '{}' in less than 1 hour", (Object)user.getId());
                        throw new PasswordAlreadyResetException();
                    }
                }
            }
            Map<String, Object> params = this.getTokenRegistrationParams(this.convert(user, false), "/#!/resetPassword/", JWTHelper.ACTION.RESET_PASSWORD, resetPageUrl);
            this.notifierService.trigger(PortalHook.PASSWORD_RESET, params);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.PASSWORD_RESET, new Date(), null, null);
            this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(user.getEmail()).template(EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_USER_PASSWORD_RESET).params(params).build(), GraviteeContext.getCurrentContext());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to reset password for user " + id;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    protected boolean canResetPassword() {
        if (this.isAdmin()) {
            return true;
        }
        return this.permissionService.hasPermission(RolePermission.ORGANIZATION_USERS, GraviteeContext.getCurrentOrganization(), RolePermissionAction.UPDATE);
    }

    private User convert(NewExternalUserEntity newExternalUserEntity) {
        if (newExternalUserEntity == null) {
            return null;
        }
        User user = new User();
        user.setEmail(newExternalUserEntity.getEmail());
        user.setFirstname(newExternalUserEntity.getFirstname());
        user.setLastname(newExternalUserEntity.getLastname());
        user.setSource(newExternalUserEntity.getSource());
        user.setSourceId(newExternalUserEntity.getSourceId());
        user.setStatus(UserStatus.ACTIVE);
        user.setPicture(newExternalUserEntity.getPicture());
        user.setNewsletterSubscribed(newExternalUserEntity.getNewsletter());
        return user;
    }

    private User convert(UserEntity userEntity) {
        if (userEntity == null) {
            return null;
        }
        User user = new User();
        user.setId(userEntity.getId());
        user.setEmail(userEntity.getEmail());
        user.setFirstname(userEntity.getFirstname());
        user.setLastname(userEntity.getLastname());
        user.setSource(userEntity.getSource());
        user.setSourceId(userEntity.getSourceId());
        if (userEntity.getStatus() != null) {
            user.setStatus(UserStatus.valueOf((String)userEntity.getStatus()));
        }
        return user;
    }

    private UserEntity convert(User user, boolean loadRoles) {
        return this.convert(user, loadRoles, Collections.emptyList());
    }

    private UserEntity convert(User user, boolean loadRoles, List<UserMetadataEntity> customUserFields) {
        if (user == null) {
            return null;
        }
        UserEntity userEntity = new UserEntity();
        String userId = user.getId();
        userEntity.setId(userId);
        userEntity.setSource(user.getSource());
        userEntity.setSourceId(user.getSourceId());
        userEntity.setEmail(user.getEmail());
        userEntity.setFirstname(user.getFirstname());
        userEntity.setLastname(user.getLastname());
        userEntity.setPassword(user.getPassword());
        userEntity.setCreatedAt(user.getCreatedAt());
        userEntity.setUpdatedAt(user.getUpdatedAt());
        userEntity.setLastConnectionAt(user.getLastConnectionAt());
        userEntity.setFirstConnectionAt(user.getFirstConnectionAt());
        userEntity.setPicture(user.getPicture());
        if (user.getStatus() != null) {
            userEntity.setStatus(user.getStatus().name());
        }
        if (loadRoles) {
            HashSet roles = new HashSet();
            Set<RoleEntity> roleEntities = this.membershipService.getRoles(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), MembershipMemberType.USER, userId);
            if (!roleEntities.isEmpty()) {
                roleEntities.forEach(roleEntity -> roles.add(this.convert((RoleEntity)roleEntity)));
            }
            this.environmentService.findByOrganization(GraviteeContext.getCurrentOrganization()).stream().flatMap(env -> this.membershipService.getRoles(MembershipReferenceType.ENVIRONMENT, env.getId(), MembershipMemberType.USER, userId).stream()).filter(Objects::nonNull).forEach(roleEntity -> roles.add(this.convert((RoleEntity)roleEntity)));
            userEntity.setRoles(roles);
            HashMap envRolesMap = new HashMap();
            this.environmentService.findByOrganization(GraviteeContext.getCurrentOrganization()).forEach(env -> {
                HashSet envRoles = new HashSet();
                Set<RoleEntity> envRoleEntities = this.membershipService.getRoles(MembershipReferenceType.ENVIRONMENT, env.getId(), MembershipMemberType.USER, userId);
                if (!envRoleEntities.isEmpty()) {
                    envRoleEntities.forEach(roleEntity -> envRoles.add(this.convert((RoleEntity)roleEntity)));
                }
                envRolesMap.put(env.getId(), envRoles);
            });
            userEntity.setEnvRoles(envRolesMap);
        }
        userEntity.setLoginCount(user.getLoginCount());
        userEntity.setNewsletterSubscribed(user.getNewsletterSubscribed());
        if (customUserFields != null && !customUserFields.isEmpty()) {
            Maps.MapBuilder builder = Maps.builder();
            for (UserMetadataEntity meta : customUserFields) {
                builder.put((Object)meta.getKey(), (Object)meta.getValue());
            }
            userEntity.setCustomFields(builder.build());
        }
        return userEntity;
    }

    private UserRoleEntity convert(RoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        UserRoleEntity userRoleEntity = new UserRoleEntity();
        userRoleEntity.setId(roleEntity.getId());
        userRoleEntity.setScope(roleEntity.getScope());
        userRoleEntity.setName(roleEntity.getName());
        userRoleEntity.setPermissions(roleEntity.getPermissions());
        return userRoleEntity;
    }

    @Override
    public UserEntity createOrUpdateUserFromSocialIdentityProvider(SocialIdentityProviderEntity socialProvider, String userInfo) {
        HashMap<String, String> attrs = this.getUserProfileAttrs(socialProvider.getUserProfileMapping(), userInfo);
        String email = attrs.get("email");
        if (email == null && socialProvider.isEmailRequired()) {
            throw new EmailRequiredException(attrs.get("id"));
        }
        Set<GroupEntity> userGroups = this.computeUserGroupsFromProfile(email, socialProvider.getGroupMappings(), userInfo);
        Set<RoleEntity> userRoles = this.computeUserRolesFromProfile(email, socialProvider.getRoleMappings(), userInfo);
        UserEntity user = null;
        boolean created = false;
        try {
            user = this.refreshExistingUser(socialProvider, attrs, email);
        }
        catch (UserNotFoundException unfe) {
            created = true;
            user = this.createNewExternalUser(socialProvider, userInfo, attrs, email);
        }
        List<MembershipService.Membership> groupMemberships = this.refreshUserGroups(user.getId(), socialProvider.getId(), userGroups);
        List<MembershipService.Membership> envRoleMemberships = this.refreshUserRoles(user.getId(), socialProvider.getId(), userRoles, RoleScope.ENVIRONMENT);
        List<MembershipService.Membership> orgRoleMemberships = this.refreshUserRoles(user.getId(), socialProvider.getId(), userRoles, RoleScope.ORGANIZATION);
        if (created || socialProvider.isSyncMappings()) {
            boolean hasGroupMapping = socialProvider.getGroupMappings() != null && !socialProvider.getGroupMappings().isEmpty();
            this.refreshUserMemberships(user.getId(), socialProvider.getId(), groupMemberships, hasGroupMapping, MembershipReferenceType.GROUP);
            boolean hasRoleMapping = socialProvider.getRoleMappings() != null && !socialProvider.getRoleMappings().isEmpty();
            this.refreshUserMemberships(user.getId(), socialProvider.getId(), orgRoleMemberships, hasRoleMapping, MembershipReferenceType.ORGANIZATION);
            this.refreshUserMemberships(user.getId(), socialProvider.getId(), envRoleMemberships, hasRoleMapping, MembershipReferenceType.ENVIRONMENT);
        }
        return user;
    }

    private HashMap<String, String> getUserProfileAttrs(Map<String, String> userProfileMapping, String userInfo) {
        TemplateEngine templateEngine = TemplateEngine.templateEngine();
        templateEngine.getTemplateContext().setVariable(TEMPLATE_ENGINE_PROFILE_ATTRIBUTE, (Object)userInfo);
        DocumentContext userInfoPath = JsonPath.parse((String)userInfo);
        HashMap<String, String> map = new HashMap<String, String>(userProfileMapping.size());
        for (Map.Entry<String, String> entry : userProfileMapping.entrySet()) {
            String field = entry.getKey();
            String mapping = entry.getValue();
            if (mapping == null) continue;
            try {
                if (mapping.contains("{#")) {
                    map.put(field, (String)templateEngine.getValue(mapping, String.class));
                    continue;
                }
                map.put(field, (String)userInfoPath.read(mapping, String.class, new Predicate[0]));
            }
            catch (Exception e) {
                LOGGER.error("Using mapping: \"{}\", no fields are located in {}", (Object)mapping, (Object)userInfo);
            }
        }
        return map;
    }

    private UserEntity createNewExternalUser(SocialIdentityProviderEntity socialProvider, String userInfo, HashMap<String, String> attrs, String email) {
        NewExternalUserEntity newUser = new NewExternalUserEntity();
        newUser.setEmail(email);
        newUser.setSource(socialProvider.getId());
        if (attrs.get("id") != null) {
            newUser.setSourceId(attrs.get("id"));
        }
        if (attrs.get("lastname") != null) {
            newUser.setLastname(attrs.get("lastname"));
        }
        if (attrs.get("firstname") != null) {
            newUser.setFirstname(attrs.get("firstname"));
        }
        if (attrs.get("picture") != null) {
            newUser.setPicture(attrs.get("picture"));
        }
        return this.create(newUser, false);
    }

    private UserEntity refreshExistingUser(SocialIdentityProviderEntity socialProvider, HashMap<String, String> attrs, String email) {
        UserEntity registeredUser = this.findBySource(socialProvider.getId(), attrs.get("id"), false);
        String userId = registeredUser.getId();
        UpdateUserEntity user = new UpdateUserEntity();
        if (attrs.get("lastname") != null) {
            user.setLastname(attrs.get("lastname"));
        }
        if (attrs.get("firstname") != null) {
            user.setFirstname(attrs.get("firstname"));
        }
        if (attrs.get("picture") != null) {
            user.setPicture(attrs.get("picture"));
        }
        user.setEmail(email);
        return this.update(userId, user);
    }

    private void addRolesToUser(String userId, Collection<RoleEntity> rolesToAdd, MembershipReferenceType referenceType, String referenceId) {
        for (RoleEntity roleEntity : rolesToAdd) {
            MembershipService.MembershipReference ref = null;
            ref = referenceType != null && referenceId != null ? new MembershipService.MembershipReference(referenceType, referenceId) : (roleEntity.getScope() == RoleScope.ORGANIZATION ? new MembershipService.MembershipReference(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization()) : new MembershipService.MembershipReference(MembershipReferenceType.ENVIRONMENT, GraviteeContext.getCurrentEnvironment()));
            this.membershipService.addRoleToMemberOnReference(ref, new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.valueOf((String)roleEntity.getScope().name()), roleEntity.getName()));
        }
    }

    private void trace(String userId, boolean match, String condition) {
        if (LOGGER.isDebugEnabled()) {
            if (match) {
                LOGGER.debug("the expression {} match {} on user's info ", (Object)condition, (Object)userId);
            } else {
                LOGGER.debug("the expression {} didn't match {} on user's info ", (Object)condition, (Object)userId);
            }
        }
    }

    private Set<GroupEntity> computeUserGroupsFromProfile(String userId, List<GroupMappingEntity> mappings, String userInfo) {
        if (mappings == null || mappings.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<GroupEntity> groups = new HashSet<GroupEntity>();
        for (GroupMappingEntity mapping : mappings) {
            TemplateEngine templateEngine = TemplateEngine.templateEngine();
            templateEngine.getTemplateContext().setVariable(TEMPLATE_ENGINE_PROFILE_ATTRIBUTE, (Object)userInfo);
            boolean match = (Boolean)templateEngine.getValue(mapping.getCondition(), Boolean.TYPE);
            this.trace(userId, match, mapping.getCondition());
            if (!match) continue;
            for (String groupName : mapping.getGroups()) {
                try {
                    groups.add(this.groupService.findById(groupName));
                }
                catch (GroupNotFoundException gnfe) {
                    LOGGER.warn("Unable to map user groups, missing group in repository: {}", (Object)groupName);
                }
            }
        }
        return groups;
    }

    private Set<RoleEntity> computeUserRolesFromProfile(String userId, List<RoleMappingEntity> mappings, String userInfo) {
        boolean hasRoleEnvironment;
        if (mappings == null || mappings.isEmpty()) {
            return new HashSet<RoleEntity>(this.roleService.findDefaultRoleByScopes(RoleScope.ORGANIZATION, RoleScope.ENVIRONMENT));
        }
        HashSet<RoleEntity> roles = new HashSet<RoleEntity>();
        for (RoleMappingEntity mapping : mappings) {
            TemplateEngine templateEngine = TemplateEngine.templateEngine();
            templateEngine.getTemplateContext().setVariable(TEMPLATE_ENGINE_PROFILE_ATTRIBUTE, (Object)userInfo);
            boolean match = (Boolean)templateEngine.getValue(mapping.getCondition(), Boolean.TYPE);
            this.trace(userId, match, mapping.getCondition());
            if (!match) continue;
            if (mapping.getEnvironments() != null) {
                try {
                    mapping.getEnvironments().forEach(env -> this.roleService.findByScopeAndName(RoleScope.ENVIRONMENT, (String)env).ifPresent(roles::add));
                }
                catch (RoleNotFoundException rnfe) {
                    LOGGER.warn("Unable to map user role on scope ENVIRONMENT, missing role in repository: {}", (Object)mapping.getEnvironments());
                }
            }
            if (mapping.getOrganizations() == null) continue;
            try {
                mapping.getOrganizations().forEach(org -> this.roleService.findByScopeAndName(RoleScope.ORGANIZATION, (String)org).ifPresent(roles::add));
            }
            catch (RoleNotFoundException rnfe) {
                LOGGER.warn("Unable to map user role on scope ORGANIZATION, missing role in repository: {}", (Object)mapping.getOrganizations());
            }
        }
        boolean hasRoleOrganization = roles.stream().anyMatch(r -> RoleScope.ORGANIZATION.equals((Object)r.getScope()));
        if (!hasRoleOrganization) {
            roles.addAll(new HashSet<RoleEntity>(this.roleService.findDefaultRoleByScopes(RoleScope.ORGANIZATION)));
        }
        if (!(hasRoleEnvironment = roles.stream().anyMatch(r -> RoleScope.ENVIRONMENT.equals((Object)r.getScope())))) {
            roles.addAll(new HashSet<RoleEntity>(this.roleService.findDefaultRoleByScopes(RoleScope.ENVIRONMENT)));
        }
        return roles;
    }

    private List<MembershipService.Membership> refreshUserGroups(String userId, String identityProviderId, Collection<GroupEntity> userGroups) {
        ArrayList<MembershipService.Membership> memberships = new ArrayList<MembershipService.Membership>();
        List<RoleEntity> roleEntities = this.roleService.findDefaultRoleByScopes(RoleScope.API, RoleScope.APPLICATION);
        for (GroupEntity groupEntity : userGroups) {
            for (RoleEntity roleEntity : roleEntities) {
                String groupDefaultRole;
                String defaultRole = roleEntity.getName();
                if (groupEntity.getRoles() != null && (groupDefaultRole = (String)groupEntity.getRoles().get(RoleScope.valueOf((String)roleEntity.getScope().name()))) != null) {
                    defaultRole = groupDefaultRole;
                }
                MembershipService.Membership membership = new MembershipService.Membership(new MembershipService.MembershipReference(MembershipReferenceType.GROUP, groupEntity.getId()), new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(roleEntity.getScope(), defaultRole));
                membership.setSource(identityProviderId);
                memberships.add(membership);
            }
        }
        return memberships;
    }

    private List<MembershipService.Membership> refreshUserRoles(String userId, String identityProviderId, Collection<RoleEntity> userRoles, RoleScope scope) {
        return userRoles.stream().filter(role -> role.getScope().equals((Object)scope)).map(roleEntity -> {
            MembershipService.Membership membership = new MembershipService.Membership(new MembershipService.MembershipReference(RoleScope.ENVIRONMENT == roleEntity.getScope() ? MembershipReferenceType.ENVIRONMENT : MembershipReferenceType.ORGANIZATION, RoleScope.ENVIRONMENT == roleEntity.getScope() ? GraviteeContext.getCurrentEnvironmentOrDefault() : GraviteeContext.getCurrentOrganization()), new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.valueOf((String)roleEntity.getScope().name()), roleEntity.getName()));
            membership.setSource(identityProviderId);
            return membership;
        }).collect(Collectors.toList());
    }

    private void refreshUserMemberships(String userId, String identityProviderId, List<MembershipService.Membership> memberships, boolean hasMapping, MembershipReferenceType ... types) {
        ArrayList userMemberships = new ArrayList();
        for (MembershipReferenceType type : types) {
            try {
                userMemberships.addAll(this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType(userId, io.gravitee.repository.management.model.MembershipMemberType.USER, io.gravitee.repository.management.model.MembershipReferenceType.valueOf((String)type.name())));
            }
            catch (TechnicalException e) {
                String msg = "An error occurs while finding memberships for user " + userId;
                LOGGER.error(msg, (Throwable)e);
                throw new TechnicalManagementException(msg, e);
            }
        }
        ArrayList overrideUserMemberships = new ArrayList();
        userMemberships.forEach(membership -> {
            if (identityProviderId.equals(membership.getSource())) {
                if (hasMapping) {
                    this.membershipService.deleteReferenceMemberBySource(MembershipReferenceType.valueOf((String)membership.getReferenceType().name()), membership.getReferenceId(), MembershipMemberType.USER, userId, membership.getSource());
                }
            } else {
                overrideUserMemberships.add(membership);
            }
        });
        HashMap<MembershipService.MembershipReference, Map> groupedRoles = new HashMap<MembershipService.MembershipReference, Map>();
        memberships.stream().filter(membership -> !this.containsMembership(overrideUserMemberships, (MembershipService.Membership)membership)).forEach(membership -> groupedRoles.computeIfAbsent(membership.getReference(), ignore -> new HashMap()).computeIfAbsent(membership.getMember(), ignore -> new HashMap()).computeIfAbsent(membership.getSource(), ignore -> new ArrayList()).add(membership.getRole()));
        groupedRoles.forEach((reference, memberMapping) -> memberMapping.forEach((member, sourceMapping) -> sourceMapping.forEach((source, roles) -> this.membershipService.updateRolesToMemberOnReferenceBySource((MembershipService.MembershipReference)reference, (MembershipService.MembershipMember)member, (Collection<MembershipService.MembershipRole>)roles, (String)source))));
    }

    private boolean containsMembership(List<Membership> overrideUserMemberships, MembershipService.Membership membership) {
        return overrideUserMemberships.stream().anyMatch(membership1 -> {
            if (membership1.getReferenceId().equals(membership.getReference().getId())) {
                RoleEntity byId = this.roleService.findById(membership1.getRoleId());
                return membership.getRole().getScope().equals((Object)byId.getScope());
            }
            return false;
        });
    }

    @Override
    public void updateUserRoles(String userId, MembershipReferenceType referenceType, String referenceId, List<String> roleIds) {
        this.findById(userId);
        MemberEntity userMember = this.membershipService.getUserMember(referenceType, referenceId, userId);
        if (userMember != null) {
            userMember.getRoles().forEach(role -> {
                if (!roleIds.contains(role.getId())) {
                    this.membershipService.removeRole(referenceType, referenceId, MembershipMemberType.USER, userId, role.getId());
                } else {
                    roleIds.remove(role.getId());
                }
            });
        }
        if (!roleIds.isEmpty()) {
            this.addRolesToUser(userId, roleIds.stream().map(this.roleService::findById).filter(role -> role.getScope().equals((Object)RoleScope.valueOf((String)referenceType.name()))).collect(Collectors.toSet()), referenceType, referenceId);
        }
    }

    static {
        try {
            LOGGER.trace("Loading class to initialize properly JsonPath Cache provider: {}", Class.forName(JsonPathFunction.class.getName()));
        }
        catch (ClassNotFoundException ignored) {
            LOGGER.trace("Loading class to initialize properly JsonPath Cache provider : fail");
        }
    }
}

