/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.DashboardRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Dashboard;
import io.gravitee.repository.management.model.DashboardReferenceType;
import io.gravitee.rest.api.model.DashboardEntity;
import io.gravitee.rest.api.model.NewDashboardEntity;
import io.gravitee.rest.api.model.UpdateDashboardEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.DashboardService;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.exceptions.DashboardNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DashboardServiceImpl
extends AbstractService
implements DashboardService {
    private final Logger LOGGER = LoggerFactory.getLogger(DashboardServiceImpl.class);
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public List<DashboardEntity> findAll() {
        try {
            this.LOGGER.debug("Find all dashboards");
            return this.dashboardRepository.findAll().stream().map(this::convert).sorted(Comparator.comparingInt(DashboardEntity::getOrder)).sorted(Comparator.comparing(DashboardEntity::getReferenceType)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find all dashboards";
            this.LOGGER.error("An error occurs while trying to find all dashboards", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all dashboards", ex);
        }
    }

    @Override
    public List<DashboardEntity> findByReferenceType(DashboardReferenceType referenceType) {
        try {
            this.LOGGER.debug("Find all dashboards by reference type");
            return this.dashboardRepository.findByReferenceType(referenceType.name()).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find all dashboards by reference type";
            this.LOGGER.error("An error occurs while trying to find all dashboards by reference type", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all dashboards by reference type", ex);
        }
    }

    @Override
    public DashboardEntity findById(String dashboardId) {
        try {
            this.LOGGER.debug("Find dashboard by ID: {}", (Object)dashboardId);
            Optional optDashboard = this.dashboardRepository.findById((Object)dashboardId);
            if (!optDashboard.isPresent()) {
                throw new DashboardNotFoundException(dashboardId);
            }
            return this.convert((Dashboard)optDashboard.get());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find dashboard by ID";
            this.LOGGER.error("An error occurs while trying to find dashboard by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find dashboard by ID", ex);
        }
    }

    @Override
    public DashboardEntity create(NewDashboardEntity dashboardEntity) {
        try {
            List dashboards = this.dashboardRepository.findByReferenceType(dashboardEntity.getReferenceType().name());
            Dashboard dashboard = (Dashboard)this.dashboardRepository.create((Object)this.convert(dashboardEntity, dashboards));
            this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.DASHBOARD, dashboard.getId()), (Audit.AuditEvent)Dashboard.AuditEvent.DASHBOARD_CREATED, dashboard.getCreatedAt(), null, dashboard);
            return this.convert(dashboard);
        }
        catch (TechnicalException ex) {
            String error = "An error occurred while trying to create dashboard " + dashboardEntity;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public DashboardEntity update(UpdateDashboardEntity dashboardEntity) {
        try {
            Optional dashboardOptional = this.dashboardRepository.findById((Object)dashboardEntity.getId());
            if (dashboardOptional.isPresent()) {
                Dashboard dashboard = this.convert(dashboardEntity);
                DashboardEntity savedDashboard = dashboard.getOrder() != ((Dashboard)dashboardOptional.get()).getOrder() ? this.reorderAndSaveDashboards(dashboard, false) : this.convert((Dashboard)this.dashboardRepository.update((Object)dashboard));
                this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.DASHBOARD, dashboard.getId()), (Audit.AuditEvent)Dashboard.AuditEvent.DASHBOARD_UPDATED, new Date(), dashboardOptional.get(), dashboard);
                return savedDashboard;
            }
            throw new DashboardNotFoundException(dashboardEntity.getId());
        }
        catch (TechnicalException ex) {
            String error = "An error occurred while trying to update dashboard " + dashboardEntity;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    private DashboardEntity reorderAndSaveDashboards(Dashboard dashboardToReorder, boolean deleted) throws TechnicalException {
        List dashboards = this.dashboardRepository.findByReferenceType(dashboardToReorder.getReferenceType());
        Dashboard[] dashboardsToReorder = (Dashboard[])dashboards.stream().filter(d -> !Objects.equals(d.getId(), dashboardToReorder.getId())).toArray(Dashboard[]::new);
        if (dashboardToReorder.getOrder() < 1) {
            dashboardToReorder.setOrder(1);
        } else if (dashboardToReorder.getOrder() > dashboardsToReorder.length + 1) {
            dashboardToReorder.setOrder(dashboardsToReorder.length + 1);
        }
        try {
            for (int i = 0; i < dashboardsToReorder.length; ++i) {
                int newOrder;
                if (deleted) {
                    if (dashboardsToReorder[i].getOrder() <= dashboardToReorder.getOrder()) continue;
                    dashboardsToReorder[i].setOrder(dashboardsToReorder[i].getOrder() - 1);
                    this.dashboardRepository.update((Object)dashboardsToReorder[i]);
                    continue;
                }
                int n = newOrder = i + 1 < dashboardToReorder.getOrder() ? i + 1 : i + 2;
                if (dashboardsToReorder[i].getOrder() == newOrder) continue;
                dashboardsToReorder[i].setOrder(newOrder);
                this.dashboardRepository.update((Object)dashboardsToReorder[i]);
            }
            if (deleted) {
                return null;
            }
            return this.convert((Dashboard)this.dashboardRepository.update((Object)dashboardToReorder));
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to update dashboard " + dashboardToReorder.getId();
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public void delete(String dashboardId) {
        try {
            Optional dashboardOptional = this.dashboardRepository.findById((Object)dashboardId);
            if (dashboardOptional.isPresent()) {
                this.dashboardRepository.delete((Object)dashboardId);
                this.reorderAndSaveDashboards((Dashboard)dashboardOptional.get(), true);
                this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.DASHBOARD, dashboardId), (Audit.AuditEvent)Dashboard.AuditEvent.DASHBOARD_DELETED, new Date(), null, dashboardOptional.get());
            }
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to delete dashboard " + dashboardId;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    private Dashboard convert(NewDashboardEntity dashboardEntity, List<Dashboard> dashboards) {
        Dashboard dashboard = new Dashboard();
        dashboard.setId(RandomString.generate());
        dashboard.setReferenceId(dashboardEntity.getReferenceId());
        dashboard.setReferenceType(dashboardEntity.getReferenceType().name());
        dashboard.setName(dashboardEntity.getName());
        dashboard.setQueryFilter(dashboardEntity.getQueryFilter());
        dashboard.setEnabled(dashboardEntity.isEnabled());
        dashboard.setDefinition(dashboardEntity.getDefinition());
        if (dashboards == null || dashboards.isEmpty()) {
            dashboard.setOrder(1);
        } else {
            dashboard.setOrder(dashboards.stream().max(Comparator.comparingInt(Dashboard::getOrder)).map(Dashboard::getOrder).get() + 1);
        }
        Date now = new Date();
        dashboard.setCreatedAt(now);
        dashboard.setUpdatedAt(now);
        return dashboard;
    }

    private Dashboard convert(UpdateDashboardEntity dashboardEntity) {
        Dashboard dashboard = new Dashboard();
        dashboard.setId(dashboardEntity.getId());
        dashboard.setReferenceId(dashboardEntity.getReferenceId());
        dashboard.setReferenceType(dashboardEntity.getReferenceType().name());
        dashboard.setName(dashboardEntity.getName());
        dashboard.setQueryFilter(dashboardEntity.getQueryFilter());
        dashboard.setOrder(dashboardEntity.getOrder());
        dashboard.setEnabled(dashboardEntity.isEnabled());
        dashboard.setDefinition(dashboardEntity.getDefinition());
        dashboard.setUpdatedAt(new Date());
        return dashboard;
    }

    private DashboardEntity convert(Dashboard dashboard) {
        DashboardEntity dashboardEntity = new DashboardEntity();
        dashboardEntity.setId(dashboard.getId());
        dashboardEntity.setReferenceId(dashboard.getReferenceId());
        dashboardEntity.setReferenceType(dashboard.getReferenceType());
        dashboardEntity.setName(dashboard.getName());
        dashboardEntity.setQueryFilter(dashboard.getQueryFilter());
        dashboardEntity.setOrder(dashboard.getOrder());
        dashboardEntity.setEnabled(dashboard.isEnabled());
        dashboardEntity.setDefinition(dashboard.getDefinition());
        dashboardEntity.setCreatedAt(dashboard.getCreatedAt());
        dashboardEntity.setUpdatedAt(dashboard.getUpdatedAt());
        return dashboardEntity;
    }
}

