/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class MembershipAlreadyExistsException
extends AbstractManagementException {
    private final String memberId;
    private final MembershipMemberType memberType;
    private final String referenceId;
    private final MembershipReferenceType referenceType;

    public MembershipAlreadyExistsException(String memberId, MembershipMemberType memberType, String referenceId, MembershipReferenceType referenceType) {
        this.memberId = memberId;
        this.memberType = memberType;
        this.referenceId = referenceId;
        this.referenceType = referenceType;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "A Membership for member : " + this.memberType + " " + this.memberId + " and ref : " + this.referenceType + " " + this.referenceId + " already exists.";
    }

    @Override
    public String getTechnicalCode() {
        return "api.exists";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("memberId", MembershipAlreadyExistsException.this.memberId);
                this.put("memberType", MembershipAlreadyExistsException.this.memberType.name());
                this.put("referenceId", MembershipAlreadyExistsException.this.referenceId);
                this.put("referenceType", MembershipAlreadyExistsException.this.referenceType.name());
            }
        };
    }
}

